/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp;

import java.util.ArrayList;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeParser;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeType;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class PolygonParser
extends ShapeParser {
    private final ShapeType shapeType;

    public PolygonParser(GeometryFactory geometryFactory, ShapeType shapeType) {
        super(geometryFactory);
        this.shapeType = shapeType;
    }

    @Override
    public Geometry parseShape(ShapeReader reader) {
        reader.skip(32);
        int numRings = reader.readInt();
        int numPoints = reader.readInt();
        int[] offsets = this.readOffsets(reader, numRings, numPoints);
        Coordinate[] allCoordinates = this.shapeType == ShapeType.POLYGONZ ? this.readCoordinatesWithZM(reader, numPoints) : (this.shapeType == ShapeType.POLYGONM ? this.readCoordinatesWithM(reader, numPoints) : this.readCoordinates(reader, numPoints));
        boolean shellsCCW = false;
        LinearRing shell = null;
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < numRings; ++i) {
            int endIndex = offsets[i + 1];
            int startIndex = offsets[i];
            int pointCount = endIndex - startIndex;
            if (pointCount <= 3) continue;
            Coordinate[] ringCoordinates = new Coordinate[pointCount];
            System.arraycopy(allCoordinates, startIndex, ringCoordinates, 0, pointCount);
            LinearRing ring = this.geometryFactory.createLinearRing(ringCoordinates);
            if (shell == null) {
                shell = ring;
                shellsCCW = Orientation.isCCW((Coordinate[])ringCoordinates);
                continue;
            }
            if (Orientation.isCCW((Coordinate[])ringCoordinates) != shellsCCW) {
                holes.add(ring);
                continue;
            }
            Polygon polygon = this.geometryFactory.createPolygon(shell, GeometryFactory.toLinearRingArray(holes));
            polygons.add(polygon);
            shell = ring;
            holes.clear();
        }
        if (shell != null) {
            Polygon polygon = this.geometryFactory.createPolygon(shell, GeometryFactory.toLinearRingArray(holes));
            polygons.add(polygon);
        }
        if (polygons.size() == 1) {
            return (Geometry)polygons.get(0);
        }
        return this.geometryFactory.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }
}

