/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp;

import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeParser;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class PointParser
extends ShapeParser {
    private final ShapeType shapeType;

    public PointParser(GeometryFactory geometryFactory, ShapeType shapeType) {
        super(geometryFactory);
        this.shapeType = shapeType;
    }

    @Override
    public Geometry parseShape(ShapeReader reader) {
        double x = reader.readDouble();
        double y = reader.readDouble();
        if (this.shapeType == ShapeType.POINTZ) {
            double z = reader.readDouble();
            double m = reader.readDouble();
            if (PointParser.isNoData(m)) {
                return this.geometryFactory.createPoint(new Coordinate(x, y, z));
            }
            return this.geometryFactory.createPoint((Coordinate)new CoordinateXYZM(x, y, z, m));
        }
        if (this.shapeType == ShapeType.POINTM) {
            double m = reader.readDouble();
            if (PointParser.isNoData(m)) {
                return this.geometryFactory.createPoint(new Coordinate(x, y));
            }
            return this.geometryFactory.createPoint((Coordinate)new CoordinateXYM(x, y, m));
        }
        return this.geometryFactory.createPoint(new Coordinate(x, y));
    }
}

