/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.write.ChunkingIndex;
import ucar.nc2.write.NetcdfFileFormat;
import ucar.nc2.write.NetcdfFormatWriter;

public class NetcdfCopier {
    private static final Logger log = LoggerFactory.getLogger(NetcdfCopier.class);
    private static final long maxSize = 50000000L;
    private static boolean debug;
    private static boolean debugWrite;
    private final NetcdfFile fileIn;
    private final NetcdfFormatWriter.Builder writerb;
    private final boolean extended;

    public static void setDebugFlags(DebugFlags debugFlags) {
        debug = debugFlags.isSet("ncfileWriter/debug");
        debugWrite = debugFlags.isSet("ncfileWriter/debugWrite");
    }

    public static NetcdfCopier create(NetcdfFile fileIn, NetcdfFormatWriter.Builder ncwriter) {
        Preconditions.checkNotNull(fileIn);
        Preconditions.checkNotNull(ncwriter);
        return new NetcdfCopier(fileIn, ncwriter);
    }

    private NetcdfCopier(NetcdfFile fileIn, NetcdfFormatWriter.Builder writerb) {
        this.fileIn = fileIn;
        this.writerb = writerb;
        this.extended = this.getOutputFormat().isExtendedModel();
        if (!fileIn.getRootGroup().getGroups().isEmpty() && !this.extended) {
            throw new IllegalStateException("Input file has nested groups: cannot write to format= " + (Object)((Object)this.getOutputFormat()));
        }
    }

    private NetcdfFileFormat getOutputFormat() {
        return this.writerb.getFormat();
    }

    public NetcdfFile write(@Nullable CancelTask cancel) throws IOException {
        if (cancel == null) {
            cancel = CancelTask.create();
        }
        Group.Builder root = this.copyGroup(this.fileIn.getRootGroup(), null);
        this.writerb.setRootGroup(root);
        if (cancel.isCancel()) {
            return null;
        }
        try (NetcdfFormatWriter ncwriter = this.writerb.build();){
            if (cancel.isCancel()) {
                NetcdfFile netcdfFile = null;
                return netcdfFile;
            }
            Count counter = new Count();
            this.copyVariableData(ncwriter, this.fileIn.getRootGroup(), ncwriter.getOutputFile().getRootGroup(), counter, cancel);
            if (cancel.isCancel()) {
                NetcdfFile netcdfFile = null;
                return netcdfFile;
            }
            ncwriter.flush();
            System.out.format("FileCopier done: total bytes written = %d, number of variables = %d%n", counter.bytes, counter.countVars);
            cancel.setSuccess();
            NetcdfFile netcdfFile = ncwriter.getOutputFile();
            return netcdfFile;
        }
    }

    private Group.Builder copyGroup(Group oldGroup, Group.Builder parent) throws IOException {
        Group.Builder newGroup = Group.builder().setParentGroup(parent).setName(oldGroup.getShortName());
        if (debug) {
            System.out.println("add group= " + oldGroup.getShortName());
        }
        for (Attribute att : oldGroup.attributes()) {
            newGroup.addAttribute(this.convertAttribute(att));
            if (!debug) continue;
            System.out.println("add groupAtt= " + att);
        }
        for (EnumTypedef td : oldGroup.getEnumTypedefs()) {
            newGroup.addEnumTypedef(td);
            if (!debug) continue;
            System.out.println("add typedef= " + td);
        }
        for (Dimension oldD : oldGroup.getDimensions()) {
            Dimension newD = Dimension.builder().setName(oldD.getShortName()).setIsShared(oldD.isShared()).setIsUnlimited(oldD.isUnlimited()).setIsVariableLength(oldD.isVariableLength()).setLength(oldD.isUnlimited() ? 0 : oldD.getLength()).build();
            newGroup.addDimension(newD);
            if (!debug) continue;
            System.out.println("add dim= " + newD);
        }
        for (Variable oldVar : oldGroup.getVariables()) {
            Variable.Builder newVar = this.copyVariable(newGroup, oldVar);
            if (debug) {
                System.out.println("add var= " + oldVar.getShortName());
            }
            newGroup.addVariable(newVar);
        }
        for (Group nested : oldGroup.getGroups()) {
            newGroup.addGroup(this.copyGroup(nested, newGroup));
        }
        return newGroup;
    }

    private Variable.Builder copyVariable(Group.Builder parent, Variable oldVar) throws IOException {
        Object vb;
        DataType newType = oldVar.getDataType();
        String dimNames = Dimensions.makeDimensionsString(oldVar.getDimensions());
        if (newType == DataType.STRUCTURE) {
            Structure oldStruct = (Structure)oldVar;
            Structure.Builder sb = (Structure.Builder)Structure.builder().setName(oldVar.getShortName());
            for (Variable nested : oldStruct.getVariables()) {
                sb.addMemberVariable(this.copyVariable(parent, nested));
            }
            vb = sb;
        } else {
            vb = ((Variable.Builder)Variable.builder().setName(oldVar.getShortName())).setDataType(newType);
            if (!this.extended && newType == DataType.STRING) {
                Array data = oldVar.read();
                IndexIterator ii = data.getIndexIterator();
                int max_len = 0;
                while (ii.hasNext()) {
                    String s2 = (String)ii.getObjectNext();
                    max_len = Math.max(max_len, s2.length());
                }
                String strlenDimName = oldVar.getShortName() + "_strlen";
                parent.addDimension(Dimension.builder(strlenDimName, max_len).setIsShared(false).build());
                newType = DataType.CHAR;
                ((Variable.Builder)vb).setDataType(DataType.CHAR);
                dimNames = dimNames + " " + strlenDimName;
            }
        }
        ((Variable.Builder)((Variable.Builder)vb).setParentGroupBuilder(parent)).setDimensionsByName(dimNames);
        if (newType.isEnum()) {
            EnumTypedef en = oldVar.getEnumTypedef();
            ((Variable.Builder)vb).setEnumTypeName(en.getShortName());
        }
        for (Attribute att : oldVar.attributes()) {
            ((Variable.Builder)vb).addAttribute(this.convertAttribute(att));
            if (!debug) continue;
            System.out.println("add varAtt= " + att);
        }
        return vb;
    }

    private Attribute convertAttribute(Attribute org) {
        if (this.extended || !org.getDataType().isUnsigned()) {
            return org;
        }
        Array orgValues = org.getValues();
        Array nc3Values = Array.makeFromJavaArray(orgValues.getStorage(), false);
        return new Attribute(org.getShortName(), nc3Values);
    }

    private void copyVariableData(NetcdfFormatWriter ncwriter, Group groupIn, Group groupOut, Count counter, CancelTask cancel) throws IOException {
        for (Variable oldVar : groupIn.getVariables()) {
            if (cancel.isCancel()) break;
            Variable newVar = groupOut.findVariableLocal(oldVar.getShortName());
            if (debug) {
                System.out.format("write var= %s size = %d type = %s%n", new Object[]{oldVar.getFullName(), oldVar.getSize(), oldVar.getDataType()});
            }
            cancel.setProgress("writing " + oldVar.getFullName(), counter.countVars++);
            long size = oldVar.getSize() * (long)oldVar.getElementSize();
            counter.bytes += size;
            if (size <= 50000000L) {
                this.copyAll(ncwriter, oldVar, newVar);
                continue;
            }
            this.copySome(ncwriter, oldVar, newVar, 50000000L, cancel);
        }
        for (Group nestedIn : groupIn.getGroups()) {
            if (cancel.isCancel()) break;
            Group nestedOut = groupOut.findGroupLocal(nestedIn.getShortName());
            this.copyVariableData(ncwriter, nestedIn, nestedOut, counter, cancel);
        }
    }

    private void copyAll(NetcdfFormatWriter ncwriter, Variable oldVar, Variable newVar) throws IOException {
        Array data = oldVar.read();
        try {
            if (!this.extended && oldVar.getDataType() == DataType.STRING) {
                data = this.convertDataToChar(newVar, data);
            }
            if (data.getSize() > 0L) {
                ncwriter.write(newVar, data);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage() + " for Variable " + oldVar.getFullName());
        }
    }

    private void copySome(NetcdfFormatWriter ncwriter, Variable oldVar, Variable newVar, long maxChunkSize, CancelTask cancel) throws IOException {
        long maxChunkElems = maxChunkSize / (long)oldVar.getElementSize();
        long byteWriteTotal = 0L;
        ChunkingIndex index = new ChunkingIndex(oldVar.getShape());
        while ((long)index.currentElement() < index.getSize()) {
            try {
                int[] chunkOrigin = index.getCurrentCounter();
                int[] chunkShape = index.computeChunkShape(maxChunkElems);
                cancel.setProgress("Reading chunk " + new Section(chunkOrigin, chunkShape) + " from variable: " + oldVar.getShortName(), -1);
                Array data = oldVar.read(chunkOrigin, chunkShape);
                if (!this.getOutputFormat().isNetdf4format() && oldVar.getDataType() == DataType.STRING) {
                    data = this.convertDataToChar(newVar, data);
                }
                if (data.getSize() > 0L) {
                    cancel.setProgress("Writing chunk " + new Section(chunkOrigin, chunkShape) + " from variable: " + oldVar.getShortName(), -1);
                    ncwriter.write(newVar, chunkOrigin, data);
                    if (debugWrite) {
                        System.out.println(" write " + data.getSize() + " bytes at " + new Section(chunkOrigin, chunkShape));
                    }
                    byteWriteTotal += data.getSize();
                }
                index.setCurrentCounter(index.currentElement() + (int)Index.computeSize(chunkShape));
                if (!cancel.isCancel()) continue;
                return;
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
    }

    private Array convertDataToChar(Variable newVar, Array oldData) {
        ArrayChar newData = (ArrayChar)Array.factory(DataType.CHAR, newVar.getShape());
        Index ima = newData.getIndex();
        IndexIterator ii = oldData.getIndexIterator();
        while (ii.hasNext()) {
            String s2 = (String)ii.getObjectNext();
            int[] c = ii.getCurrentCounter();
            for (int i = 0; i < c.length; ++i) {
                ima.setDim(i, c[i]);
            }
            newData.setString(ima, s2);
        }
        return newData;
    }

    private static class Count {
        long bytes;
        int countVars;

        private Count() {
        }
    }
}

