/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebUtils {
    private static final SimpleDateFormat subtitleFormat = new SimpleDateFormat("HH:mm:ss.00");
    private static HashMap<String, String> htmlEntities = new HashMap();

    public static boolean fileContains(File file, String string) {
        try {
            String s2;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((s2 = br.readLine()) != null) {
                if (!s2.contains(string)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void showBrowser(String url) {
        try {
            Class<?> c = Class.forName("java.awt.Desktop");
            Object o = c.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            o.getClass().getMethod("browse", URI.class).invoke(o, new URI(url));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void copy(InputStream in, File dst) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void importResource(File destDir, String ... names) {
        for (String resourceName : names) {
            try {
                InputStream is = WebUtils.class.getResourceAsStream("/resources/" + resourceName);
                WebUtils.copy(is, new File(destDir, resourceName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void getImageFromUrl(String location, File dest) {
        try {
            for (int i = 1; i < 31; ++i) {
                int b;
                URL url = new URL(location);
                InputStream in = url.openStream();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
                while ((b = in.read()) != -1) {
                    ((OutputStream)out).write(b);
                }
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String stripXML(String in) {
        return WebUtils.unescapeHTML(in.replaceAll("\\<.*?\\>", ""), 0);
    }

    public static StringBuilder toString(StringBuilder sb, Node node) {
        String t = node.getTextContent();
        if (t != null) {
            sb.append(t);
        }
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node2 = nl.item(i);
        }
        return sb;
    }

    public static String subtitleFormat(double seconds) {
        return subtitleFormat.format(new Date((int)(seconds * 1000.0)));
    }

    public static final String unescapeHTML(String source, int start) {
        String entityToLookFor;
        String value;
        int j;
        int i = source.indexOf("&", start);
        if (i > -1 && (j = source.indexOf(";", i)) > i && (value = htmlEntities.get(entityToLookFor = source.substring(i, j + 1))) != null) {
            source = new StringBuffer().append(source.substring(0, i)).append(value).append(source.substring(j + 1)).toString();
            return WebUtils.unescapeHTML(source, i + 1);
        }
        return source;
    }

    static {
        htmlEntities.put("&lt;", "<");
        htmlEntities.put("&gt;", ">");
        htmlEntities.put("&amp;", "&");
        htmlEntities.put("&quot;", "\"");
        htmlEntities.put("&agrave;", "\u00e0");
        htmlEntities.put("&Agrave;", "\u00c0");
        htmlEntities.put("&acirc;", "\u00e2");
        htmlEntities.put("&auml;", "\u00e4");
        htmlEntities.put("&Auml;", "\u00c4");
        htmlEntities.put("&Acirc;", "\u00c2");
        htmlEntities.put("&aring;", "\u00e5");
        htmlEntities.put("&Aring;", "\u00c5");
        htmlEntities.put("&aelig;", "\u00e6");
        htmlEntities.put("&AElig;", "\u00c6");
        htmlEntities.put("&ccedil;", "\u00e7");
        htmlEntities.put("&Ccedil;", "\u00c7");
        htmlEntities.put("&eacute;", "\u00e9");
        htmlEntities.put("&Eacute;", "\u00c9");
        htmlEntities.put("&egrave;", "\u00e8");
        htmlEntities.put("&Egrave;", "\u00c8");
        htmlEntities.put("&ecirc;", "\u00ea");
        htmlEntities.put("&Ecirc;", "\u00ca");
        htmlEntities.put("&euml;", "\u00eb");
        htmlEntities.put("&Euml;", "\u00cb");
        htmlEntities.put("&iuml;", "\u00ef");
        htmlEntities.put("&Iuml;", "\u00cf");
        htmlEntities.put("&ocirc;", "\u00f4");
        htmlEntities.put("&Ocirc;", "\u00d4");
        htmlEntities.put("&ouml;", "\u00f6");
        htmlEntities.put("&Ouml;", "\u00d6");
        htmlEntities.put("&oslash;", "\u00f8");
        htmlEntities.put("&Oslash;", "\u00d8");
        htmlEntities.put("&szlig;", "\u00df");
        htmlEntities.put("&ugrave;", "\u00f9");
        htmlEntities.put("&Ugrave;", "\u00d9");
        htmlEntities.put("&ucirc;", "\u00fb");
        htmlEntities.put("&Ucirc;", "\u00db");
        htmlEntities.put("&uuml;", "\u00fc");
        htmlEntities.put("&Uuml;", "\u00dc");
        htmlEntities.put("&nbsp;", " ");
        htmlEntities.put("&copy;", "\u00a9");
        htmlEntities.put("&reg;", "\u00ae");
        htmlEntities.put("&euro;", "\u20a0");
    }
}

