/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WeakListener {
    List<WeakReference<Changed>> dispatchees = new ArrayList<WeakReference<Changed>>();

    public void fire() {
        this.dumpVoids();
        for (WeakReference<Changed> d : this.dispatchees) {
            Changed c = (Changed)d.get();
            if (c == null) continue;
            c.changed();
        }
    }

    public void add(Changed target) {
        this.dumpVoids();
        this.dispatchees.add(new WeakReference<Changed>(target));
    }

    private void dumpVoids() {
        Iterator<WeakReference<Changed>> it = this.dispatchees.iterator();
        while (it.hasNext()) {
            if (it.next().get() != null) continue;
            it.remove();
        }
    }

    public void addIfNew(Changed target) {
        this.dumpVoids();
        Iterator<WeakReference<Changed>> it = this.dispatchees.iterator();
        while (it.hasNext()) {
            if (it.next().get() != target) continue;
            return;
        }
        this.add(target);
    }

    public static interface Changed {
        public void changed();
    }
}

