/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.ui;

import java.util.HashSet;
import java.util.Set;
import org.twak.camp.Corner;
import org.twak.camp.CornerClone;
import org.twak.camp.HeightEvent;
import org.twak.camp.Machine;
import org.twak.camp.Skeleton;
import org.twak.camp.SkeletonCapUpdate;
import org.twak.camp.Tag;
import org.twak.camp.debug.DebugDevice;
import org.twak.utils.collections.DHash;
import org.twak.utils.collections.LoopL;

public class DirectionHeightEvent
implements HeightEvent {
    protected double height;
    public double newAngle;
    Machine machine;
    public Set<Tag> profileFeatures = new HashSet<Tag>();

    public DirectionHeightEvent(Machine machine, double angle) {
        this(machine, 0.0, angle);
    }

    public double getAngle() {
        return this.newAngle;
    }

    public DirectionHeightEvent(Machine machine, double height, double angle) {
        this.machine = machine;
        this.height = height;
        this.newAngle = angle;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public boolean process(Skeleton skel) {
        this.machine.currentAngle = this.newAngle;
        SkeletonCapUpdate update = new SkeletonCapUpdate(skel);
        LoopL<Corner> cap = update.getCap(this.height);
        DebugDevice.dump("cap", cap);
        CornerClone cc = new CornerClone(cap);
        DHash<Corner, Corner> nOCorner = cc.nOCorner.shallowDupe();
        for (Corner c : cc.output.eIterator()) {
            if (c.nextL.machine == this.machine || c.prevL.machine == this.machine) {
                nOCorner.removeA(c);
            }
            if (c.nextL.machine != this.machine) continue;
            c.nextL.profileFeatures = this.profileFeatures;
            cc.nOSegments.removeA(c);
        }
        update.update(cc.output, cc.nOSegments, nOCorner);
        for (Corner c : skel.liveCorners) {
            if (c.nextL.machine != this.machine) continue;
            Corner old = update.getOldBaseLookup().get(cc.nOCorner.get(c));
            skel.output.setParent(c.nextL.start, old.nextL.start);
        }
        DebugDevice.dump("post height " + this.height, skel);
        this.machine.findNextHeight(skel);
        return true;
    }
}

