/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.phtree;

import ch.ethz.globis.phtree.PhTreeF;
import org.tinspin.index.Index;
import org.tinspin.index.PointMap;
import org.tinspin.index.Stats;
import org.tinspin.index.phtree.PHStats;

public class PHTreeP<T>
implements PointMap<T> {
    private final PhTreeF<T> tree;

    private PHTreeP(int dims) {
        this.tree = PhTreeF.create(dims);
    }

    public static <T> PHTreeP<T> create(int dims) {
        return new PHTreeP<T>(dims);
    }

    @Override
    public int getDims() {
        return this.tree.getDim();
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public void clear() {
        this.tree.clear();
    }

    @Override
    public Stats getStats() {
        return new PHStats(this.tree.getInternalTree().getStats(), this.tree.getDim());
    }

    @Override
    public int getNodeCount() {
        return this.tree.getInternalTree().getStats().getNodeCount();
    }

    @Override
    public int getDepth() {
        return this.tree.getInternalTree().getStats().getBitDepth();
    }

    @Override
    public String toStringTree() {
        return this.tree.getInternalTree().toStringTree();
    }

    @Override
    public void insert(double[] key, T value) {
        this.tree.put(key, value);
    }

    @Override
    public T remove(double[] point) {
        return this.tree.remove(point);
    }

    @Override
    public T update(double[] oldPoint, double[] newPoint) {
        return this.tree.update(oldPoint, newPoint);
    }

    @Override
    public boolean contains(double[] key) {
        return this.tree.contains(key);
    }

    @Override
    public T queryExact(double[] point) {
        return this.tree.get(point);
    }

    @Override
    public Index.PointIterator<T> query(double[] min2, double[] max) {
        return new QueryIteratorPH<T>(this.tree.query(min2, max));
    }

    @Override
    public Index.PointIterator<T> iterator() {
        return new ExtentWrapper();
    }

    @Override
    public Index.PointIteratorKnn<T> queryKnn(double[] center, int k) {
        return new QueryIteratorKnnPH<T>(this.tree.nearestNeighbour(k, center));
    }

    private static class QueryIteratorKnnPH<T>
    implements Index.PointIteratorKnn<T> {
        private final PhTreeF.PhKnnQueryF<T> iter;

        private QueryIteratorKnnPH(PhTreeF.PhKnnQueryF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Index.PointEntryKnn<T> next() {
            PhTreeF.PhEntryF e = this.iter.nextEntryReuse();
            return new Index.PointEntryKnn((double[])e.getKey().clone(), e.getValue(), ((PhTreeF.PhEntryDistF)e).dist());
        }

        @Override
        public QueryIteratorKnnPH<T> reset(double[] center, int k) {
            this.iter.reset(k, null, center);
            return this;
        }
    }

    private static class QueryIteratorPH<T>
    implements Index.PointIterator<T> {
        private final PhTreeF.PhQueryF<T> iter;

        private QueryIteratorPH(PhTreeF.PhQueryF<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Index.PointEntry<T> next() {
            Object e = this.iter.nextEntryReuse();
            return new Index.PointEntry((double[])((PhTreeF.PhEntryF)e).getKey().clone(), ((PhTreeF.PhEntryF)e).getValue());
        }

        @Override
        public Index.PointIterator<T> reset(double[] min2, double[] max) {
            this.iter.reset(min2, max);
            return this;
        }
    }

    private class ExtentWrapper
    implements Index.PointIterator<T> {
        private PhTreeF.PhIteratorF<T> iter;

        private ExtentWrapper() {
            this.reset(null, null);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Index.PointEntry<T> next() {
            Object e = this.iter.nextEntryReuse();
            return new Index.PointEntry((double[])((PhTreeF.PhEntryF)e).getKey().clone(), ((PhTreeF.PhEntryF)e).getValue());
        }

        @Override
        public Index.PointIterator<T> reset(double[] min2, double[] max) {
            if (min2 != null || max != null) {
                throw new UnsupportedOperationException("min/max must be `null`");
            }
            this.iter = PHTreeP.this.tree.queryExtent();
            return this;
        }
    }
}

