/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index;

import org.tinspin.index.Index;
import org.tinspin.index.PointDistance;

@FunctionalInterface
public interface BoxDistance {
    public static final BoxDistance CENTER = BoxDistance::centerDistance;
    public static final BoxDistance EDGE = BoxDistance::edgeDistance;

    public double dist(double[] var1, double[] var2, double[] var3);

    default public double dist(double[] center, Index.BoxEntry<?> entry) {
        return this.dist(center, entry.min(), entry.max());
    }

    public static double centerDistance(double[] center, double[] min2, double[] max) {
        double dist = 0.0;
        for (int i = 0; i < center.length; ++i) {
            double d = (min2[i] + max[i]) * 0.5 - center[i];
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    public static double edgeDistance(double[] center, double[] min2, double[] max) {
        double dist = 0.0;
        for (int i = 0; i < center.length; ++i) {
            double d = 0.0;
            if (min2[i] > center[i]) {
                d = min2[i] - center[i];
            } else if (max[i] < center[i]) {
                d = center[i] - max[i];
            }
            dist += d * d;
        }
        return Math.sqrt(dist);
    }

    public static class EdgeDistance {
        final PointDistance distFn;

        public EdgeDistance(PointDistance distFn) {
            this.distFn = distFn;
        }

        public double edgeDistance(double[] center, double[] min2, double[] max) {
            double[] dist = new double[center.length];
            for (int i = 0; i < center.length; ++i) {
                double d = 0.0;
                if (min2[i] > center[i]) {
                    d = min2[i] - center[i];
                } else if (max[i] < center[i]) {
                    d = center[i] - max[i];
                }
                dist[i] = d;
            }
            return this.distFn.dist(dist, center);
        }
    }

    public static class FarthestNeighbor
    implements BoxDistance {
        private static final double EPSILON = 9.9E-324;
        private final BoxDistance dist;

        public FarthestNeighbor(BoxDistance dist) {
            this.dist = dist;
        }

        @Override
        public double dist(double[] center, double[] min2, double[] max) {
            double d = this.dist.dist(center, min2, max);
            if (d < 9.9E-324) {
                return Double.POSITIVE_INFINITY;
            }
            return 1.0 / d;
        }

        @Override
        public double dist(double[] center, Index.BoxEntry<?> entry) {
            double d = this.dist.dist(center, entry);
            if (d < 9.9E-324) {
                return Double.POSITIVE_INFINITY;
            }
            return 1.0 / d;
        }
    }

    public static class RectangleDist
    implements BoxDistance {
        private final double[] lower;
        private final double[] upper;

        public RectangleDist(double[] lower, double[] upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public double dist(double[] ignored, double[] min2, double[] max) {
            double dist = 0.0;
            for (int i = 0; i < this.lower.length; ++i) {
                double d = 0.0;
                if (min2[i] > this.upper[i]) {
                    d = min2[i] - this.upper[i];
                } else if (max[i] < this.lower[i]) {
                    d = this.lower[i] - max[i];
                }
                dist += d * d;
            }
            return dist;
        }
    }
}

