/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.twak.utils.StartStop;

public class SimplePopup2 {
    JPopupMenu menu = new JPopupMenu();
    MouseEvent evt;
    ActionEvent runClick;

    public SimplePopup2(MouseEvent evt) {
        this.evt = evt;
        this.menu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                SimplePopup2.this.menu.setVisible(false);
            }
        });
    }

    public void add(String simpleName, Runnable runnable) {
        this.add(simpleName, runnable, null);
    }

    public void add(String simpleName, final Runnable runnable, final StartStop hover) {
        JMenuItem item = new JMenuItem(simpleName);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(final ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (hover != null) {
                            hover.stop();
                        }
                        SimplePopup2.this.runClick = e;
                        runnable.run();
                    }
                });
            }
        });
        if (hover != null) {
            item.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    SwingUtilities.invokeLater(() -> hover.start());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SwingUtilities.invokeLater(() -> hover.stop());
                }
            });
        }
        this.menu.add(item);
    }

    public void addSubMenu(String name, Iterable<Runnable> options) {
        JMenu sub = new JMenu(name);
        for (final Runnable r : options) {
            JMenuItem item = new JMenuItem(r.toString());
            sub.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(final ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SimplePopup2.this.runClick = e;
                            r.run();
                        }
                    });
                }
            });
        }
        this.menu.add(sub);
    }

    public void add(Runnable runnable) {
        if (runnable != null) {
            this.add(runnable.toString(), runnable);
        }
    }

    public void addAll(List<Runnable> howCanWeStartFrom) {
        if (howCanWeStartFrom == null) {
            return;
        }
        for (Runnable r : howCanWeStartFrom) {
            this.add(r);
        }
    }

    public void show() {
        if (this.menu.getComponents().length == 0) {
            return;
        }
        this.menu.show(this.evt.getComponent(), this.evt.getX() - 10, this.evt.getY() - 10);
        this.menu.getComponent(0).requestFocusInWindow();
    }

    public ActionEvent clickEvent() {
        return this.runClick;
    }
}

