/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MultiMapSet<A, B> {
    public Map<A, Set<B>> map = new LinkedHashMap<A, Set<B>>();

    public void addEmpty(A a) {
        if (!this.map.containsKey(a)) {
            this.map.put(a, new LinkedHashSet());
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<B> get(A key) {
        Set<B> out = this.map.get(key);
        if (out == null) {
            return new LinkedHashSet();
        }
        return out;
    }

    public Set<B> getOrAdd(A key) {
        Set<B> out = this.map.get(key);
        if (out == null) {
            LinkedHashSet b = new LinkedHashSet();
            this.map.put(key, b);
            return b;
        }
        return out;
    }

    public boolean remove(A key, B value) {
        Set<B> out = this.map.get(key);
        if (out == null) {
            return false;
        }
        return out.remove(value);
    }

    public void put(A key, B value) {
        Set<B> out = this.map.get(key);
        if (out == null) {
            out = new LinkedHashSet<B>();
            this.map.put(key, out);
        }
        out.add(value);
    }

    public Set<B> remove(A key) {
        return this.map.remove(key);
    }

    public void removeClean(A a, B b) {
        Set<B> out = this.map.get(a);
        if (out == null) {
            return;
        }
        out.remove(b);
        if (out.isEmpty()) {
            this.map.remove(a);
        }
    }

    public void putAll(Map<? extends A, ? extends B> m3) {
        for (Map.Entry<A, B> entry : m3.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<A> keySet() {
        return this.map.keySet();
    }

    public Collection<Set<B>> values() {
        return this.map.values();
    }

    public Set<Map.Entry<A, Set<B>>> entrySet() {
        return this.map.entrySet();
    }

    public void putAll(A a, Iterable<B> bs) {
        for (B b : bs) {
            this.put(a, b);
        }
    }

    public void removeAll(A a, Iterable<B> bs) {
        for (B b : bs) {
            this.remove(a, b);
        }
    }
}

