/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class CloneConfirmIterator<E>
implements Iterator<E>,
Iterable<E> {
    Set original;
    Iterator<E> it;
    E next;

    public CloneConfirmIterator(Set<E> in) {
        this.original = in;
        this.it = new LinkedHashSet<E>(in).iterator();
        this.findNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public E next() {
        E out = this.next;
        this.findNext();
        return out;
    }

    private void findNext() {
        do {
            if (!this.it.hasNext()) {
                this.next = null;
                return;
            }
            this.next = this.it.next();
        } while (!this.original.contains(this.next));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }
}

