/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.twak.camp.Chain;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.EdgeCollision;
import org.twak.camp.HeightCollision;
import org.twak.camp.Skeleton;
import org.twak.utils.Pair;
import org.twak.utils.Triple;
import org.twak.utils.collections.ConsecutivePairs;
import org.twak.utils.collections.ConsecutiveTriples;
import org.twak.utils.geom.LinearForm3D;
import org.twak.utils.geom.Ray3d;

public class CoSitedCollision {
    public Collection<EdgeCollision> edges = new ArrayList<EdgeCollision>(10);
    public Point3d loc;
    public boolean debugHoriz = false;
    public List<Chain> chains = new ArrayList<Chain>();
    private HeightCollision parent;
    static Vector3d Y_UP = new Vector3d(0.0, 1.0, 0.0);

    public CoSitedCollision(Point3d loc, EdgeCollision ec, HeightCollision parent) {
        this.loc = loc;
        this.parent = parent;
        this.add(ec);
    }

    public void add(EdgeCollision ec) {
        this.edges.add(ec);
    }

    public boolean findChains(Skeleton skel) {
        Chain chain;
        this.chains = new ArrayList<Chain>();
        HashSet<Edge> allEdges = new HashSet<Edge>();
        for (EdgeCollision ec : this.edges) {
            allEdges.add(ec.a);
            allEdges.add(ec.b);
            allEdges.add(ec.c);
        }
        Iterator eit = allEdges.iterator();
        while (eit.hasNext()) {
            if (skel.liveEdges.contains(eit.next())) continue;
            eit.remove();
        }
        if (allEdges.size() < 3) {
            return false;
        }
        LinkedHashSet<Corner> edgeStarts = new LinkedHashSet<Corner>();
        for (Edge e : allEdges) {
            for (Corner c : e.currentCorners) {
                if (c.nextL != e || skel.preserveParallel && !EdgeCollision.bisectorsBound(c, this.loc, skel)) continue;
                edgeStarts.add(c);
            }
        }
        while (!edgeStarts.isEmpty()) {
            Corner start = (Corner)edgeStarts.iterator().next();
            chain = CoSitedCollision.buildChain2(start, edgeStarts);
            if (chain == null) continue;
            this.chains.add(chain);
        }
        edgeStarts.clear();
        for (Chain c : this.chains) {
            if (c.chain.size() <= 1) continue;
            edgeStarts.addAll(c.chain);
        }
        Iterator<Chain> chit = this.chains.iterator();
        while (chit.hasNext()) {
            chain = chit.next();
            if (chain.chain.size() != 1) continue;
            Corner s2 = chain.chain.get(0);
            Corner found = EdgeCollision.findCorner(s2.nextL, this.loc, skel);
            if (found == s2 && !edgeStarts.contains(found)) continue;
            chit.remove();
        }
        if (this.chains.size() > 1) {
            Collections.sort(this.chains, new ChainComparator(this.loc.z));
        }
        return true;
    }

    public void validateChains(Skeleton skel) {
        for (Chain chain : this.chains) {
            if (chain.loop) continue;
            if (chain.chain.size() > 1) {
                chain.chain.remove(0);
                chain.chain.add(0, chain.chain.get((int)0).prevC);
                continue;
            }
            Corner corner = chain.chain.get(0);
            Edge edge = corner.nextL;
            Ray3d projectionLine = new Ray3d(this.loc, edge.direction());
            LinearForm3D ceiling = new LinearForm3D(0.0, 0.0, 1.0, -this.loc.z);
            try {
                Tuple3d start = edge.uphill.equals(corner.prevL.uphill) ? ceiling.collide(edge.start, edge.uphill) : edge.linearForm.collide(corner.prevL.linearForm, ceiling);
                double targetParam = 0.0;
                Corner bestPrev = corner;
                double bestParam = projectionLine.projectParam(start) - 0.001;
                for (Corner r : edge.currentCorners) {
                    if (r.nextL != edge) continue;
                    Tuple3d tuple3d = Math.abs(r.z - this.loc.z) < 0.001 ? r : ceiling.collide(r.prevL.linearForm, r.nextL.linearForm);
                    Corner rOnHigh = tuple3d;
                    double param = projectionLine.projectParam(rOnHigh);
                    if (!(param > bestParam) || !(param <= targetParam)) continue;
                    bestPrev = r;
                    bestParam = param;
                }
                chain.chain.remove(0);
                chain.chain.add(0, bestPrev);
                chain.loop = chain.chain.get((int)(chain.chain.size() - 1)).nextC == chain.chain.get(0);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        LinkedHashMap<Edge, Corner> edgeToCorner = new LinkedHashMap<Edge, Corner>();
        for (Chain chain : this.chains) {
            for (Corner c : chain.chain) {
                edgeToCorner.put(c.nextL, c);
            }
        }
        LinkedHashSet<Edge> linkedHashSet = new LinkedHashSet<Edge>();
        for (EdgeCollision edgeCollision : this.edges) {
            if (!this.hasAdjacent((Corner)edgeToCorner.get(edgeCollision.a), (Corner)edgeToCorner.get(edgeCollision.b), (Corner)edgeToCorner.get(edgeCollision.c)) || !skel.liveEdges.contains(edgeCollision.a) || !skel.liveEdges.contains(edgeCollision.b) || !skel.liveEdges.contains(edgeCollision.c)) continue;
            linkedHashSet.add(edgeCollision.a);
            linkedHashSet.add(edgeCollision.b);
            linkedHashSet.add(edgeCollision.c);
        }
        ArrayList<Chain> arrayList = new ArrayList<Chain>(this.chains);
        for (Chain cc : arrayList) {
            this.chains.addAll(this.chains.indexOf(cc), cc.removeCornersWithoutEdges(linkedHashSet));
        }
        Iterator<Chain> iterator = this.chains.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().chain.size() != 0) continue;
            iterator.remove();
        }
    }

    private boolean hasAdjacent(Corner a, Corner b, Corner c) {
        if (a == null || b == null || c == null) {
            return false;
        }
        if (a.nextC == b || a.nextC == c) {
            return true;
        }
        if (b.nextC == c || b.nextC == a) {
            return true;
        }
        return c.nextC == a || c.nextC == b;
    }

    public boolean processChains(Skeleton skel) {
        if (this.moreOneSmashEdge()) {
            return false;
        }
        LinkedHashSet<Corner> allCorners = new LinkedHashSet<Corner>();
        for (Chain cc : this.chains) {
            allCorners.addAll(cc.chain);
        }
        if (allCorners.size() < 3) {
            return false;
        }
        skel.debugCollisionOrder.add(this);
        Iterator<Chain> cit = this.chains.iterator();
        while (cit.hasNext()) {
            Chain chain = cit.next();
            for (Pair pair : new ConsecutivePairs<Corner>(chain.chain, chain.loop)) {
                EdgeCollision.processConsecutive(this.loc, (Corner)pair.first(), (Corner)pair.second(), skel);
            }
            if (chain.chain.size() >= 3) {
                ConsecutiveTriples<Corner> tit = new ConsecutiveTriples<Corner>(chain.chain, chain.loop);
                while (tit.hasNext()) {
                    Edge edge = ((Corner)((Triple)tit.next()).second()).nextL;
                    if (!edge.currentCorners.isEmpty()) continue;
                    skel.liveEdges.remove(edge);
                }
            }
            if (!chain.loop) continue;
            cit.remove();
        }
        if (this.chains.isEmpty()) {
            return true;
        }
        LinkedHashMap<Corner, Corner> aNext = new LinkedHashMap<Corner, Corner>();
        for (Chain chain : this.chains) {
            Corner c = chain.chain.get(chain.chain.size() - 1);
            aNext.put(c, c.nextC);
        }
        for (Pair pair : new ConsecutivePairs<Chain>(this.chains, true)) {
            List<Corner> first = ((Chain)pair.first()).chain;
            Corner a = first.get(first.size() - 1);
            Corner b = ((Chain)pair.second()).chain.get(0);
            EdgeCollision.processJump(this.loc, a, (Corner)aNext.get(a), b, skel, this.parent);
        }
        return true;
    }

    private boolean moreOneSmashEdge() {
        int oneCount = 0;
        for (Chain ch : this.chains) {
            if (ch.chain.size() != 1) continue;
            ++oneCount;
        }
        if (oneCount > 1) {
            return false;
        }
        return oneCount > 1;
    }

    public static Chain buildChain2(Corner start, Set<Corner> input) {
        ArrayList<Corner> chain = new ArrayList<Corner>();
        Corner a = start;
        while (input.contains(a)) {
            chain.add(0, a);
            input.remove(a);
            a = a.prevC;
        }
        a = start.nextC;
        while (input.contains(a)) {
            chain.add(a);
            input.remove(a);
            a = a.nextC;
        }
        return new Chain(chain);
    }

    public double getHeight() {
        return this.loc.z;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (EdgeCollision e : this.edges) {
            sb.append(String.valueOf(e) + ",");
        }
        sb.append("}");
        return sb.toString();
    }

    public class ChainComparator
    implements Comparator<Chain> {
        double height;

        public ChainComparator(double height) {
            this.height = height;
        }

        @Override
        public int compare(Chain o1, Chain o2) {
            Corner c1 = o1.chain.get(0);
            Corner c2 = o2.chain.get(0);
            Tuple3d p1 = Edge.collide(c1, this.height);
            Tuple3d p2 = Edge.collide(c2, this.height);
            p1.sub(CoSitedCollision.this.loc);
            p2.sub(CoSitedCollision.this.loc);
            return Double.compare(Math.atan2(p1.y, p1.x), Math.atan2(p2.y, p2.x));
        }
    }
}

