/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.optimization;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.sedona.common.sphere.Haversine;
import org.apache.sedona.core.spatialOperator.SpatialPredicate;
import org.apache.sedona.sql.utils.GeometrySerializer$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.PushableColumn$;
import org.apache.spark.sql.execution.datasources.PushableColumnBase;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetFileFormatBase;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetSpatialFilter$AndFilter$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.sedona_sql.expressions.ST_Buffer;
import org.apache.spark.sql.sedona_sql.expressions.ST_Contains;
import org.apache.spark.sql.sedona_sql.expressions.ST_CoveredBy;
import org.apache.spark.sql.sedona_sql.expressions.ST_Covers;
import org.apache.spark.sql.sedona_sql.expressions.ST_Crosses;
import org.apache.spark.sql.sedona_sql.expressions.ST_DWithin;
import org.apache.spark.sql.sedona_sql.expressions.ST_Distance;
import org.apache.spark.sql.sedona_sql.expressions.ST_DistanceSphere;
import org.apache.spark.sql.sedona_sql.expressions.ST_DistanceSpheroid;
import org.apache.spark.sql.sedona_sql.expressions.ST_Equals;
import org.apache.spark.sql.sedona_sql.expressions.ST_Intersects;
import org.apache.spark.sql.sedona_sql.expressions.ST_OrderingEquals;
import org.apache.spark.sql.sedona_sql.expressions.ST_Overlaps;
import org.apache.spark.sql.sedona_sql.expressions.ST_Touches;
import org.apache.spark.sql.sedona_sql.expressions.ST_Within;
import org.apache.spark.sql.sedona_sql.optimization.ExpressionUtils$;
import org.apache.spark.sql.sedona_sql.optimization.SpatialFilterPushDownForGeoParquet$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001\u0002\u0007\u000e\u0001iA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006a\u0001!\t!\r\u0005\u0006k\u0001!\tE\u000e\u0005\u0006s\u0001!IA\u000f\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\u0006Q\u0002!I!\u001b\u0005\u0006i\u0002!I!\u001e\u0005\n\u0003W\u0001\u0011\u0013!C\u0005\u0003[A\u0011\"a\u0011\u0001#\u0003%I!!\u0012\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L!9\u0011q\n\u0001\u0005\n\u0005E#AI*qCRL\u0017\r\u001c$jYR,'\u000fU;tQ\u0012{wO\u001c$pe\u001e+w\u000eU1scV,GO\u0003\u0002\u000f\u001f\u0005aq\u000e\u001d;j[&T\u0018\r^5p]*\u0011\u0001#E\u0001\u000bg\u0016$wN\\1`gFd'B\u0001\n\u0014\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003)U\tQa\u001d9be.T!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sO\u000e\u00011C\u0001\u0001\u001c!\ra\u0012eI\u0007\u0002;)\u0011adH\u0001\u0006eVdWm\u001d\u0006\u0003AE\t\u0001bY1uC2L8\u000f^\u0005\u0003Eu\u0011AAU;mKB\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\bY><\u0017nY1m\u0015\tAs$A\u0003qY\u0006t7/\u0003\u0002+K\tYAj\\4jG\u0006d\u0007\u000b\\1o\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tic&D\u0001\u0012\u0013\ty\u0013C\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003eQ\u0002\"a\r\u0001\u000e\u00035AQa\u000b\u0002A\u00021\nQ!\u00199qYf$\"aI\u001c\t\u000ba\u001a\u0001\u0019A\u0012\u0002\tAd\u0017M\\\u0001\u0015SN<Um\u001c)beF,X\r\u001e*fY\u0006$\u0018n\u001c8\u0015\u0005m\n\u0005C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0005\u0012\u0001\raQ\u0001\u0003YJ\u0004\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u0011F\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005)+%a\u0004'pO&\u001c\u0017\r\u001c*fY\u0006$\u0018n\u001c8\u0002GQ\u0014\u0018M\\:mCR,Gk\\$f_B\u000b'/];fiN\u0003\u0018\r^5bY\u001aKG\u000e^3sgR\u0011Qj\u0018\t\u0004\u001dZKfBA(U\u001d\t\u00016+D\u0001R\u0015\t\u0011\u0016$\u0001\u0004=e>|GOP\u0005\u0002}%\u0011Q+P\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0006LA\u0002TKFT!!V\u001f\u0011\u0005ikV\"A.\u000b\u0005q+\u0015AC4f_B\f'/];fi&\u0011al\u0017\u0002\u0018\u000f\u0016|\u0007+\u0019:rk\u0016$8\u000b]1uS\u0006dg)\u001b7uKJDQ\u0001Y\u0003A\u0002\u0005\f!\u0002\u001d:fI&\u001c\u0017\r^3t!\rqeK\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K~\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011q\r\u001a\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017A\t;sC:\u001cH.\u0019;f)><Um\u001c)beF,X\r^*qCRL\u0017\r\u001c$jYR,'\u000fF\u0002k[>\u00042\u0001P6Z\u0013\taWH\u0001\u0004PaRLwN\u001c\u0005\u0006]\u001a\u0001\rAY\u0001\naJ,G-[2bi\u0016DQ\u0001\u001d\u0004A\u0002E\fa\u0002];tQ\u0006\u0014G.Z\"pYVlg\u000e\u0005\u0002Ee&\u00111/\u0012\u0002\u0013!V\u001c\b.\u00192mK\u000e{G.^7o\u0005\u0006\u001cX-\u0001\beSN$\u0018M\\2f\r&dG/\u001a:\u0015\u0015e3\u0018\u0011AA\f\u0003C\t)\u0003C\u0003x\u000f\u0001\u0007\u00010\u0001\u0003oC6,\u0007CA=~\u001d\tQ8\u0010\u0005\u0002Q{%\u0011A0P\u0001\u0007!J,G-\u001a4\n\u0005y|(AB*ue&twM\u0003\u0002}{!9\u00111A\u0004A\u0002\u0005\u0015\u0011\u0001B4f_6\u0004B!a\u0002\u0002\u00145\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0007\tYA\u0003\u0003\u0002\u000e\u0005=\u0011a\u00016ug*\u0019\u0011\u0011C\f\u0002\u00191|7-\u0019;j_:$Xm\u00195\n\t\u0005U\u0011\u0011\u0002\u0002\t\u000f\u0016|W.\u001a;ss\"9\u0011\u0011D\u0004A\u0002\u0005m\u0011\u0001\u00033jgR\fgnY3\u0011\u0007q\ni\"C\u0002\u0002 u\u0012a\u0001R8vE2,\u0007\u0002CA\u0012\u000fA\u0005\t\u0019\u0001=\u0002\u0019\u0011L7\u000f^1oG\u0016$\u0016\u0010]3\t\u0013\u0005\u001dr\u0001%AA\u0002\u0005%\u0012\u0001F:qQ\u0016\u0014XMU1eSV\u001cxJ^3se&$W\r\u0005\u0003=W\u0006m\u0011\u0001\u00073jgR\fgnY3GS2$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u0006\u0016\u0004q\u0006E2FAA\u001a!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005uR(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0011\u00028\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00021\u0011L7\u000f^1oG\u00164\u0015\u000e\u001c;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002H)\"\u0011\u0011FA\u0019\u0003\u001d)h.];pi\u0016$2\u0001_A'\u0011\u00159(\u00021\u0001y\u0003U\u0011Xm]8mm\u0016t\u0015-\\3B]\u0012d\u0015\u000e^3sC2$b!a\u0015\u0002b\u0005\r\u0004\u0003\u0002\u001fl\u0003+\u0002b\u0001PA,q\u0006m\u0013bAA-{\t1A+\u001e9mKJ\u00022\u0001PA/\u0013\r\ty&\u0010\u0002\u0004\u0003:L\b\"B3\f\u0001\u0004\t\u0007\"\u00029\f\u0001\u0004\t\b")
public class SpatialFilterPushDownForGeoParquet
extends Rule<LogicalPlan> {
    public final SparkSession org$apache$spark$sql$sedona_sql$optimization$SpatialFilterPushDownForGeoParquet$$sparkSession;

    public LogicalPlan apply(LogicalPlan plan) {
        boolean enableSpatialFilterPushDown = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.org$apache$spark$sql$sedona_sql$optimization$SpatialFilterPushDownForGeoParquet$$sparkSession.conf().get("spark.sedona.geoparquet.spatialFilterPushDown", "true")));
        if (!enableSpatialFilterPushDown) {
            return plan;
        }
        return (LogicalPlan)plan.transform((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFilterPushDownForGeoParquet $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Filter) {
                    LogicalRelation logicalRelation;
                    Filter filter = (Filter)A1;
                    Expression condition = filter.condition();
                    LogicalPlan lr = filter.child();
                    if (lr instanceof LogicalRelation && this.$outer.org$apache$spark$sql$sedona_sql$optimization$SpatialFilterPushDownForGeoParquet$$isGeoParquetRelation(logicalRelation = (LogicalRelation)lr)) {
                        GeoParquetFileFormatBase newFileFormat;
                        Seq<Expression> filters = ExpressionUtils$.MODULE$.splitConjunctivePredicates(condition);
                        Seq normalizedFilters = DataSourceStrategy$.MODULE$.normalizeExprs(filters, logicalRelation.output());
                        Tuple2 tuple2 = normalizedFilters.partition((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)$anonfun$apply$1.$anonfun$applyOrElse$1(e)));
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Seq normalizedFiltersWithoutSubquery = (Seq)tuple2._2();
                        Seq normalizedFiltersWithoutSubquery2 = normalizedFiltersWithoutSubquery;
                        Seq<GeoParquetSpatialFilter> geoParquetSpatialFilters = this.$outer.translateToGeoParquetSpatialFilters((Seq<Expression>)normalizedFiltersWithoutSubquery2);
                        HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)logicalRelation.relation();
                        GeoParquetFileFormatBase fileFormat = (GeoParquetFileFormatBase)hadoopFsRelation.fileFormat();
                        if (geoParquetSpatialFilters.isEmpty()) {
                            return (B1)filter;
                        }
                        GeoParquetSpatialFilter combinedSpatialFilter = (GeoParquetSpatialFilter)geoParquetSpatialFilters.reduce((Function2)GeoParquetSpatialFilter$AndFilter$.MODULE$);
                        GeoParquetFileFormatBase x$1 = newFileFormat = fileFormat.withSpatialPredicates(combinedSpatialFilter);
                        FileIndex x$2 = hadoopFsRelation.copy$default$1();
                        StructType x$3 = hadoopFsRelation.copy$default$2();
                        StructType x$4 = hadoopFsRelation.copy$default$3();
                        Option x$5 = hadoopFsRelation.copy$default$4();
                        Map x$6 = hadoopFsRelation.copy$default$6();
                        SparkSession x$7 = this.$outer.org$apache$spark$sql$sedona_sql$optimization$SpatialFilterPushDownForGeoParquet$$sparkSession;
                        HadoopFsRelation newRelation = hadoopFsRelation.copy(x$2, x$3, x$4, x$5, (FileFormat)x$1, x$6, x$7);
                        LogicalRelation x$8 = logicalRelation.copy((BaseRelation)newRelation, logicalRelation.copy$default$2(), logicalRelation.copy$default$3(), logicalRelation.copy$default$4());
                        Expression x$9 = filter.copy$default$1();
                        return (B1)filter.copy(x$9, (LogicalPlan)x$8);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalRelation logicalRelation;
                Filter filter;
                LogicalPlan lr;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof Filter && (lr = (filter = (Filter)logicalPlan).child()) instanceof LogicalRelation && this.$outer.org$apache$spark$sql$sedona_sql$optimization$SpatialFilterPushDownForGeoParquet$$isGeoParquetRelation(logicalRelation = (LogicalRelation)lr);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(Expression e) {
                return SubqueryExpression$.MODULE$.hasSubquery(e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        });
    }

    public boolean org$apache$spark$sql$sedona_sql$optimization$SpatialFilterPushDownForGeoParquet$$isGeoParquetRelation(LogicalRelation lr) {
        return lr.relation() instanceof HadoopFsRelation && ((HadoopFsRelation)lr.relation()).fileFormat() instanceof GeoParquetFileFormatBase;
    }

    public Seq<GeoParquetSpatialFilter> translateToGeoParquetSpatialFilters(Seq<Expression> predicates) {
        PushableColumnBase pushableColumn = PushableColumn$.MODULE$.apply(false);
        return (Seq)predicates.flatMap((Function1 & Serializable)predicate -> this.translateToGeoParquetSpatialFilter((Expression)predicate, pushableColumn));
    }

    private Option<GeoParquetSpatialFilter> translateToGeoParquetSpatialFilter(Expression predicate, PushableColumnBase pushableColumn) {
        ST_DWithin sT_DWithin;
        Seq<Expression> args;
        SeqOps seqOps;
        Seq<Expression> seq;
        SeqOps seqOps2;
        Seq<Expression> seq2;
        SeqOps seqOps3;
        Seq<Expression> seq3;
        SeqOps seqOps4;
        Seq<Expression> seq4;
        boolean bl = false;
        ST_Contains sT_Contains = null;
        boolean bl2 = false;
        ST_Covers sT_Covers = null;
        boolean bl3 = false;
        ST_Within sT_Within = null;
        boolean bl4 = false;
        ST_CoveredBy sT_CoveredBy = null;
        boolean bl5 = false;
        LessThan lessThan = null;
        boolean bl6 = false;
        LessThanOrEqual lessThanOrEqual = null;
        Expression expression = predicate;
        if (expression instanceof And) {
            Option<GeoParquetSpatialFilter> spatialFilterRight;
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            Option<GeoParquetSpatialFilter> spatialFilterLeft2 = this.translateToGeoParquetSpatialFilter(left, pushableColumn);
            Tuple2 tuple2 = new Tuple2(spatialFilterLeft2, spatialFilterRight = this.translateToGeoParquetSpatialFilter(right, pushableColumn));
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    GeoParquetSpatialFilter l = (GeoParquetSpatialFilter)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        GeoParquetSpatialFilter r = (GeoParquetSpatialFilter)some2.value();
                        return new Some((Object)new GeoParquetSpatialFilter.AndFilter(l, r));
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    GeoParquetSpatialFilter l = (GeoParquetSpatialFilter)some.value();
                    if (None$.MODULE$.equals(option3)) {
                        return new Some((Object)l);
                    }
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                    Some some = (Some)option4;
                    GeoParquetSpatialFilter r = (GeoParquetSpatialFilter)some.value();
                    return new Some((Object)r);
                }
            }
            return None$.MODULE$;
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            return this.translateToGeoParquetSpatialFilter(left, pushableColumn).flatMap((Function1 & Serializable)spatialFilterLeft -> this.translateToGeoParquetSpatialFilter(right, pushableColumn).map((Function1 & Serializable)spatialFilterRight -> new GeoParquetSpatialFilter.OrFilter((GeoParquetSpatialFilter)spatialFilterLeft, (GeoParquetSpatialFilter)spatialFilterRight)));
        }
        if (expression instanceof Not) {
            return None$.MODULE$;
        }
        if (expression instanceof ST_Contains) {
            SeqOps seqOps5;
            bl = true;
            sT_Contains = (ST_Contains)expression;
            Seq<Expression> seq5 = sT_Contains.inputExpressions();
            if (seq5 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps5 = package$.MODULE$.Seq().unapplySeq(seq5)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 2) == 0) {
                Option option;
                Expression expression2 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 0);
                Expression expression3 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps5), 1);
                if (expression2 != null && !(option = pushableColumn.unapply(expression2)).isEmpty()) {
                    String name = (String)option.get();
                    if (expression3 instanceof Literal) {
                        Literal literal = (Literal)expression3;
                        Object v = literal.value();
                        return new Some((Object)new GeoParquetSpatialFilter.LeafFilter(this.unquote(name), SpatialPredicate.COVERS, GeometryUDT$.MODULE$.deserialize(v)));
                    }
                }
            }
        }
        if (bl && (seq4 = sT_Contains.inputExpressions()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = package$.MODULE$.Seq().unapplySeq(seq4)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 2) == 0) {
            Expression expression4 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0);
            Expression expression5 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1);
            if (expression4 instanceof Literal) {
                Option option;
                Literal literal = (Literal)expression4;
                Object v = literal.value();
                if (expression5 != null && !(option = pushableColumn.unapply(expression5)).isEmpty()) {
                    String name = (String)option.get();
                    return new Some((Object)new GeoParquetSpatialFilter.LeafFilter(this.unquote(name), SpatialPredicate.INTERSECTS, GeometryUDT$.MODULE$.deserialize(v)));
                }
            }
        }
        if (expression instanceof ST_Covers) {
            SeqOps seqOps6;
            bl2 = true;
            sT_Covers = (ST_Covers)expression;
            Seq<Expression> seq6 = sT_Covers.inputExpressions();
            if (seq6 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps6 = package$.MODULE$.Seq().unapplySeq(seq6)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 2) == 0) {
                Option option;
                Expression expression6 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 0);
                Expression expression7 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps6), 1);
                if (expression6 != null && !(option = pushableColumn.unapply(expression6)).isEmpty()) {
                    String name = (String)option.get();
                    if (expression7 instanceof Literal) {
                        Literal literal = (Literal)expression7;
                        Object v = literal.value();
                        return new Some((Object)new GeoParquetSpatialFilter.LeafFilter(this.unquote(name), SpatialPredicate.COVERS, GeometryUDT$.MODULE$.deserialize(v)));
                    }
                }
            }
        }
        if (bl2 && (seq3 = sT_Covers.inputExpressions()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.Seq().unapplySeq(seq3)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 2) == 0) {
            Expression expression8 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0);
            Expression expression9 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1);
            if (expression8 instanceof Literal) {
                Option option;
                Literal literal = (Literal)expression8;
                Object v = literal.value();
                if (expression9 != null && !(option = pushableColumn.unapply(expression9)).isEmpty()) {
                    String name = (String)option.get();
                    return new Some((Object)new GeoParquetSpatialFilter.LeafFilter(this.unquote(name), SpatialPredicate.INTERSECTS, GeometryUDT$.MODULE$.deserialize(v)));
                }
            }
        }
        if (expression instanceof ST_Within) {
            SeqOps seqOps7;
            bl3 = true;
            sT_Within = (ST_Within)expression;
            Seq<Expression> seq7 = sT_Within.inputExpressions();
            if (seq7 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps7 = package$.MODULE$.Seq().unapplySeq(seq7)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 2) == 0) {
                Option option;
                Expression expression10 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 0);
                Expression expression11 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps7), 1);
                if (expression10 != null && !(option = pushableColumn.unapply(expression10)).isEmpty()) {
                    String name = (String)option.get();
                    if (expression11 instanceof Literal) {
                        Literal literal = (Literal)expression11;
                        Object v = literal.value();
                        return new Some((Object)new GeoParquetSpatialFilter.LeafFilter(this.unquote(name), SpatialPredicate.INTERSECTS, GeometryUDT$.MODULE$.deserialize(v)));
                    }
                }
            }
        }
        if (bl3 && (seq2 = sT_Within.inputExpressions()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq(seq2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
            Expression expression12 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            Expression expression13 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            if (expression12 instanceof Literal) {
                Option option;
                Literal literal = (Literal)expression12;
                Object v = literal.value();
                if (expression13 != null && !(option = pushableColumn.unapply(expression13)).isEmpty()) {
                    String name = (String)option.get();
                    return new Some((Object)new GeoParquetSpatialFilter.LeafFilter(this.unquote(name), SpatialPredicate.COVERS, GeometryUDT$.MODULE$.deserialize(v)));
                }
            }
        }
        if (expression instanceof ST_CoveredBy) {
            SeqOps seqOps8;
            bl4 = true;
            sT_CoveredBy = (ST_CoveredBy)expression;
            Seq<Expression> seq8 = sT_CoveredBy.inputExpressions();
            if (seq8 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps8 = package$.MODULE$.Seq().unapplySeq(seq8)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 2) == 0) {
                Option option;
                Expression expression14 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 0);
                Expression expression15 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps8), 1);
                if (expression14 != null && !(option = pushableColumn.unapply(expression14)).isEmpty()) {
                    String name = (String)option.get();
                    if (expression15 instanceof Literal) {
                        Literal literal = (Literal)expression15;
                        Object v = literal.value();
                        return new Some((Object)new GeoParquetSpatialFilter.LeafFilter(this.unquote(name), SpatialPredicate.INTERSECTS, GeometryUDT$.MODULE$.deserialize(v)));
                    }
                }
            }
        }
        if (bl4 && (seq = sT_CoveredBy.inputExpressions()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Expression expression16 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Expression expression17 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (expression16 instanceof Literal) {
                Option option;
                Literal literal = (Literal)expression16;
                Object v = literal.value();
                if (expression17 != null && !(option = pushableColumn.unapply(expression17)).isEmpty()) {
                    String name = (String)option.get();
                    return new Some((Object)new GeoParquetSpatialFilter.LeafFilter(this.unquote(name), SpatialPredicate.COVERS, GeometryUDT$.MODULE$.deserialize(v)));
                }
            }
        }
        if (expression instanceof ST_Equals ? true : expression instanceof ST_OrderingEquals) {
            return this.resolveNameAndLiteral((Seq<Expression>)predicate.children(), pushableColumn).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SpatialFilterPushDownForGeoParquet.$anonfun$translateToGeoParquetSpatialFilter$3(check$ifrefutable$1))).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Object value = tuple2._2();
                    return new GeoParquetSpatialFilter.LeafFilter(this.unquote(name), SpatialPredicate.COVERS, GeometryUDT$.MODULE$.deserialize(value));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        if (expression instanceof ST_Intersects ? true : (expression instanceof ST_Crosses ? true : (expression instanceof ST_Overlaps ? true : expression instanceof ST_Touches))) {
            return this.resolveNameAndLiteral((Seq<Expression>)predicate.children(), pushableColumn).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SpatialFilterPushDownForGeoParquet.$anonfun$translateToGeoParquetSpatialFilter$5(check$ifrefutable$2))).map((Function1 & Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Object value = tuple2._2();
                    return new GeoParquetSpatialFilter.LeafFilter(this.unquote(name), SpatialPredicate.INTERSECTS, GeometryUDT$.MODULE$.deserialize(value));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        if (expression instanceof LessThan) {
            bl5 = true;
            lessThan = (LessThan)expression;
            Expression expression18 = lessThan.left();
            Expression expression19 = lessThan.right();
            if (expression18 instanceof ST_Distance) {
                ST_Distance sT_Distance = (ST_Distance)expression18;
                Seq<Expression> distArgs = sT_Distance.inputExpressions();
                if (expression19 instanceof Literal) {
                    Literal literal = (Literal)expression19;
                    Object d = literal.value();
                    DataType dataType = literal.dataType();
                    if (DoubleType$.MODULE$.equals(dataType)) {
                        return this.resolveNameAndLiteral(distArgs, pushableColumn).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)SpatialFilterPushDownForGeoParquet.$anonfun$translateToGeoParquetSpatialFilter$7(check$ifrefutable$3))).map((Function1 & Serializable)x$3 -> {
                            Tuple2 tuple2 = x$3;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                Object value = tuple2._2();
                                return this.distanceFilter(name, GeometryUDT$.MODULE$.deserialize(value), BoxesRunTime.unboxToDouble((Object)d), this.distanceFilter$default$4(), this.distanceFilter$default$5());
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                }
            }
        }
        if (expression instanceof LessThanOrEqual) {
            bl6 = true;
            lessThanOrEqual = (LessThanOrEqual)expression;
            Expression expression20 = lessThanOrEqual.left();
            Expression expression21 = lessThanOrEqual.right();
            if (expression20 instanceof ST_Distance) {
                ST_Distance sT_Distance = (ST_Distance)expression20;
                Seq<Expression> distArgs = sT_Distance.inputExpressions();
                if (expression21 instanceof Literal) {
                    Literal literal = (Literal)expression21;
                    Object d = literal.value();
                    DataType dataType = literal.dataType();
                    if (DoubleType$.MODULE$.equals(dataType)) {
                        return this.resolveNameAndLiteral(distArgs, pushableColumn).withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)SpatialFilterPushDownForGeoParquet.$anonfun$translateToGeoParquetSpatialFilter$9(check$ifrefutable$4))).map((Function1 & Serializable)x$4 -> {
                            Tuple2 tuple2 = x$4;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                Object value = tuple2._2();
                                return this.distanceFilter(name, GeometryUDT$.MODULE$.deserialize(value), BoxesRunTime.unboxToDouble((Object)d), this.distanceFilter$default$4(), this.distanceFilter$default$5());
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                }
            }
        }
        if (bl5) {
            Expression expression22 = lessThan.left();
            Expression expression23 = lessThan.right();
            if (expression22 instanceof ST_DistanceSpheroid) {
                ST_DistanceSpheroid sT_DistanceSpheroid = (ST_DistanceSpheroid)expression22;
                Seq<Expression> distArgs = sT_DistanceSpheroid.inputExpressions();
                if (expression23 instanceof Literal) {
                    Literal literal = (Literal)expression23;
                    Object d = literal.value();
                    DataType dataType = literal.dataType();
                    if (DoubleType$.MODULE$.equals(dataType)) {
                        return this.resolveNameAndLiteral(distArgs, pushableColumn).withFilter((Function1 & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)SpatialFilterPushDownForGeoParquet.$anonfun$translateToGeoParquetSpatialFilter$11(check$ifrefutable$5))).map((Function1 & Serializable)x$5 -> {
                            Tuple2 tuple2 = x$5;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                Object value = tuple2._2();
                                return this.distanceFilter(name, GeometryUDT$.MODULE$.deserialize(value), BoxesRunTime.unboxToDouble((Object)d), "spheroid", this.distanceFilter$default$5());
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                }
            }
        }
        if (bl6) {
            Expression expression24 = lessThanOrEqual.left();
            Expression expression25 = lessThanOrEqual.right();
            if (expression24 instanceof ST_DistanceSpheroid) {
                ST_DistanceSpheroid sT_DistanceSpheroid = (ST_DistanceSpheroid)expression24;
                Seq<Expression> distArgs = sT_DistanceSpheroid.inputExpressions();
                if (expression25 instanceof Literal) {
                    Literal literal = (Literal)expression25;
                    Object d = literal.value();
                    DataType dataType = literal.dataType();
                    if (DoubleType$.MODULE$.equals(dataType)) {
                        return this.resolveNameAndLiteral(distArgs, pushableColumn).withFilter((Function1 & Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)SpatialFilterPushDownForGeoParquet.$anonfun$translateToGeoParquetSpatialFilter$13(check$ifrefutable$6))).map((Function1 & Serializable)x$6 -> {
                            Tuple2 tuple2 = x$6;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                Object value = tuple2._2();
                                return this.distanceFilter(name, GeometryUDT$.MODULE$.deserialize(value), BoxesRunTime.unboxToDouble((Object)d), "spheroid", this.distanceFilter$default$5());
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                }
            }
        }
        if (bl5) {
            Expression expression26 = lessThan.left();
            Expression expression27 = lessThan.right();
            if (expression26 instanceof ST_DistanceSphere) {
                ST_DistanceSphere sT_DistanceSphere = (ST_DistanceSphere)expression26;
                Seq<Expression> distArgs = sT_DistanceSphere.inputExpressions();
                if (expression27 instanceof Literal) {
                    Literal literal = (Literal)expression27;
                    Object d = literal.value();
                    DataType dataType = literal.dataType();
                    if (DoubleType$.MODULE$.equals(dataType)) {
                        Option radiusOpt = ((Option)distArgs.lift().apply((Object)BoxesRunTime.boxToInteger((int)2))).collect((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof Literal) {
                                    Literal literal = (Literal)A1;
                                    Object customRadius = literal.value();
                                    DataType dataType = literal.dataType();
                                    if (customRadius instanceof Double) {
                                        double d = BoxesRunTime.unboxToDouble((Object)customRadius);
                                        if (DoubleType$.MODULE$.equals(dataType)) {
                                            return (B1)BoxesRunTime.boxToDouble((double)d);
                                        }
                                    }
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(Expression x1) {
                                Expression expression = x1;
                                if (expression instanceof Literal) {
                                    Literal literal = (Literal)expression;
                                    Object customRadius = literal.value();
                                    DataType dataType = literal.dataType();
                                    if (customRadius instanceof Double && DoubleType$.MODULE$.equals(dataType)) {
                                        return true;
                                    }
                                }
                                return false;
                            }
                        });
                        return this.resolveNameAndLiteral((Seq<Expression>)((Seq)distArgs.take(2)), pushableColumn).map((Function1 & Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                Object value = tuple2._2();
                                return this.distanceFilter(name, GeometryUDT$.MODULE$.deserialize(value), BoxesRunTime.unboxToDouble((Object)d), "sphere", (Option<Object>)radiusOpt);
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                }
            }
        }
        if (bl6) {
            Expression expression28 = lessThanOrEqual.left();
            Expression expression29 = lessThanOrEqual.right();
            if (expression28 instanceof ST_DistanceSphere) {
                ST_DistanceSphere sT_DistanceSphere = (ST_DistanceSphere)expression28;
                Seq<Expression> distArgs = sT_DistanceSphere.inputExpressions();
                if (expression29 instanceof Literal) {
                    Literal literal = (Literal)expression29;
                    Object d = literal.value();
                    DataType dataType = literal.dataType();
                    if (DoubleType$.MODULE$.equals(dataType)) {
                        Option radiusOpt = ((Option)distArgs.lift().apply((Object)BoxesRunTime.boxToInteger((int)2))).collect((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                A1 A1 = x2;
                                if (A1 instanceof Literal) {
                                    Literal literal = (Literal)A1;
                                    Object customRadius = literal.value();
                                    DataType dataType = literal.dataType();
                                    if (customRadius instanceof Double) {
                                        double d = BoxesRunTime.unboxToDouble((Object)customRadius);
                                        if (DoubleType$.MODULE$.equals(dataType)) {
                                            return (B1)BoxesRunTime.boxToDouble((double)d);
                                        }
                                    }
                                }
                                return (B1)function1.apply(x2);
                            }

                            public final boolean isDefinedAt(Expression x2) {
                                Expression expression = x2;
                                if (expression instanceof Literal) {
                                    Literal literal = (Literal)expression;
                                    Object customRadius = literal.value();
                                    DataType dataType = literal.dataType();
                                    if (customRadius instanceof Double && DoubleType$.MODULE$.equals(dataType)) {
                                        return true;
                                    }
                                }
                                return false;
                            }
                        });
                        return this.resolveNameAndLiteral((Seq<Expression>)((Seq)distArgs.take(2)), pushableColumn).map((Function1 & Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                Object value = tuple2._2();
                                return this.distanceFilter(name, GeometryUDT$.MODULE$.deserialize(value), BoxesRunTime.unboxToDouble((Object)d), "sphere", (Option<Object>)radiusOpt);
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                }
            }
        }
        if (expression instanceof ST_DWithin && ((args = (sT_DWithin = (ST_DWithin)expression).inputExpressions()).length() == 3 || args.length() == 4)) {
            boolean bl7;
            Literal literal;
            Object flag;
            Some some;
            Expression expression30;
            Expression distanceLit = (Expression)args.apply(2);
            Option option = (Option)args.lift().apply((Object)BoxesRunTime.boxToInteger((int)3));
            String distanceType = option instanceof Some && (expression30 = (Expression)(some = (Some)option).value()) instanceof Literal && (flag = (literal = (Literal)expression30).value()) instanceof Boolean ? ((bl7 = BoxesRunTime.unboxToBoolean((Object)flag)) ? "spheroid" : "planar") : "planar";
            Expression expression31 = distanceLit;
            if (expression31 instanceof Literal) {
                Literal literal2 = (Literal)expression31;
                Object distance = literal2.value();
                DataType dataType = literal2.dataType();
                if (distance instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)distance);
                    if (DoubleType$.MODULE$.equals(dataType)) {
                        return this.resolveNameAndLiteral((Seq<Expression>)((Seq)args.take(2)), pushableColumn).map((Function1 & Serializable)x0$3 -> {
                            Tuple2 tuple2 = x0$3;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                Object value = tuple2._2();
                                return this.distanceFilter(name, GeometryUDT$.MODULE$.deserialize(value), d, distanceType, this.distanceFilter$default$5());
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                }
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private GeoParquetSpatialFilter distanceFilter(String name, Geometry geom, double distance, String distanceType, Option<Object> sphereRadiusOverride) {
        Geometry geometry;
        block4: {
            String string = distanceType;
            switch (string == null ? 0 : string.hashCode()) {
                case -2044863694: {
                    Geometry bufferGeometry;
                    if (!"spheroid".equals(string)) break;
                    Literal distanceLit = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(distance * 1.03)));
                    Literal spheroidLit = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    Literal geomLit = Literal$.MODULE$.create((Object)GeometrySerializer$.MODULE$.serialize(geom), (DataType)new GeometryUDT());
                    ST_Buffer bufferExpr = new ST_Buffer((Seq<Expression>)new .colon.colon((Object)geomLit, (List)new .colon.colon((Object)distanceLit, (List)new .colon.colon((Object)spheroidLit, (List)Nil$.MODULE$))));
                    byte[] wkb = (byte[])bufferExpr.eval(bufferExpr.eval$default$1());
                    geometry = bufferGeometry = GeometrySerializer$.MODULE$.deserialize(wkb);
                    break block4;
                }
                case -895981619: {
                    if (!"sphere".equals(string)) break;
                    double radius = BoxesRunTime.unboxToDouble((Object)sphereRadiusOverride.getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 6371008.0));
                    Envelope expandedEnvelope = Haversine.expandEnvelope(geom.getEnvelopeInternal(), distance, radius);
                    geometry = geom.getFactory().toGeometry(expandedEnvelope);
                    break block4;
                }
            }
            Envelope envelope = geom.getEnvelopeInternal();
            envelope.expandBy(distance);
            geometry = geom.getFactory().toGeometry(envelope);
        }
        Geometry queryWindow = geometry;
        return new GeoParquetSpatialFilter.LeafFilter(this.unquote(name), SpatialPredicate.INTERSECTS, queryWindow);
    }

    private String distanceFilter$default$4() {
        return "planar";
    }

    private Option<Object> distanceFilter$default$5() {
        return None$.MODULE$;
    }

    private String unquote(String name) {
        return CatalogV2Implicits$.MODULE$.parseColumnPath(name).mkString(".");
    }

    private Option<Tuple2<String, Object>> resolveNameAndLiteral(Seq<Expression> expressions, PushableColumnBase pushableColumn) {
        SeqOps seqOps;
        SeqOps seqOps2;
        Seq<Expression> seq = expressions;
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
            Option option;
            Expression expression = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
            Expression expression2 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
            if (expression != null && !(option = pushableColumn.unapply(expression)).isEmpty()) {
                String name = (String)option.get();
                if (expression2 instanceof Literal) {
                    Literal literal = (Literal)expression2;
                    Object v = literal.value();
                    return new Some((Object)new Tuple2((Object)name, v));
                }
            }
        }
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Expression expression = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Expression expression3 = (Expression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (expression instanceof Literal) {
                Option option;
                Literal literal = (Literal)expression;
                Object v = literal.value();
                if (expression3 != null && !(option = pushableColumn.unapply(expression3)).isEmpty()) {
                    String name = (String)option.get();
                    return new Some((Object)new Tuple2((Object)name, v));
                }
            }
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$translateToGeoParquetSpatialFilter$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$translateToGeoParquetSpatialFilter$5(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$translateToGeoParquetSpatialFilter$7(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$translateToGeoParquetSpatialFilter$9(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$translateToGeoParquetSpatialFilter$11(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$translateToGeoParquetSpatialFilter$13(Tuple2 check$ifrefutable$6) {
        Tuple2 tuple2 = check$ifrefutable$6;
        return tuple2 != null;
    }

    public SpatialFilterPushDownForGeoParquet(SparkSession sparkSession) {
        this.org$apache$spark$sql$sedona_sql$optimization$SpatialFilterPushDownForGeoParquet$$sparkSession = sparkSession;
    }
}

