/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.Serializable;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;
import org.apache.sedona.shaded.guava.primitives.Ints;
import org.apache.sedona.shaded.s2.Platform;
import org.apache.sedona.shaded.s2.S1Distance;
import org.apache.sedona.shaded.s2.S2Point;

@JsType
public final class S1Angle
implements S1Distance<S1Angle>,
Serializable {
    public static final S1Angle INFINITY = new S1Angle(Double.POSITIVE_INFINITY);
    public static final S1Angle ZERO = new S1Angle();
    private final double radians;

    public static S1Angle radians(double radians2) {
        return new S1Angle(radians2);
    }

    public double radians() {
        return this.radians;
    }

    public static S1Angle degrees(double degrees2) {
        return new S1Angle(degrees2 * (Math.PI / 180));
    }

    public double degrees() {
        return this.radians * 57.29577951308232;
    }

    public static S1Angle e5(int e5) {
        return S1Angle.degrees((double)e5 * 1.0E-5);
    }

    public int e5() {
        return Ints.checkedCast(Math.round(this.degrees() * 100000.0));
    }

    public static S1Angle e6(int e6) {
        return S1Angle.degrees((double)e6 * 1.0E-6);
    }

    public int e6() {
        return Ints.checkedCast(Math.round(this.degrees() * 1000000.0));
    }

    public static S1Angle e7(int e7) {
        return S1Angle.degrees((double)e7 * 1.0E-7);
    }

    public int e7() {
        return Ints.checkedCast(Math.round(this.degrees() * 1.0E7));
    }

    @JsIgnore
    public S1Angle() {
        this(0.0);
    }

    @JsConstructor
    private S1Angle(double radians2) {
        this.radians = radians2;
    }

    @JsIgnore
    public S1Angle(S2Point x, S2Point y) {
        this(x.angle(y));
    }

    public boolean equals(Object that) {
        if (that instanceof S1Angle) {
            return this.radians == ((S1Angle)that).radians;
        }
        return false;
    }

    @Override
    public boolean isZero() {
        return this.radians == 0.0;
    }

    public int hashCode() {
        long value = Double.doubleToLongBits(this.radians);
        return (int)(value ^ value >>> 32);
    }

    @Override
    public boolean lessThan(S1Angle that) {
        return this.radians < that.radians;
    }

    @Override
    public boolean greaterThan(S1Angle that) {
        return this.radians > that.radians;
    }

    @Override
    public boolean lessOrEquals(S1Angle that) {
        return this.radians <= that.radians;
    }

    @Override
    public boolean greaterOrEquals(S1Angle that) {
        return this.radians >= that.radians;
    }

    public static S1Angle max(S1Angle left, S1Angle right) {
        return right.greaterThan(left) ? right : left;
    }

    public static S1Angle min(S1Angle left, S1Angle right) {
        return right.greaterThan(left) ? left : right;
    }

    public double distance(double radius) {
        return this.radians * radius;
    }

    public S1Angle abs() {
        return new S1Angle(Math.abs(this.radians));
    }

    public S1Angle neg() {
        return new S1Angle(-this.radians);
    }

    @CheckReturnValue
    public S1Angle add(S1Angle a) {
        return new S1Angle(this.radians + a.radians);
    }

    @CheckReturnValue
    public S1Angle sub(S1Angle a) {
        return new S1Angle(this.radians - a.radians);
    }

    @CheckReturnValue
    public S1Angle mul(double m3) {
        return new S1Angle(this.radians * m3);
    }

    @CheckReturnValue
    public S1Angle div(double d) {
        return new S1Angle(this.radians / d);
    }

    @JsIgnore
    @CheckReturnValue
    public double div(S1Angle other) {
        return this.radians / other.radians;
    }

    public double cos() {
        return Math.cos(this.radians);
    }

    public double sin() {
        return Math.sin(this.radians);
    }

    public double tan() {
        return Math.tan(this.radians);
    }

    @CheckReturnValue
    public S1Angle normalize() {
        if (this.radians > -Math.PI && this.radians <= Math.PI) {
            return this;
        }
        double normalized = Platform.IEEEremainder(this.radians, Math.PI * 2);
        if (normalized <= -Math.PI) {
            normalized = Math.PI;
        }
        assert (normalized > -Math.PI);
        assert (normalized <= Math.PI);
        return new S1Angle(normalized);
    }

    public String toString() {
        return this.degrees() + "d";
    }

    @Override
    public int compareTo(S1Angle that) {
        return this.radians < that.radians ? -1 : (this.radians > that.radians ? 1 : 0);
    }

    public Builder toBuilder() {
        return new Builder().add(this);
    }

    @JsType
    public static final class Builder {
        private double radians;

        @CanIgnoreReturnValue
        public Builder add(S1Angle angle) {
            this.radians += angle.radians;
            return this;
        }

        @JsMethod(name="addRadians")
        @CanIgnoreReturnValue
        public Builder add(double radians2) {
            this.radians += radians2;
            return this;
        }

        public S1Angle build() {
            return new S1Angle(this.radians);
        }
    }
}

