/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v16.bst;

import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.util.StringBuilderLn;
import ch.ethz.globis.phtree.v16.Node;
import ch.ethz.globis.phtree.v16.PhTree16;
import java.util.Arrays;
import java.util.function.BiFunction;

public class BSTreePage {
    private static final int INITIAL_PAGE_SIZE = 4;
    private BSTreePage parent;
    private long[] keys;
    private Node.BSTEntry[] values;
    private int nEntries;
    private boolean isLeaf;
    private BSTreePage[] subPages;
    private BSTreePage prevLeaf;
    private BSTreePage nextLeaf;
    private final PhTree16<?> tree;
    @Deprecated
    private static final int NO_POS = -1000;

    BSTreePage(Node ind, BSTreePage parent, boolean isLeaf, BSTreePage leftPredecessor, PhTree16<?> tree) {
        this.tree = tree;
        this.init(ind, parent, isLeaf, leftPredecessor);
    }

    void init(Node ind, BSTreePage parent, boolean isLeaf, BSTreePage leftPredecessor) {
        this.nextLeaf = null;
        this.prevLeaf = null;
        this.parent = parent;
        if (isLeaf) {
            this.nEntries = 0;
            int initialPageSize = ind.maxLeafN() <= 8 ? 2 : 4;
            this.keys = this.tree.bstPool().arrayCreateLong(initialPageSize);
            this.values = this.tree.bstPool().arrayCreateEntries(initialPageSize);
            this.subPages = null;
            ++Node.statNLeaves;
        } else {
            this.nEntries = -1;
            this.keys = this.tree.bstPool().arrayCreateLong(ind.maxInnerN());
            this.values = null;
            this.subPages = this.tree.bstPool().arrayCreateNodes(ind.maxInnerN() + 1);
            ++Node.statNInner;
        }
        this.isLeaf = isLeaf;
        if (isLeaf && leftPredecessor != null) {
            this.nextLeaf = leftPredecessor.nextLeaf;
            this.prevLeaf = leftPredecessor;
            leftPredecessor.nextLeaf = this;
            if (this.nextLeaf != null) {
                this.nextLeaf.prevLeaf = this;
            }
        } else {
            this.nextLeaf = null;
            this.prevLeaf = null;
        }
    }

    public void init(Node.BSTEntry e1, Node.BSTEntry e2) {
        if (!this.isLeaf) {
            throw new IllegalStateException();
        }
        if (this.nEntries > 0) {
            throw new IllegalStateException("nEntries=" + this.nEntries);
        }
        this.values[0] = e1;
        this.keys[0] = e1.getKey();
        this.values[1] = e2;
        this.keys[1] = e2.getKey();
        this.nEntries = 2;
    }

    public static BSTreePage create(Node ind, BSTreePage parent, boolean isLeaf, BSTreePage leftPredecessor, PhTree16<?> tree) {
        return tree.bstPool().getNode(ind, parent, isLeaf, leftPredecessor, tree);
    }

    public static BSTreePage create(Node ind, BSTreePage parent, BSTreePage firstSubpage, BSTreePage secondSubpage, PhTree16<?> tree) {
        BSTreePage p = BSTreePage.create(ind, parent, false, null, tree);
        ++p.nEntries;
        p.subPages[0] = firstSubpage;
        ++p.nEntries;
        p.subPages[1] = secondSubpage;
        p.keys[0] = secondSubpage.getMinKey();
        firstSubpage.setParent(p);
        secondSubpage.setParent(p);
        return p;
    }

    private int maxInnerN() {
        return this.keys.length;
    }

    private int minLeafN(int maxLeafN) {
        return maxLeafN >> 1;
    }

    private int minInnerN(int maxInnerN) {
        return maxInnerN >> 1;
    }

    public BSTreePage findSubPage(long key) {
        int pos = this.binarySearchInnerNode(key);
        return this.subPages[pos];
    }

    public Node.BSTEntry findAndRemove(long key, long[] kdKey, Node node, PhTree16.UpdateInfo ui) {
        Node.BSTEntry result;
        int pos = this.binarySearchInnerNode(key);
        BSTreePage page = this.subPages[pos];
        if (page.isLeaf()) {
            result = page.remove(key, kdKey, node, ui);
            this.checkUnderflowSubpageLeaf(pos, node);
        } else {
            result = page.findAndRemove(key, kdKey, node, ui);
            this.handleUnderflowSubInner(pos);
        }
        return result;
    }

    public Object getOrCreate(long key, Node ind) {
        int pos = this.binarySearchInnerNode(key);
        BSTreePage page = this.getPageByPos(pos);
        if (page.isLeaf()) {
            Node.BSTEntry o = page.getOrCreate(key, this, pos, ind);
            if (o.getKdKey() == null && o.getValue() instanceof BSTreePage) {
                BSTreePage newPage = (BSTreePage)o.getValue();
                this.addSubPage(newPage, newPage.getMinKey(), pos, ind);
                o.setValue(null);
                return o;
            }
            return o;
        }
        return page;
    }

    public Node.BSTEntry getValueFromLeaf(long key) {
        int pos = this.binarySearch(key);
        if (pos >= 0) {
            return this.values[pos];
        }
        return null;
    }

    public int binarySearchInnerNode(long key) {
        if (this.nEntries <= 8) {
            long[] keys = this.keys;
            for (int i = 0; i < this.nEntries; ++i) {
                if (key > keys[i]) continue;
                return key == keys[i] ? i + 1 : i;
            }
            return this.nEntries;
        }
        long[] keys = this.keys;
        int low = 0;
        int high = this.nEntries - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = keys[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid + 1;
        }
        return low;
    }

    int binarySearch(long key) {
        if (this.nEntries <= 8) {
            return this.linearSearch(key);
        }
        long[] keys = this.keys;
        int low = 0;
        int high = this.nEntries - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = keys[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private int linearSearch(long key) {
        long[] keys = this.keys;
        for (int i = 0; i < this.nEntries; ++i) {
            if (key > keys[i]) continue;
            return key == keys[i] ? i : -(i + 1);
        }
        return -(this.nEntries + 1);
    }

    private void putUnchecked(int pos, long key, Node.BSTEntry value, Node ind) {
        this.shiftArrayForInsertion(pos, ind);
        this.keys[pos] = key;
        this.values[pos] = value;
        ++this.nEntries;
        ind.incEntryCount();
    }

    private void shiftArrayForInsertion(int pos, Node ind) {
        this.ensureSizePlusOne(ind);
        if (pos < this.nEntries) {
            System.arraycopy(this.keys, pos, this.keys, pos + 1, this.nEntries - pos);
            System.arraycopy(this.values, pos, this.values, pos + 1, this.nEntries - pos);
        }
    }

    private void ensureSizePlusOne(Node ind) {
        if (this.nEntries + 1 > this.keys.length) {
            int newLen = this.keys.length * 2 > ind.maxLeafN() ? ind.maxLeafN() : this.keys.length * 2;
            this.keys = this.tree.bstPool().arrayExpand(this.keys, newLen);
            this.values = this.tree.bstPool().arrayExpand(this.values, newLen);
        }
    }

    private void ensureSize(int newLen) {
        if (newLen > this.keys.length) {
            this.keys = this.tree.bstPool().arrayExpand(this.keys, newLen);
            this.values = this.tree.bstPool().arrayExpand(this.values, newLen);
        }
    }

    public final Node.BSTEntry getOrCreate(long key, BSTreePage parent, int posPageInParent, Node ind) {
        if (!this.isLeaf) {
            throw new IllegalStateException("Tree inconsistency.");
        }
        int pos = this.binarySearch(key);
        if (pos >= 0) {
            return this.values[pos];
        }
        return this.create(key, pos, parent, posPageInParent, ind);
    }

    private Node.BSTEntry create(long key, int pos, BSTreePage parent, int posPageInParent, Node ind) {
        BSTreePage destP;
        Node.BSTEntry value = this.tree.bstPool().getEntry();
        value.set(key, null, null);
        if (this.nEntries < ind.maxLeafN()) {
            pos = -(pos + 1);
            this.ensureSizePlusOne(ind);
            if (pos < this.nEntries) {
                System.arraycopy(this.keys, pos, this.keys, pos + 1, this.nEntries - pos);
                System.arraycopy(this.values, pos, this.values, pos + 1, this.nEntries - pos);
            }
            this.keys[pos] = key;
            this.values[pos] = value;
            ++this.nEntries;
            ind.incEntryCount();
            return value;
        }
        boolean isNew = false;
        boolean isPrev = false;
        if (parent == null) {
            destP = ind.bstCreatePage(null, true, this, this.tree);
            isNew = true;
        } else {
            BSTreePage next = parent.getNextLeafPage(posPageInParent);
            if (next != null && next.nEntries < ind.maxLeafN() - 1) {
                destP = next;
                isPrev = false;
            } else {
                BSTreePage prev = parent.getPrevLeafPage(posPageInParent);
                if (prev != null && prev.nEntries < ind.maxLeafN() - 1) {
                    destP = prev;
                    isPrev = true;
                } else {
                    destP = ind.bstCreatePage(parent, true, this, this.tree);
                    isNew = true;
                }
            }
        }
        this.ensureSize(ind.maxLeafN());
        destP.ensureSize(ind.maxLeafN());
        int nEntriesToKeep = this.nEntries + destP.nEntries >> 1;
        int nEntriesToCopy = this.nEntries - nEntriesToKeep;
        if (isNew) {
            System.arraycopy(this.keys, nEntriesToKeep, destP.keys, 0, nEntriesToCopy);
            System.arraycopy(this.values, nEntriesToKeep, destP.values, 0, nEntriesToCopy);
        } else if (isPrev) {
            System.arraycopy(this.keys, 0, destP.keys, destP.nEntries, nEntriesToCopy);
            System.arraycopy(this.values, 0, destP.values, destP.nEntries, nEntriesToCopy);
            System.arraycopy(this.keys, nEntriesToCopy, this.keys, 0, this.nEntries - nEntriesToCopy);
            System.arraycopy(this.values, nEntriesToCopy, this.values, 0, this.nEntries - nEntriesToCopy);
        } else {
            System.arraycopy(destP.keys, 0, destP.keys, nEntriesToCopy, destP.nEntries);
            System.arraycopy(destP.values, 0, destP.values, nEntriesToCopy, destP.nEntries);
            System.arraycopy(this.keys, nEntriesToKeep, destP.keys, 0, nEntriesToCopy);
            System.arraycopy(this.values, nEntriesToKeep, destP.values, 0, nEntriesToCopy);
        }
        pos = -(pos + 1);
        int oldNEntriesP = destP.nEntries;
        this.nEntries = (short)nEntriesToKeep;
        destP.nEntries = (short)(nEntriesToCopy + destP.nEntries);
        if (isNew || !isPrev) {
            if (destP.keys[0] > key) {
                this.putUnchecked(pos, key, value, ind);
            } else {
                destP.putUnchecked(pos - nEntriesToKeep, key, value, ind);
            }
        } else if (this.keys[0] > key) {
            destP.putUnchecked(pos + oldNEntriesP, key, value, ind);
        } else {
            this.putUnchecked(pos - nEntriesToCopy, key, value, ind);
        }
        if (isNew) {
            value.setValue(destP);
            return value;
        }
        if (isPrev) {
            parent.updateKey(this.getMinKey(), posPageInParent - 1);
        } else {
            parent.updateKey(destP.getMinKey(), posPageInParent - 1 + 1);
        }
        return value;
    }

    private void updateKey(long key, int keyPos) {
        if (keyPos < 0 || this.keys[keyPos] == key) {
            return;
        }
        this.keys[keyPos] = key;
    }

    private void addSubPage(BSTreePage newP, long minKey, int keyPos, Node ind) {
        if (this.isLeaf) {
            throw new IllegalStateException("Tree inconsistency");
        }
        if (this.nEntries < this.maxInnerN()) {
            if (keyPos == -1000) {
                keyPos = this.binarySearchInnerNode(minKey);
            }
            if (keyPos > 0) {
                System.arraycopy(this.keys, keyPos, this.keys, keyPos + 1, this.nEntries - keyPos);
                System.arraycopy(this.subPages, keyPos + 1, this.subPages, keyPos + 2, this.nEntries - keyPos);
                this.keys[keyPos] = minKey;
                this.subPages[keyPos + 1] = newP;
                newP.setParent(this);
                ++this.nEntries;
            } else {
                int ii;
                if (this.nEntries < 0) {
                    ii = 0;
                } else {
                    System.arraycopy(this.keys, 0, this.keys, 1, this.nEntries);
                    long oldKey = this.subPages[0].getMinKey();
                    if (minKey > oldKey) {
                        ii = 1;
                        this.keys[0] = minKey;
                    } else {
                        ii = 0;
                        this.keys[0] = oldKey;
                    }
                    System.arraycopy(this.subPages, ii, this.subPages, ii + 1, this.nEntries - ii + 1);
                }
                this.subPages[ii] = newP;
                newP.setParent(this);
                ++this.nEntries;
            }
        } else {
            BSTreePage newInner = ind.bstCreatePage(this.parent, false, null, this.tree);
            int minInnerN = this.minInnerN(this.keys.length);
            System.arraycopy(this.keys, minInnerN + 1, newInner.keys, 0, this.nEntries - minInnerN - 1);
            System.arraycopy(this.subPages, minInnerN + 1, newInner.subPages, 0, this.nEntries - minInnerN);
            newInner.nEntries = (short)(this.nEntries - minInnerN - 1);
            newInner.assignThisAsParentToLeaves();
            if (this.parent == null) {
                BSTreePage newRoot = ind.bstCreatePage(null, false, null, this.tree);
                newRoot.subPages[0] = this;
                newRoot.nEntries = 0;
                this.setParent(newRoot);
                ind.bstUpdateRoot(newRoot);
            }
            this.parent.addSubPage(newInner, this.keys[minInnerN], -1000, ind);
            this.nEntries = (short)minInnerN;
            long newInnerMinKey = newInner.getMinKey();
            BSTreePage newHome = minKey < newInnerMinKey ? this : newInner;
            newHome.addSubPage(newP, minKey, -1000, ind);
        }
    }

    private long getMinKey() {
        if (this.isLeaf) {
            return this.keys[0];
        }
        return this.getPageByPos(0).getMinKey();
    }

    public void print(String indent) {
        if (this.isLeaf) {
            System.out.println(indent + "Leaf page: nK=" + this.nEntries + " keys=" + Arrays.toString(this.keys));
            System.out.println(indent + "                         " + Arrays.toString(this.values));
        } else {
            System.out.println(indent + "Inner page: nK=" + this.nEntries + " keys=" + Arrays.toString(this.keys));
            System.out.print(indent + "[");
            for (int i = 0; i <= this.nEntries; ++i) {
                if (this.subPages[i] == null) continue;
                System.out.print(indent + "i=" + i + ": ");
                this.subPages[i].print(indent + "  ");
            }
            System.out.println(']');
        }
    }

    public void toStringTree(StringBuilderLn sb, String indent) {
        if (this.isLeaf) {
            sb.appendLn(indent + "Leaf page: nK=" + this.nEntries + " keys=" + Arrays.toString(this.keys));
            sb.appendLn(indent + "                         " + Arrays.toString(this.values));
        } else {
            sb.appendLn(indent + "Inner page: nK=" + this.nEntries + " keys=" + Arrays.toString(this.keys));
            sb.append(indent + "[");
            for (int i = 0; i <= this.nEntries; ++i) {
                if (this.subPages[i] == null) continue;
                sb.append(indent + "i=" + i + ": ");
                this.subPages[i].toStringTree(sb, indent + "  ");
            }
            sb.appendLn("]");
        }
    }

    public void printLocal() {
        System.out.println("PrintLocal() for " + this);
        if (this.isLeaf) {
            System.out.println("Leaf page: nK=" + this.nEntries + " oids=" + Arrays.toString(this.keys));
            System.out.println("                         " + Arrays.toString(this.values));
        } else {
            System.out.println("Inner page: nK=" + this.nEntries + " oids=" + Arrays.toString(this.keys));
            System.out.println("                      " + Arrays.toString(this.subPages));
        }
    }

    public int getNKeys() {
        return this.nEntries;
    }

    public Node.BSTEntry remove(long key, long[] kdKey, Node node, PhTree16.UpdateInfo ui) {
        int i = this.binarySearch(key);
        if (i < 0) {
            return null;
        }
        Node.BSTEntry prevValue = this.values[i];
        Node.REMOVE_OP op = node.bstInternalRemoveCallback(prevValue, kdKey, ui);
        switch (op) {
            case REMOVE_RETURN: {
                System.arraycopy(this.keys, i + 1, this.keys, i, this.nEntries - i - 1);
                System.arraycopy(this.values, i + 1, this.values, i, this.nEntries - i - 1);
                --this.nEntries;
                node.decEntryCount();
                return prevValue;
            }
            case KEEP_RETURN: {
                return prevValue;
            }
            case KEEP_RETURN_NULL: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    public <T> Object computeLeaf(long key, long[] kdKey, int posInParent, Node node, boolean doIfAbsent, BiFunction<long[], ? super T, ? extends T> mappingFunction) {
        Node subNode;
        int pos = this.binarySearch(key);
        if (pos < 0) {
            T newValue;
            if (doIfAbsent && (newValue = mappingFunction.apply(kdKey, null)) != null) {
                Node.BSTEntry e = this.addForCompute(key, pos, posInParent, node);
                e.set(key, kdKey, newValue);
                return newValue;
            }
            return null;
        }
        Node.BSTEntry currentEntry = this.values[pos];
        Object currentValue = currentEntry.getValue();
        if (currentValue instanceof Node && ((Node)currentValue).getInfixLen() == 0) {
            return currentValue;
        }
        long[] localKdKey = currentEntry.getKdKey();
        int maxConflictingBits = Node.calcConflictingBits(kdKey, localKdKey);
        if (maxConflictingBits == 0) {
            if (currentValue instanceof Node) {
                return currentValue;
            }
            T newValue = mappingFunction.apply(kdKey, (long[])PhTreeHelper.unmaskNull(currentEntry.getValue()));
            if (newValue == null) {
                this.removeForCompute(key, pos, posInParent, node);
                this.tree.bstPool().offerEntry(currentEntry);
                return null;
            }
            currentEntry.setValue(newValue);
            return newValue;
        }
        if (currentValue instanceof Node && (subNode = (Node)currentValue).getPostLen() + 1 >= maxConflictingBits) {
            return subNode;
        }
        if (doIfAbsent) {
            T newValue = mappingFunction.apply(kdKey, null);
            if (newValue != null) {
                this.insertSplit(currentEntry, kdKey, newValue, this.tree, maxConflictingBits, node);
                return newValue;
            }
            return null;
        }
        return null;
    }

    private Node.BSTEntry addForCompute(long key, int pos, int posPageInParent, Node node) {
        Node.BSTEntry o = this.create(key, pos, this.parent, posPageInParent, node);
        Node.incEntryCountTree(this.tree);
        if (o.getKdKey() == null && o.getValue() instanceof BSTreePage) {
            BSTreePage newPage = (BSTreePage)o.getValue();
            if (this.parent != null) {
                this.parent.addSubPage(newPage, newPage.getMinKey(), posPageInParent, node);
            } else {
                node.bstSetRoot(BSTreePage.create(node, null, this, newPage, this.tree));
            }
            o.setValue(null);
            return o;
        }
        return o;
    }

    private void removeForCompute(long key, int pos, int posPageInParent, Node node) {
        int i = pos;
        System.arraycopy(this.keys, i + 1, this.keys, i, this.nEntries - i - 1);
        System.arraycopy(this.values, i + 1, this.values, i, this.nEntries - i - 1);
        --this.nEntries;
        node.decEntryCountGlobal(this.tree);
        if (this.parent == null) {
            return;
        }
        BSTreePage parentPage = this.parent;
        parentPage.checkUnderflowSubpageLeaf(posPageInParent, node);
        parentPage = parentPage.parent;
        while (parentPage != null) {
            pos = parentPage.binarySearchInnerNode(key);
            parentPage.handleUnderflowSubInner(pos);
            parentPage = parentPage.parent;
        }
    }

    private void insertSplit(Node.BSTEntry currentEntry, long[] newKey, Object newValue, PhTree16<?> tree, int maxConflictingBits, Node node) {
        long[] localKdKey = currentEntry.getKdKey();
        Node newNode = node.createNode(newKey, newValue, localKdKey, currentEntry.getValue(), maxConflictingBits, tree);
        currentEntry.set(currentEntry.getKey(), tree.longPool().arrayClone(localKdKey), newNode);
        Node.incEntryCountTree(tree);
    }

    private void checkUnderflowSubpageLeaf(int pos, Node ind) {
        BSTreePage prevPage;
        BSTreePage subPage = this.getPageByPos(pos);
        if (subPage.nEntries == 0) {
            --Node.statNLeaves;
            this.removePage(pos);
        } else if (subPage.nEntries < this.minLeafN(ind.maxLeafN()) && subPage.nEntries % 8 == 0 && (prevPage = this.getPrevLeafPage(pos)) != null && subPage.nEntries + prevPage.nEntries < ind.maxLeafN()) {
            System.arraycopy(subPage.keys, 0, prevPage.keys, prevPage.nEntries, subPage.nEntries);
            System.arraycopy(subPage.values, 0, prevPage.values, prevPage.nEntries, subPage.nEntries);
            prevPage.nEntries += subPage.nEntries;
            --Node.statNLeaves;
            this.removePage(pos);
        }
    }

    private void removePage(int posToRemove) {
        BSTreePage indexPage = this.getPageByPos(posToRemove);
        this.tree.bstPool().reportFreeNode(indexPage);
        if (this.nEntries > 0) {
            this.arraysRemoveInnerEntry(posToRemove);
            --this.nEntries;
        }
    }

    private void handleUnderflowSubInner(int pos) {
        BSTreePage sub = this.getPageByPos(pos);
        if (sub.nEntries < this.maxInnerN() >> 1) {
            if (sub.nEntries >= 0) {
                BSTreePage prev = this.getPrevInnerPage(pos);
                if (prev != null && !prev.isLeaf) {
                    if (sub.nEntries % 2 == 0 && prev.nEntries + sub.nEntries < this.maxInnerN()) {
                        System.arraycopy(sub.keys, 0, prev.keys, prev.nEntries + 1, sub.nEntries);
                        System.arraycopy(sub.subPages, 0, prev.subPages, prev.nEntries + 1, sub.nEntries + 1);
                        prev.keys[prev.nEntries] = this.keys[pos - 1];
                        prev.nEntries += sub.nEntries + 1;
                        prev.assignThisAsParentToLeaves();
                        this.removePage(pos);
                    }
                    return;
                }
                if (sub.nEntries == 0) {
                    BSTreePage child = sub.getPageByPos(0);
                    this.replaceChildPage(child, pos);
                    --Node.statNInner;
                    this.tree.bstPool().reportFreeNode(sub);
                }
            } else {
                if (sub.parent != null) {
                    --Node.statNInner;
                    return;
                }
                sub.subPages[0] = null;
                --sub.nEntries;
            }
        }
    }

    private void arraysRemoveKey(int pos) {
        System.arraycopy(this.keys, pos + 1, this.keys, pos, this.nEntries - pos - 1);
    }

    private void arraysRemoveChild(int pos) {
        System.arraycopy(this.subPages, pos + 1, this.subPages, pos, this.nEntries - pos);
        this.subPages[this.nEntries] = null;
    }

    private void arraysRemoveInnerEntry(int posEntry) {
        if (posEntry > 0) {
            this.arraysRemoveKey(posEntry - 1);
        } else {
            this.arraysRemoveKey(0);
        }
        this.arraysRemoveChild(posEntry);
    }

    private void replaceChildPage(BSTreePage subChild, int pos) {
        this.subPages[pos] = subChild;
        if (pos > 0) {
            this.keys[pos - 1] = subChild.getMinKey();
        }
        subChild.setParent(this);
    }

    public void setParent(BSTreePage parent) {
        this.parent = parent;
    }

    final long[] getKeys() {
        return this.keys;
    }

    final Node.BSTEntry[] getValues() {
        return this.values;
    }

    private void setNEntries(int n) {
        this.nEntries = (short)n;
    }

    private BSTreePage getPrevInnerPage(int currentSubPos) {
        if (currentSubPos > 0) {
            BSTreePage page = this.getPageByPos(currentSubPos - 1);
            if (page.isLeaf) {
                return null;
            }
            return page;
        }
        return null;
    }

    private BSTreePage getPrevLeafPage(int currentSubPos) {
        if (currentSubPos > 0) {
            BSTreePage page = this.getPageByPos(currentSubPos - 1);
            return page.getLastLeafPage();
        }
        return null;
    }

    private BSTreePage getNextLeafPage(int currentSubPos) {
        if (currentSubPos < this.getNKeys()) {
            return this.getPageByPos(currentSubPos + 1).getFirstLeafPage();
        }
        return null;
    }

    private BSTreePage getFirstLeafPage() {
        if (this.isLeaf) {
            return this;
        }
        return this.getPageByPos(0).getFirstLeafPage();
    }

    private BSTreePage getLastLeafPage() {
        if (this.isLeaf) {
            return this;
        }
        return this.getPageByPos(this.getNKeys()).getLastLeafPage();
    }

    BSTreePage getPageByPos(int pos) {
        return this.subPages[pos];
    }

    private void assignThisAsParentToLeaves() {
        for (int i = 0; i <= this.getNKeys(); ++i) {
            if (this.subPages[i] == null) continue;
            this.subPages[i].setParent(this);
        }
    }

    public final void clear() {
        int i;
        if (!this.isLeaf) {
            for (i = 0; i < this.getNKeys() + 1; ++i) {
                BSTreePage p = this.getPageByPos(i);
                p.clear();
                this.tree.bstPool().reportFreeNode(p);
            }
        }
        if (this.subPages != null) {
            for (i = 0; i < this.subPages.length; ++i) {
                this.subPages[i] = null;
            }
        }
        this.setNEntries(-1);
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void getStats(Node.BSTStats stats) {
        if (this.isLeaf()) {
            ++stats.nNodesLeaf;
            stats.nEntriesLeaf += this.nEntries;
            stats.capacityLeaf += this.keys.length;
            if (this.nEntries < 1 && this.parent != null && this.parent.parent != null) {
                throw new IllegalStateException();
            }
        } else {
            ++stats.nNodesInner;
            stats.nEntriesInner += this.nEntries + 1;
            stats.capacityInner += this.keys.length + 1;
            if (this.nEntries < 1 && this.parent != null) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < this.getNKeys() + 1; ++i) {
                this.getPageByPos(i).getStats(stats);
            }
        }
    }

    public Node.BSTEntry getFirstValue() {
        return this.values[0];
    }

    public BSTreePage getFirstSubPage() {
        return this.subPages[0];
    }

    public BSTreePage[] getSubPages() {
        return this.subPages;
    }

    void nullify() {
        this.keys = null;
        this.values = null;
        this.subPages = null;
        this.nextLeaf = null;
        this.prevLeaf = null;
        this.parent = null;
        this.nEntries = 0;
    }

    BSTreePage getNextLeaf() {
        return this.nextLeaf;
    }

    void updateNeighborsRemove() {
        if (this.prevLeaf != null) {
            this.prevLeaf.nextLeaf = this.nextLeaf;
        }
        if (this.nextLeaf != null) {
            this.nextLeaf.prevLeaf = this.prevLeaf;
        }
    }
}

