/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v13SynchedPool;

import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.v13SynchedPool.Node;

public class NodePool {
    private static final Node[] POOL = new Node[PhTreeHelper.MAX_OBJECT_POOL_SIZE];
    private static int poolSize;
    private static int activeNodes;

    private NodePool() {
    }

    static synchronized Node getNode() {
        ++activeNodes;
        if (poolSize == 0) {
            return Node.createEmpty();
        }
        return POOL[--poolSize];
    }

    static synchronized void offer(Node node) {
        --activeNodes;
        if (poolSize < POOL.length) {
            NodePool.POOL[NodePool.poolSize++] = node;
        }
    }

    public static int getActiveNodes() {
        return activeNodes;
    }

    static {
        activeNodes = 0;
    }
}

