/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.conv.ATDRadarConvention;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.util.CancelTask;

public class ZebraConvention
extends ATDRadarConvention {
    public static boolean isMine(NetcdfFile ncfile) {
        String s2 = ncfile.findAttValueIgnoreCase(null, "Convention", "none");
        return s2.startsWith("Zebra");
    }

    public ZebraConvention() {
        this.conventionName = "Zebra";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        Array data;
        NcMLReader.wrapNcMLresource(ds, "resources/nj22/coords/Zebra.ncml", cancelTask);
        Dimension timeDim = ds.findDimension("time");
        Variable base_time = ds.findVariable("base_time");
        Variable time_offset = ds.findVariable("time_offset");
        Variable time = ds.findVariable("time");
        if (timeDim == null || base_time == null || time_offset == null || time == null) {
            return;
        }
        Attribute att = base_time.findAttribute("units");
        String units = att != null ? att.getStringValue() : "seconds since 1970-01-01 00:00 UTC";
        time.addAttribute(new Attribute("units", units));
        try {
            double baseValue = base_time.readScalarDouble();
            data = time_offset.read();
            IndexIterator iter = data.getIndexIterator();
            while (iter.hasNext()) {
                iter.setDoubleCurrent(iter.getDoubleNext() + baseValue);
            }
        }
        catch (IOException ioe) {
            this.parseInfo.format("ZebraConvention failed to create time Coord Axis for file %s err= %s%n", ds.getLocation(), ioe);
            return;
        }
        time.setCachedData(data, true);
    }
}

