/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import org.apache.commons.io.FilenameUtils;

public class Filez {
    public static boolean isFilenameValid(String file) {
        File f = new File(file);
        try {
            f.getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static File makeUnique(File name) {
        int i = 1;
        while (name.exists()) {
            name = new File(name.getParentFile(), Filez.stripExtn(name.getName()) + "_" + i++ + "." + Filez.getExtn(name.getName()));
        }
        return name;
    }

    public static void copyfile(String srFile, String dtFile) {
        try {
            int len;
            File f1 = new File(srFile);
            File f2 = new File(dtFile);
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            System.out.println("File copied.");
        }
        catch (FileNotFoundException ex) {
            System.out.println(ex.getMessage() + " in the specified directory.");
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static String stripExtn(String name) {
        return name.substring(0, name.lastIndexOf(46));
    }

    public static String getExtn(String filename) {
        int i = filename.lastIndexOf(46);
        if (i >= 0) {
            return filename.substring(i + 1, filename.length());
        }
        return "";
    }

    public static String extTo(String filename, String png) {
        return Filez.stripExtn(filename) + png;
    }

    public static File extTo(File wf, String png) {
        return new File(Filez.stripExtn(wf.getPath()) + png);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unpackArchive(URL url, File targetDir, ProgressMonitor pm) throws IOException {
        try {
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            pm.setMaximum(100);
            BufferedInputStream in = new BufferedInputStream(url.openStream(), 1024);
            File zip = new File(targetDir, FilenameUtils.getName((String)url.getPath()));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zip));
            pm.setNote("downloading " + String.valueOf(url));
            Filez.copyInputStream(in, out, pm);
            ((OutputStream)out).close();
            File file = Filez.unpackArchive(zip, targetDir, pm);
            return file;
        }
        finally {
            pm.close();
        }
    }

    public static File unpackArchive(File theFile, File targetDir, ProgressMonitor pm) throws IOException {
        if (!theFile.exists()) {
            throw new IOException(theFile.getAbsolutePath() + " does not exist");
        }
        if (!Filez.buildDirectory(targetDir)) {
            throw new IOException("Could not create directory: " + String.valueOf(targetDir));
        }
        ZipFile zipFile = new ZipFile(theFile);
        pm.setMaximum(zipFile.size());
        int c = 0;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File file = new File(targetDir, File.separator + entry.getName());
            pm.setProgress(c++);
            pm.setNote("extracting " + file.getName());
            if (!Filez.buildDirectory(file.getParentFile())) {
                zipFile.close();
                pm.close();
                JOptionPane.showMessageDialog(null, "failed to created " + String.valueOf(file.getParentFile()));
                throw new IOException("Could not create directory: " + String.valueOf(file.getParentFile()));
            }
            if (!entry.isDirectory()) {
                Filez.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(file)), pm);
                continue;
            }
            if (Filez.buildDirectory(file)) continue;
            zipFile.close();
            JOptionPane.showMessageDialog(null, "failed to create " + String.valueOf(file));
            pm.close();
            throw new IOException("Could not create directory: " + String.valueOf(file));
        }
        zipFile.close();
        return theFile;
    }

    public static void copyInputStream(InputStream in, OutputStream out, ProgressMonitor pm) throws IOException {
        byte[] buffer = new byte[1024];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
            pm.setProgress((int)(Math.random() * 100.0));
        }
        in.close();
        out.close();
    }

    public static boolean buildDirectory(File file) {
        return file.exists() || file.mkdirs();
    }
}

