/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Tuple3d;
import org.twak.camp.Corner;
import org.twak.camp.CornerClone;
import org.twak.camp.Edge;
import org.twak.camp.HeightEvent;
import org.twak.camp.Machine;
import org.twak.camp.Output;
import org.twak.camp.Skeleton;
import org.twak.camp.ui.DirectionHeightEvent;
import org.twak.utils.collections.DHash;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.ManyManyMap;
import org.twak.utils.collections.SetCorrespondence;

public class OffsetSkeleton<E extends Machine> {
    private List<Offset> output;
    public Map<E, OffsetMachine> profileOffset = new LinkedHashMap<E, OffsetMachine>();
    public Map<OffsetMachine, E> offsetProfile = new LinkedHashMap<OffsetMachine, E>();
    public double interval;
    LoopL<Corner> corners;
    int machinesCount = 0;
    int machinesOutstanding = 0;
    int lastStep = -1;
    SetCorrespondence<Corner, Corner> oldInputSegments;
    public Skeleton outputSkeleton;

    public OffsetSkeleton(LoopL<Corner> corners, double interval) {
        this.interval = interval;
        CornerClone cc = new CornerClone(corners);
        this.corners = cc.output;
        this.oldInputSegments = cc.nOSegments;
    }

    public void registerProfile(E profile, double angle, int step) {
        assert (profile != null);
        double height = (double)step * this.interval;
        OffsetMachine om = this.profileOffset.get(profile);
        if (om == null) {
            om = new OffsetMachine();
            this.profileOffset.put(profile, om);
            this.offsetProfile.put(om, profile);
            ++this.machinesCount;
        }
        om.addHeightEvent(new DirectionHeightEvent(om, height, angle));
        if (step > this.lastStep) {
            this.lastStep = step;
        }
    }

    public List<Offset> getResults() {
        this.output = new ArrayList<Offset>();
        HashMap<Machine, Machine> unspecifiedNewMachineOld = new HashMap<Machine, Machine>();
        for (Corner c : this.corners.eIterator()) {
            Edge e = c.nextL;
            Machine m3 = this.profileOffset.get(e.machine);
            if (m3 == null) {
                m3 = new Machine(0.0);
                unspecifiedNewMachineOld.put(m3, e.machine);
                e.machine = m3;
                continue;
            }
            e.machine = m3;
        }
        this.outputSkeleton = new Skeleton(this.corners, (double)(this.lastStep + 1) * this.interval, true);
        this.outputSkeleton.name = "offset";
        InstanceHeightEvent last = null;
        for (int i = 0; i <= this.lastStep; ++i) {
            last = new InstanceHeightEvent(i);
            this.outputSkeleton.qu.add(last);
        }
        if (last != null) {
            last.endHere = true;
        }
        this.outputSkeleton.skeleton();
        for (Offset offset : this.output) {
            for (Edge e : Edge.uniqueEdges(offset.shape)) {
                assert (e.machine != null);
                Machine origMachine = (Machine)this.offsetProfile.get(e.machine);
                e.machine = origMachine != null ? origMachine : (Machine)unspecifiedNewMachineOld.get(e.machine);
                e.machine.addEdge(e, this.outputSkeleton);
            }
        }
        return this.output;
    }

    public List<Corner> getInputEdge(Output.Face f) {
        Edge first = this.outputSkeleton.output.getGreatestGrandParent((Output.Face)f).edge;
        return new ArrayList<Corner>(this.oldInputSegments.getSetA(first.start));
    }

    public static LoopL<Corner> shrink(LoopL<Edge> in, double dist) {
        LoopL<Corner> cLoopL = Corner.cornerToEdgeLoopL(in);
        OffsetSkeleton<Machine> os = new OffsetSkeleton<Machine>(cLoopL, 100.0);
        HashSet<Machine> allMachines = new HashSet<Machine>();
        for (Edge e : in.eIterator()) {
            allMachines.add(e.machine);
        }
        for (Machine m3 : allMachines) {
            os.registerProfile(m3, Math.atan(dist / 100.0), 0);
        }
        List<Offset> res = os.getResults();
        if (res.isEmpty()) {
            return new LoopL<Corner>();
        }
        return res.get((int)0).shape;
    }

    public static abstract class FindNOCorner {
        public SetCorrespondence<Corner, Corner> nOSegmentsUpdate;
        public DHash<Corner, Corner> nOCorner = new DHash();

        public FindNOCorner(Offset offset, LoopL<Corner> cap) {
            this.nOSegmentsUpdate = offset.nOSegments.toSetCorrespondence();
            for (Corner oldC : cap.eIterator()) {
                if (!this.didThisOldCornerRemainUnchanged(oldC)) continue;
                Set<Corner> second = this.nOSegmentsUpdate.getSetB(oldC);
                Set<Corner> first = this.nOSegmentsUpdate.getSetB(oldC.prevC);
                Corner neuC = this.findAdjacent(first, second);
                if (neuC == null) continue;
                this.nOCorner.put(neuC, oldC);
            }
        }

        private Corner findAdjacent(Set<Corner> first, Set<Corner> second) {
            for (Corner c : first) {
                if (!second.contains(c.nextC)) continue;
                return c.nextC;
            }
            return null;
        }

        public abstract boolean didThisOldCornerRemainUnchanged(Corner var1);
    }

    public class OffsetMachine
    extends Machine {
        public OffsetMachine() {
            this.events.clear();
        }
    }

    public static class Offset {
        public LoopL<Corner> shape;
        public ManyManyMap<Corner, Corner> nOSegments;

        public Offset(LoopL<Corner> shape, ManyManyMap<Corner, Corner> nOSegments) {
            this.shape = shape;
            this.nOSegments = nOSegments;
        }
    }

    public class InstanceHeightEvent
    implements HeightEvent {
        int step;
        double height;
        boolean endHere = false;

        public InstanceHeightEvent(int step) {
            this.step = step;
            this.height = Math.nextAfter((double)(step + 1) * OffsetSkeleton.this.interval, -1.0);
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean process(Skeleton skel) {
            ManyManyMap outputOldSegments;
            LoopL<Corner> copy = skel.capCopy(this.height);
            ManyManyMap<Corner, Corner> manyManyMap = skel.segmentMap;
            Objects.requireNonNull(manyManyMap);
            ManyManyMap manyManyMap2 = outputOldSegments = new ManyManyMap.ConvertInputCollection<Corner>(manyManyMap, skel.getSegmentOriginator()).get();
            Objects.requireNonNull(manyManyMap2);
            ManyManyMap<Corner, Corner> inputCapSegments = new ManyManyMap.ConvertInputCollection<Corner>(manyManyMap2, OffsetSkeleton.this.oldInputSegments.asCache()).get();
            inputCapSegments = inputCapSegments.getFlipShallow();
            OffsetSkeleton.this.output.add(new Offset(copy, inputCapSegments));
            if (this.endHere) {
                for (Corner c : skel.liveCorners) {
                    Corner top = skel.cornerMap.teg(c);
                    skel.output.addOutputSideTo(c, (Tuple3d)top, c.nextL, c.prevL);
                    skel.output.addOutputSideTo(true, (Tuple3d)top, top.nextC, c.nextL);
                }
                skel.liveEdges.clear();
                skel.liveCorners.clear();
                skel.qu.clearFaceEvents();
            }
            return false;
        }
    }
}

