/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index.qtplain;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import org.tinspin.index.BoxDistance;
import org.tinspin.index.BoxMap;
import org.tinspin.index.BoxMultimap;
import org.tinspin.index.Index;
import org.tinspin.index.qtplain.QRIteratorKnn;
import org.tinspin.index.qtplain.QRNode;
import org.tinspin.index.qtplain.QUtil;
import org.tinspin.index.qtplain.QuadTreeKD0;
import org.tinspin.index.util.BoxIteratorWrapper;
import org.tinspin.index.util.StringBuilderLn;

public class QuadTreeRKD0<T>
implements BoxMap<T>,
BoxMultimap<T> {
    private static final int MAX_DEPTH = 50;
    public static final boolean DEBUG = false;
    private static final int DEFAULT_MAX_NODE_SIZE = 10;
    private final int dims;
    private final int maxNodeSize;
    private QRNode<T> root = null;
    private int size = 0;

    private QuadTreeRKD0(int dims, int maxNodeSize) {
        this.dims = dims;
        this.maxNodeSize = maxNodeSize;
    }

    public static <T> QuadTreeRKD0<T> create(int dims) {
        return new QuadTreeRKD0<T>(dims, 10);
    }

    @Deprecated
    public static <T> QuadTreeRKD0<T> create(int dims, int maxNodeSize) {
        return new QuadTreeRKD0<T>(dims, maxNodeSize);
    }

    public static <T> QuadTreeRKD0<T> create(int dims, int maxNodeSize, double[] min2, double[] max) {
        double radius = 0.0;
        double[] center = new double[dims];
        for (int i = 0; i < dims; ++i) {
            center[i] = (max[i] + min2[i]) / 2.0;
            if (!(max[i] - min2[i] > radius)) continue;
            radius = max[i] - min2[i];
        }
        return QuadTreeRKD0.create(dims, maxNodeSize, center, radius);
    }

    public static <T> QuadTreeRKD0<T> create(int dims, int maxNodeSize, double[] center, double radius) {
        QuadTreeRKD0<T> t = new QuadTreeRKD0<T>(dims, maxNodeSize);
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be > 0 but was " + radius);
        }
        t.root = new QRNode(Arrays.copyOf(center, center.length), radius);
        return t;
    }

    @Override
    public void insert(double[] keyL, double[] keyU, T value) {
        ++this.size;
        Index.BoxEntry<T> e = new Index.BoxEntry<T>(keyL, keyU, value);
        if (this.root == null) {
            this.initializeRoot(keyL, keyU);
        }
        this.ensureCoverage(e);
        int depth = 0;
        for (QRNode<T> r = this.root; r != null; r = r.tryPut(e, this.maxNodeSize, depth++ > 50)) {
        }
    }

    private void initializeRoot(double[] keyL, double[] keyU) {
        double[] center = new double[this.dims];
        double radius = 0.0;
        for (int d = 0; d < this.dims; ++d) {
            center[d] = (keyU[d] + keyL[d]) / 2.0;
            if (!(keyU[d] - keyL[d] > radius)) continue;
            radius = keyU[d] - keyL[d];
        }
        radius = (radius *= 5.0) == 0.0 ? 1.0 : radius;
        this.root = new QRNode(center, radius);
    }

    public boolean containsExact(double[] keyL, double[] keyU) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(keyL, keyU, e -> true) != null;
    }

    @Override
    public T queryExact(double[] min2, double[] max) {
        if (this.root == null) {
            return null;
        }
        Index.BoxEntry<T> e = this.root.getExact(min2, max, x -> true);
        return e == null ? null : (T)e.value();
    }

    @Override
    public boolean contains(double[] min2, double[] max) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(min2, max, x -> true) != null;
    }

    @Override
    public boolean contains(double[] lower, double[] upper, T value) {
        if (this.root == null) {
            return false;
        }
        return this.root.getExact(lower, upper, x -> Objects.equals(value, x.value())) != null;
    }

    @Override
    public Index.BoxIterator<T> queryExactBox(double[] lower, double[] upper) {
        if (this.root == null) {
            return null;
        }
        return new BoxIteratorWrapper(lower, upper, (low, upp2) -> {
            ArrayList results = new ArrayList();
            if (this.root != null) {
                this.root.getExact(lower, upper, x -> !results.add(x));
            }
            return results.iterator();
        });
    }

    @Override
    public T remove(double[] keyL, double[] keyU) {
        if (this.root == null) {
            return null;
        }
        Index.BoxEntry<T> e = this.root.remove(null, keyL, keyU, this.maxNodeSize, x -> true);
        if (e == null) {
            return null;
        }
        --this.size;
        return e.value();
    }

    @Override
    public boolean remove(double[] lower, double[] upper, T value) {
        return this.removeIf(lower, upper, e -> Objects.equals(e.value(), value));
    }

    @Override
    public boolean removeIf(double[] lower, double[] upper, Predicate<Index.BoxEntry<T>> condition) {
        if (this.root == null) {
            return false;
        }
        Index.BoxEntry<T> e = this.root.remove(null, lower, upper, this.maxNodeSize, condition);
        if (e == null) {
            return false;
        }
        --this.size;
        return true;
    }

    @Override
    public boolean update(double[] oldKeyL, double[] oldKeyU, double[] newKeyL, double[] newKeyU, T value) {
        if (this.root == null) {
            return false;
        }
        boolean[] requiresReinsert = new boolean[]{false};
        Index.BoxEntry<Object> e = this.root.update(null, oldKeyL, oldKeyU, newKeyL, newKeyU, this.maxNodeSize, requiresReinsert, 0, 50, t -> Objects.equals(value, t));
        if (e == null) {
            return false;
        }
        if (requiresReinsert[0]) {
            this.ensureCoverage(e);
            int depth = 0;
            for (QRNode<Object> r = this.root; r != null; r = r.tryPut(e, this.maxNodeSize, depth++ > 50)) {
            }
        }
        return true;
    }

    @Override
    public T update(double[] oldKeyL, double[] oldKeyU, double[] newKeyL, double[] newKeyU) {
        if (this.root == null) {
            return null;
        }
        boolean[] requiresReinsert = new boolean[]{false};
        Index.BoxEntry<Object> e = this.root.update(null, oldKeyL, oldKeyU, newKeyL, newKeyU, this.maxNodeSize, requiresReinsert, 0, 50, t -> true);
        if (e == null) {
            return null;
        }
        if (requiresReinsert[0]) {
            this.ensureCoverage(e);
            int depth = 0;
            for (QRNode<Object> r = this.root; r != null; r = r.tryPut(e, this.maxNodeSize, depth++ > 50)) {
            }
        }
        return (T)e.value();
    }

    private void ensureCoverage(Index.BoxEntry<T> e) {
        double[] pLow = e.min();
        while (!QUtil.fitsIntoNode(e.min(), e.max(), this.root.getCenter(), this.root.getRadius())) {
            double[] center = this.root.getCenter();
            double radius = this.root.getRadius();
            double[] center2 = new double[center.length];
            double radius2 = radius * 2.0;
            for (int d = 0; d < center.length; ++d) {
                center2[d] = pLow[d] < center[d] - radius ? center[d] - radius : center[d] + radius;
            }
            this.root = new QRNode<T>(center2, radius2, this.root);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
    }

    @Override
    public QRIterator<T> queryIntersect(double[] min2, double[] max) {
        return new QRIterator(this, min2, max);
    }

    @Override
    public Index.BoxEntryKnn<T> query1nn(double[] center) {
        return ((QRIteratorKnn)this.queryKnn(center, 1)).next();
    }

    @Override
    public String toStringTree() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.root == null) {
            sb.append("empty tree");
        } else {
            this.toStringTree(sb, this.root, 0, 0);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilderLn sb, QRNode<T> node, int depth, int posInParent) {
        Iterator<?> it = node.getChildIterator();
        Object prefix = ".".repeat(depth);
        sb.append((String)prefix + posInParent + " d=" + depth);
        sb.append(" " + Arrays.toString(node.getCenter()));
        sb.appendLn("/" + node.getRadius());
        prefix = (String)prefix + " ";
        int pos = 0;
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof QRNode) {
                QRNode sub = (QRNode)o;
                this.toStringTree(sb, sub, depth + 1, pos);
            } else {
                Index.BoxEntry e = (Index.BoxEntry)o;
                sb.append((String)prefix + Arrays.toString(e.min()) + Arrays.toString(e.max()));
                sb.appendLn(" v=" + e.value());
            }
            ++pos;
        }
    }

    public String toString() {
        return "QuadTreeRKD0;maxNodeSize=" + this.maxNodeSize + ";maxDepth=50;DEBUG=false;center/radius=" + (String)(this.root == null ? "null" : Arrays.toString(this.root.getCenter()) + "/" + this.root.getRadius());
    }

    @Override
    public QuadTreeKD0.QStats getStats() {
        QuadTreeKD0.QStats s2 = new QuadTreeKD0.QStats();
        if (this.root != null) {
            this.root.checkNode(s2, null, 0);
        }
        return s2;
    }

    @Override
    public int getDims() {
        return this.dims;
    }

    @Override
    public int getNodeCount() {
        return this.getStats().getNodeCount();
    }

    @Override
    public Index.BoxIterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QRIteratorKnn<T> queryKnn(double[] center, int k) {
        return new QRIteratorKnn<T>(this.root, k, center, BoxDistance.EDGE, (e, d) -> true);
    }

    @Override
    public Index.BoxIteratorKnn<T> queryKnn(double[] center, int k, BoxDistance distFn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDepth() {
        return this.getStats().getMaxDepth();
    }

    public static class QRIterator<T>
    implements Index.BoxIterator<T> {
        private final QuadTreeRKD0<T> tree;
        private final ArrayDeque<Iterator<?>> stack = new ArrayDeque();
        private Index.BoxEntry<T> next = null;
        private double[] min;
        private double[] max;

        QRIterator(QuadTreeRKD0<T> tree, double[] min2, double[] max) {
            this.tree = tree;
            this.reset(min2, max);
        }

        private void findNext() {
            while (!this.stack.isEmpty()) {
                Iterator<?> it = this.stack.peek();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (o instanceof QRNode) {
                        QRNode node = (QRNode)o;
                        if (!QUtil.overlap(this.min, this.max, node.getCenter(), node.getRadius())) continue;
                        it = node.getChildIterator();
                        this.stack.push(it);
                        continue;
                    }
                    Index.BoxEntry e = (Index.BoxEntry)o;
                    if (!QUtil.overlap(this.min, this.max, e.min(), e.max())) continue;
                    this.next = e;
                    return;
                }
                this.stack.pop();
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Index.BoxEntry<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Index.BoxEntry<T> ret = this.next;
            this.findNext();
            return ret;
        }

        @Override
        public Index.BoxIterator<T> reset(double[] min2, double[] max) {
            this.stack.clear();
            this.min = min2;
            this.max = max;
            this.next = null;
            if (this.tree.root != null) {
                this.stack.push(this.tree.root.getChildIterator());
                this.findNext();
            }
            return this;
        }
    }
}

