/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource$;
import org.apache.spark.sql.sedona_sql.io.geojson.GeoJSONUtils$;
import org.apache.spark.sql.sedona_sql.io.geojson.SparkCompatUtil$;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartition;
import org.apache.spark.sql.sedona_sql.io.stac.StacUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0010!\u0001=B\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003`\u0011!y\u0007A!A!\u0002\u0013\u0001\b\u0002\u0003@\u0001\u0005\u0003\u0005\u000b\u0011B@\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!I\u0011\u0011\u0005\u0001C\u0002\u0013%\u00111\u0005\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002&!Y\u00111\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001b\u0011-\t9\u0004\u0001a\u0001\u0002\u0004%I!!\u000f\t\u0015\u0005\u0015\u0003\u00011A\u0001B\u0003&A\u000eC\u0006\u0002H\u0001\u0001\r\u00111A\u0005\n\u0005%\u0003bCA+\u0001\u0001\u0007\t\u0019!C\u0005\u0003/B1\"a\u0017\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002L!I\u0011Q\f\u0001A\u0002\u0013%\u0011q\f\u0005\n\u0003c\u0002\u0001\u0019!C\u0005\u0003gB\u0001\"a\u001e\u0001A\u0003&\u0011\u0011\r\u0005\n\u0003s\u0002!\u0019!C\u0005\u0003wB\u0001\"!&\u0001A\u0003%\u0011Q\u0010\u0005\n\u0003/\u0003!\u0019!C\u0005\u00033Cq!a'\u0001A\u0003%q\fC\u0004\u0002\u001e\u0002!\t%a(\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\"9\u00111\u0016\u0001\u0005B\u00055\u0006bBAX\u0001\u0011%\u0011\u0011\u0017\u0005\b\u0003o\u0003A\u0011AA]\u0011%\t)\u000eAI\u0001\n\u0003\t9\u000eC\u0004\u0002n\u0002!\t!a<\t\u000f\u0005m\b\u0001\"\u0001\u0002~\n\u00192\u000b^1d!\u0006\u0014H/\u001b;j_:\u0014V-\u00193fe*\u0011\u0011EI\u0001\u0005gR\f7M\u0003\u0002$I\u0005\u0011\u0011n\u001c\u0006\u0003K\u0019\n!b]3e_:\fwl]9m\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0007\u000f\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA\u0001\\1oO*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005\u0019y%M[3diB\u0019\u0011H\u0010!\u000e\u0003iR!a\u000f\u001f\u0002\tI,\u0017\r\u001a\u0006\u0003{\u0019\n\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005}R$a\u0004)beRLG/[8o%\u0016\fG-\u001a:\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r3\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0005\u0015\u0013%aC%oi\u0016\u0014h.\u00197S_^\f\u0011B\u0019:pC\u0012\u001c\u0017m\u001d;\u0011\u0007!SE*D\u0001J\u0015\t1\u0005&\u0003\u0002L\u0013\nI!I]8bI\u000e\f7\u000f\u001e\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\"\nA!\u001e;jY&\u0011\u0011K\u0014\u0002\u001a'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\"p]\u001aLw-\u001e:bi&|g.A\u0005qCJ$\u0018\u000e^5p]B\u0011A+V\u0007\u0002A%\u0011a\u000b\t\u0002\u000e'R\f7\rU1si&$\u0018n\u001c8\u0002\rM\u001c\u0007.Z7b!\tIF,D\u0001[\u0015\tYf%A\u0003usB,7/\u0003\u0002^5\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\t=\u0004Ho\u001d\t\u0005A&dGN\u0004\u0002bOB\u0011!-Z\u0007\u0002G*\u0011AML\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0019\fQa]2bY\u0006L!\u0001[3\u0002\rA\u0013X\rZ3g\u0013\tQ7NA\u0002NCBT!\u0001[3\u0011\u0005\u0001l\u0017B\u00018l\u0005\u0019\u0019FO]5oO\u0006i1\u000f]1uS\u0006dg)\u001b7uKJ\u00042!\u001d:u\u001b\u0005)\u0017BA:f\u0005\u0019y\u0005\u000f^5p]B\u0011Q\u000f`\u0007\u0002m*\u0011q\u000f_\u0001\u000bO\u0016|\u0007/\u0019:rk\u0016$(BA={\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005m4\u0013!C3yK\u000e,H/[8o\u0013\tihOA\fHK>\u0004\u0016M]9vKR\u001c\u0006/\u0019;jC24\u0015\u000e\u001c;fe\u0006qA/Z7q_J\fGNR5mi\u0016\u0014\b\u0003B9s\u0003\u0003\u0001B!a\u0001\u0002\f5\u0011\u0011Q\u0001\u0006\u0004C\u0005\u001d!bAA\u0005u\u0006QA-\u0019;bg>,(oY3\n\t\u00055\u0011Q\u0001\u0002\u000f)\u0016l\u0007o\u001c:bY\u001aKG\u000e^3s\u0003\u0019a\u0014N\\5u}Qq\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0001C\u0001+\u0001\u0011\u00151u\u00011\u0001H\u0011\u0015\u0011v\u00011\u0001T\u0011\u00159v\u00011\u0001Y\u0011\u0015qv\u00011\u0001`\u0011\u0015yw\u00011\u0001q\u0011\u0015qx\u00011\u0001\u0000\u00035IG/Z7t\u0013R,'/\u0019;peV\u0011\u0011Q\u0005\t\u0006\u0003O\ti\u0003\\\u0007\u0003\u0003SQ1!a\u000bf\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\tIC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u00039IG/Z7t\u0013R,'/\u0019;pe\u0002\n1bY;se\u0016tG/\u0013;f[V\tA.A\bdkJ\u0014XM\u001c;Ji\u0016lw\fJ3r)\u0011\tY$!\u0011\u0011\u0007E\fi$C\u0002\u0002@\u0015\u0014A!\u00168ji\"A\u00111I\u0006\u0002\u0002\u0003\u0007A.A\u0002yIE\nAbY;se\u0016tG/\u0013;f[\u0002\n1bY;se\u0016tGOR5mKV\u0011\u00111\n\t\u0005\u0003\u001b\n\t&\u0004\u0002\u0002P)\u00111\u0005N\u0005\u0005\u0003'\nyE\u0001\u0003GS2,\u0017aD2veJ,g\u000e\u001e$jY\u0016|F%Z9\u0015\t\u0005m\u0012\u0011\f\u0005\n\u0003\u0007r\u0011\u0011!a\u0001\u0003\u0017\nAbY;se\u0016tGOR5mK\u0002\nqBZ3biV\u0014X-\u0013;fe\u0006$xN]\u000b\u0003\u0003C\u0002R!a\u0019\u0002n\u0001sA!!\u001a\u0002j9\u0019!-a\u001a\n\u0003\u0019L1!a\u001bf\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\f\u0002p)\u0019\u00111N3\u0002'\u0019,\u0017\r^;sK&#XM]1u_J|F%Z9\u0015\t\u0005m\u0012Q\u000f\u0005\n\u0003\u0007\n\u0012\u0011!a\u0001\u0003C\n\u0001CZ3biV\u0014X-\u0013;fe\u0006$xN\u001d\u0011\u0002\r5\f\u0007\u000f]3s+\t\ti\b\u0005\u0003\u0002\u0000\u0005EUBAAA\u0015\u0011\t\u0019)!\"\u0002\u0011\u0011\fG/\u00192j]\u0012TA!a\"\u0002\n\u00069!.Y2lg>t'\u0002BAF\u0003\u001b\u000b\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0005\u0005=\u0015aA2p[&!\u00111SAA\u00051y%M[3di6\u000b\u0007\u000f]3s\u0003\u001di\u0017\r\u001d9fe\u0002\nq\u0001[3bI\u0016\u00148/F\u0001`\u0003!AW-\u00193feN\u0004\u0013\u0001\u00028fqR$\"!!)\u0011\u0007E\f\u0019+C\u0002\u0002&\u0016\u0014qAQ8pY\u0016\fg.A\u0002hKR$\u0012\u0001Q\u0001\u0006G2|7/\u001a\u000b\u0003\u0003w\tac\u00195fG.\fe\u000e\u001a#fY\u0016$X\rV3na\u001aKG.\u001a\u000b\u0005\u0003w\t\u0019\fC\u0004\u00026j\u0001\r!a\u0013\u0002\t\u0019LG.Z\u0001\u0016M\u0016$8\r[\"p]R,g\u000e^,ji\"\u0014V\r\u001e:z)\u0015a\u00171XAf\u0011\u001d\til\u0007a\u0001\u0003\u007f\u000b1!\u001e:m!\u0011\t\t-a2\u000e\u0005\u0005\r'bAAci\u0005\u0019a.\u001a;\n\t\u0005%\u00171\u0019\u0002\u0004+Jc\u0005\"CAg7A\u0005\t\u0019AAh\u0003)i\u0017\r\u001f*fiJLWm\u001d\t\u0004c\u0006E\u0017bAAjK\n\u0019\u0011J\u001c;\u0002?\u0019,Go\u00195D_:$XM\u001c;XSRD'+\u001a;ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0002Z*\"\u0011qZAnW\t\ti\u000e\u0005\u0003\u0002`\u0006%XBAAq\u0015\u0011\t\u0019/!:\u0002\u0013Ut7\r[3dW\u0016$'bAAtK\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0018\u0011\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!F2sK\u0006$X\rU1si&$\u0018n\u001c8fI\u001aKG.\u001a\u000b\u0005\u0003c\fI\u0010\u0005\u0003\u0002t\u0006UX\"\u0001=\n\u0007\u0005]\bPA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f\u0011\u001d\t9%\ba\u0001\u0003\u0017\nqb\u0019:fCR,7\u000b]1sWB\u000bG\u000f\u001b\u000b\u0004a\u0005}\bB\u0002B\u0001=\u0001\u0007A.\u0001\u0006qCRD7\u000b\u001e:j]\u001e\u0004")
public class StacPartitionReader
implements PartitionReader<InternalRow> {
    private final StructType schema;
    private final Map<String, String> opts;
    private final Iterator<String> itemsIterator;
    private String currentItem;
    private File currentFile;
    private Iterator<InternalRow> featureIterator;
    private final ObjectMapper mapper;
    private final Map<String, String> headers;

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    private Iterator<String> itemsIterator() {
        return this.itemsIterator;
    }

    private String currentItem() {
        return this.currentItem;
    }

    private void currentItem_$eq(String x$1) {
        this.currentItem = x$1;
    }

    private File currentFile() {
        return this.currentFile;
    }

    private void currentFile_$eq(File x$1) {
        this.currentFile = x$1;
    }

    private Iterator<InternalRow> featureIterator() {
        return this.featureIterator;
    }

    private void featureIterator_$eq(Iterator<InternalRow> x$1) {
        this.featureIterator = x$1;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private Map<String, String> headers() {
        return this.headers;
    }

    public boolean next() {
        boolean bl;
        if (this.featureIterator().hasNext()) {
            bl = true;
        } else if (this.itemsIterator().hasNext()) {
            Iterator iterator;
            File tempFile;
            this.currentItem_$eq((String)this.itemsIterator().next());
            if (this.currentItem().startsWith("http://") || this.currentItem().startsWith("https://") || this.currentItem().startsWith("file://")) {
                URL url = new URL(this.currentItem());
                tempFile = File.createTempFile("stac_item_", ".json");
                try (PrintWriter writer = new PrintWriter(tempFile);){
                    String nodeType;
                    String fileContent = this.fetchContentWithRetry(url, this.fetchContentWithRetry$default$2());
                    JsonNode rootNode = this.mapper().readTree(fileContent);
                    String string = nodeType = rootNode.get("type").asText();
                    if ("Feature".equals(string)) {
                        String content = this.mapper().writeValueAsString((Object)rootNode);
                        writer.write(content);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    if ("FeatureCollection".equals(string)) {
                        JsonNode features = rootNode.get("features");
                        java.util.Iterator featureIterator = features.elements();
                        while (featureIterator.hasNext()) {
                            JsonNode feature = (JsonNode)featureIterator.next();
                            String content = this.mapper().writeValueAsString((Object)feature);
                            writer.write(content);
                            writer.write("\n");
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new IllegalArgumentException(new StringBuilder(27).append("Unsupported type for item: ").append(nodeType).toString());
                }
            } else {
                throw new IllegalArgumentException(new StringBuilder(31).append("Unsupported protocol for item: ").append(this.currentItem()).toString());
            }
            this.checkAndDeleteTempFile(this.currentFile());
            this.currentFile_$eq(tempFile);
            if (this.currentFile().exists()) {
                JSONOptionsInRead parsedOptions = new JSONOptionsInRead(this.opts, (String)this.opts.getOrElse((Object)"sessionLocalTimeZone", (Function0 & Serializable & scala.Serializable)() -> "UTC"), (String)this.opts.getOrElse((Object)"columnNameOfCorruptRecord", (Function0 & Serializable & scala.Serializable)() -> "_corrupt_record"));
                JsonDataSource dataSource = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions);
                StructType alteredSchema = GeoJSONUtils$.MODULE$.updateGeometrySchema(this.schema, (DataType)StringType$.MODULE$);
                JacksonParser parser = SparkCompatUtil$.MODULE$.constructJacksonParser((DataType)alteredSchema, (JSONOptions)parsedOptions, true);
                Iterator<InternalRow> rows = SparkCompatUtil$.MODULE$.readFile(dataSource, new Configuration(), this.createPartitionedFile(this.currentFile()), parser, this.schema);
                iterator = rows.map((Function1 & Serializable & scala.Serializable)row -> {
                    void var3_3;
                    InternalRow geometryConvertedRow = GeoJSONUtils$.MODULE$.convertGeoJsonToGeometry((InternalRow)row, alteredSchema);
                    InternalRow propertiesPromotedRow = StacUtils$.MODULE$.promotePropertiesToTop(geometryConvertedRow, alteredSchema);
                    return var3_3;
                });
            } else {
                iterator = package$.MODULE$.Iterator().empty();
            }
            this.featureIterator_$eq((Iterator<InternalRow>)iterator);
            bl = this.next();
        } else {
            bl = false;
        }
        return bl;
    }

    public InternalRow get() {
        return (InternalRow)this.featureIterator().next();
    }

    public void close() {
        this.checkAndDeleteTempFile(this.currentFile());
    }

    private void checkAndDeleteTempFile(File file) {
        block0: {
            if (file == null || !file.exists() || !file.getAbsolutePath().startsWith(System.getProperty("java.io.tmpdir"))) break block0;
            file.delete();
        }
    }

    public String fetchContentWithRetry(URL url, int maxRetries) {
        int attempt = 0;
        boolean success = false;
        String fileContent = "";
        while (attempt < maxRetries && !success) {
            try {
                if (this.headers().isEmpty()) {
                    fileContent = Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                } else {
                    BoxedUnit boxedUnit;
                    HttpURLConnection httpURLConnection;
                    URLConnection uRLConnection;
                    URLConnection connection = url.openConnection();
                    InputStream inputStream = null;
                    BufferedSource source = null;
                    try {
                        this.headers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            StacPartitionReader.$anonfun$fetchContentWithRetry$1(connection, x0$1);
                            return BoxedUnit.UNIT;
                        });
                        inputStream = connection.getInputStream();
                        source = Source$.MODULE$.fromInputStream(inputStream, Codec$.MODULE$.fallbackSystemCodec());
                        fileContent = source.mkString();
                    }
                    catch (Throwable throwable) {
                        if (source != null) {
                            try {
                                source.close();
                            }
                            catch (Throwable throwable2) {}
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {}
                        }
                        if ((uRLConnection = connection) instanceof HttpURLConnection) {
                            BoxedUnit boxedUnit2;
                            httpURLConnection = (HttpURLConnection)uRLConnection;
                            try {
                                httpURLConnection.disconnect();
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            catch (Throwable throwable4) {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit2;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        throw throwable;
                    }
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if ((uRLConnection = connection) instanceof HttpURLConnection) {
                        BoxedUnit boxedUnit3;
                        httpURLConnection = (HttpURLConnection)uRLConnection;
                        try {
                            httpURLConnection.disconnect();
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        catch (Throwable throwable) {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit3;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                success = true;
            }
            catch (Exception e) {
                if (++attempt < maxRetries) continue;
                throw new RuntimeException(new StringBuilder(48).append("Failed to fetch content from URL after ").append(maxRetries).append(" attempts").toString(), e);
            }
        }
        return fileContent;
    }

    public int fetchContentWithRetry$default$2() {
        return 3;
    }

    public PartitionedFile createPartitionedFile(File currentFile) {
        Object[] objectArray;
        Class<?> partitionedFileClass = Class.forName("org.apache.spark.sql.execution.datasources.PartitionedFile");
        Constructor[] constructors = partitionedFileClass.getConstructors();
        Constructor constructor = (Constructor)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])constructors)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StacPartitionReader.$anonfun$createPartitionedFile$1(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Constructor)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])constructors)).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StacPartitionReader.$anonfun$createPartitionedFile$3(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NoSuchMethodException("No constructor with 7 or 8 parameters found");
        }));
        if (constructor.getParameterCount() == 7) {
            Class<?> secondParamType = constructor.getParameterTypes()[1];
            String string = secondParamType.getName();
            String string2 = "org.apache.spark.paths.SparkPath";
            objectArray = !(string != null ? !string.equals(string2) : string2 != null) ? new Object[]{null, this.createSparkPath(currentFile.getPath()), 0L, currentFile.length(), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L} : new Object[]{null, currentFile.getPath(), 0L, currentFile.length(), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L};
        } else {
            objectArray = new Object[]{null, this.createSparkPath(currentFile.getPath()), 0L, currentFile.length(), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L, null};
        }
        Object[] params = objectArray;
        return (PartitionedFile)constructor.newInstance(params);
    }

    public Object createSparkPath(String pathString) {
        Class<?> sparkPathClass = Class.forName("org.apache.spark.paths.SparkPath");
        Constructor<?> constructor = sparkPathClass.getDeclaredConstructor(String.class);
        constructor.setAccessible(true);
        return constructor.newInstance(pathString);
    }

    public static final /* synthetic */ void $anonfun$fetchContentWithRetry$1(URLConnection connection$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        connection$1.setRequestProperty(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$createPartitionedFile$1(Constructor x$1) {
        return x$1.getParameterCount() == 7;
    }

    public static final /* synthetic */ boolean $anonfun$createPartitionedFile$3(Constructor x$2) {
        return x$2.getParameterCount() == 8;
    }

    public StacPartitionReader(Broadcast<SerializableConfiguration> broadcast, StacPartition partition, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        this.schema = schema;
        this.opts = opts;
        this.itemsIterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partition.items())).iterator();
        this.featureIterator = package$.MODULE$.Iterator().empty();
        this.mapper = new ObjectMapper();
        this.headers = StacUtils$.MODULE$.parseHeaders(opts);
    }
}

