/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;
import org.apache.sedona.shaded.s2.LittleEndianOutput;
import org.apache.sedona.shaded.s2.Platform;
import org.apache.sedona.shaded.s2.PrimitiveArrays;
import org.apache.sedona.shaded.s2.S1Angle;
import org.apache.sedona.shaded.s2.S2Coder;
import org.apache.sedona.shaded.s2.S2Point;

@Immutable
@JsType
public final class S2LatLng
implements Serializable {
    public static final S2LatLng CENTER = new S2LatLng(0.0, 0.0);
    public static final S2Coder<S2LatLng> CODER = new S2Coder<S2LatLng>(){

        @Override
        public void encode(S2LatLng value, OutputStream output) throws IOException {
            LittleEndianOutput.writeDouble(output, value.latRadians);
            LittleEndianOutput.writeDouble(output, value.lngRadians);
        }

        @Override
        public S2LatLng decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
            try {
                double lat = data.readLittleEndianDouble(cursor.position);
                double lng = data.readLittleEndianDouble(cursor.position + 8L);
                cursor.position += 16L;
                return S2LatLng.fromRadians(lat, lng);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Insufficient or invalid input bytes: ", e);
            }
        }

        @Override
        public boolean isLazy() {
            return false;
        }
    };
    private final double latRadians;
    private final double lngRadians;

    public static S2LatLng fromRadians(double latRadians, double lngRadians) {
        return new S2LatLng(latRadians, lngRadians);
    }

    public static S2LatLng fromDegrees(double latDegrees, double lngDegrees) {
        return new S2LatLng(S1Angle.degrees(latDegrees), S1Angle.degrees(lngDegrees));
    }

    public static S2LatLng fromE5(int latE5, int lngE5) {
        return new S2LatLng(S1Angle.e5(latE5), S1Angle.e5(lngE5));
    }

    public static S2LatLng fromE6(int latE6, int lngE6) {
        return new S2LatLng(S1Angle.e6(latE6), S1Angle.e6(lngE6));
    }

    public static S2LatLng fromE7(int latE7, int lngE7) {
        return new S2LatLng(S1Angle.e7(latE7), S1Angle.e7(lngE7));
    }

    public static S2LatLng fromPoint(S2Point p) {
        return new S2LatLng(p);
    }

    public static S1Angle latitude(S2Point p) {
        return S1Angle.radians(Math.atan2(p.z + 0.0, Math.sqrt(p.x * p.x + p.y * p.y)));
    }

    public static S1Angle longitude(S2Point p) {
        return S1Angle.radians(Math.atan2(p.y + 0.0, p.x + 0.0));
    }

    @JsConstructor
    private S2LatLng(double latRadians, double lngRadians) {
        this.latRadians = latRadians;
        this.lngRadians = lngRadians;
    }

    @JsIgnore
    public S2LatLng(S1Angle lat, S1Angle lng) {
        this(lat.radians(), lng.radians());
    }

    @JsIgnore
    public S2LatLng() {
        this(0.0, 0.0);
    }

    @JsIgnore
    public S2LatLng(S2Point p) {
        this(Math.atan2(p.z + 0.0, Math.sqrt(p.x * p.x + p.y * p.y)), Math.atan2(p.y + 0.0, p.x + 0.0));
    }

    public S1Angle lat() {
        return S1Angle.radians(this.latRadians);
    }

    public double latRadians() {
        return this.latRadians;
    }

    public double latDegrees() {
        return 57.29577951308232 * this.latRadians;
    }

    public S1Angle lng() {
        return S1Angle.radians(this.lngRadians);
    }

    public double lngRadians() {
        return this.lngRadians;
    }

    public double lngDegrees() {
        return 57.29577951308232 * this.lngRadians;
    }

    public boolean isValid() {
        return S2LatLng.isValid(this.latRadians, this.lngRadians);
    }

    public static boolean isValid(double latRadians, double lngRadians) {
        return Math.abs(latRadians) <= 1.5707963267948966 && Math.abs(lngRadians) <= Math.PI;
    }

    @CheckReturnValue
    public S2LatLng normalized() {
        return new S2LatLng(Math.max(-1.5707963267948966, Math.min(1.5707963267948966, this.latRadians)), Platform.IEEEremainder(this.lngRadians, Math.PI * 2));
    }

    public S2Point toPoint() {
        assert (Double.isFinite(this.latRadians)) : this.latRadians;
        assert (Double.isFinite(this.lngRadians)) : this.lngRadians;
        double phi = this.latRadians;
        double theta = this.lngRadians;
        double cosphi = Math.cos(phi);
        return new S2Point(Math.cos(theta) * cosphi, Math.sin(theta) * cosphi, Math.sin(phi));
    }

    public S1Angle getDistance(S2LatLng o) {
        double lat1 = this.latRadians;
        double lat2 = o.latRadians;
        double lng1 = this.lngRadians;
        double lng2 = o.lngRadians;
        double dlat = Math.sin(0.5 * (lat2 - lat1));
        double dlng = Math.sin(0.5 * (lng2 - lng1));
        double x = dlat * dlat + dlng * dlng * Math.cos(lat1) * Math.cos(lat2);
        return S1Angle.radians(2.0 * Math.asin(Math.sqrt(Math.min(1.0, x))));
    }

    @JsMethod(name="getDistanceWithRadius")
    public double getDistance(S2LatLng o, double radius) {
        return this.getDistance(o).distance(radius);
    }

    @CheckReturnValue
    public S2LatLng add(S2LatLng o) {
        return new S2LatLng(this.latRadians + o.latRadians, this.lngRadians + o.lngRadians);
    }

    @CheckReturnValue
    public S2LatLng sub(S2LatLng o) {
        return new S2LatLng(this.latRadians - o.latRadians, this.lngRadians - o.lngRadians);
    }

    @CheckReturnValue
    public S2LatLng mul(double m3) {
        return new S2LatLng(this.latRadians * m3, this.lngRadians * m3);
    }

    public boolean equals(Object that) {
        if (that instanceof S2LatLng) {
            S2LatLng o = (S2LatLng)that;
            return this.latRadians == o.latRadians && this.lngRadians == o.lngRadians;
        }
        return false;
    }

    public int hashCode() {
        long value = 17L;
        value += 37L * value + Double.doubleToLongBits(this.latRadians);
        value += 37L * value + Double.doubleToLongBits(this.lngRadians);
        return (int)(value ^ value >>> 32);
    }

    @JsMethod(name="approxEqualsWithMaxError")
    public boolean approxEquals(S2LatLng o, double maxError) {
        return Math.abs(this.latRadians - o.latRadians) < maxError && Math.abs(this.lngRadians - o.lngRadians) < maxError;
    }

    @CheckReturnValue
    public boolean approxEquals(S2LatLng o) {
        return this.approxEquals(o, 1.0E-9);
    }

    public String toString() {
        return "(" + this.latRadians + ", " + this.lngRadians + ")";
    }

    public String toStringDegrees() {
        return "(" + this.latDegrees() + ", " + this.lngDegrees() + ")";
    }
}

