/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sedona.shaded.guava.primitives.UnsignedInts;
import org.apache.sedona.shaded.s2.InputStreams;

public class EncodedInts {
    private EncodedInts() {
    }

    public static long readVarint64(InputStream input) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = InputStreams.readByte(input);
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("Malformed varint.");
    }

    public static int varIntSize(long value) {
        int bytes = 0;
        do {
            ++bytes;
        } while ((value >>>= 7) != 0L);
        return bytes;
    }

    public static void writeVarint64(OutputStream output, long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                output.write((byte)value);
                return;
            }
            output.write((byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    public static long decodeUintWithLength(InputStream input, int bytesPerWord) throws IOException {
        long x = 0L;
        for (int i = 0; i < bytesPerWord; ++i) {
            x += ((long)InputStreams.readByte(input) & 0xFFL) << 8 * i;
        }
        return x;
    }

    public static void encodeUintWithLength(OutputStream output, long value, int bytesPerWord) throws IOException {
        while (--bytesPerWord >= 0) {
            output.write((byte)value);
            value >>>= 8;
        }
        assert (value == 0L);
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public static long interleaveBits(int val1, int val2) {
        return EncodedInts.insertBlankBits(val1) | EncodedInts.insertBlankBits(val2) << 1;
    }

    public static int deinterleaveBits1(long bits) {
        return EncodedInts.removeBlankBits(bits);
    }

    public static int deinterleaveBits2(long bits) {
        return EncodedInts.removeBlankBits(bits >>> 1);
    }

    private static final long insertBlankBits(int value) {
        long bits = UnsignedInts.toLong(value);
        bits = (bits | bits << 16) & 0xFFFF0000FFFFL;
        bits = (bits | bits << 8) & 0xFF00FF00FF00FFL;
        bits = (bits | bits << 4) & 0xF0F0F0F0F0F0F0FL;
        bits = (bits | bits << 2) & 0x3333333333333333L;
        bits = (bits | bits << 1) & 0x5555555555555555L;
        return bits;
    }

    private static int removeBlankBits(long bits) {
        bits &= 0x5555555555555555L;
        bits |= bits >>> 1;
        bits &= 0x3333333333333333L;
        bits |= bits >>> 2;
        bits &= 0xF0F0F0F0F0F0F0FL;
        bits |= bits >>> 4;
        bits &= 0xFF00FF00FF00FFL;
        bits |= bits >>> 8;
        bits &= 0xFFFF0000FFFFL;
        bits |= bits >>> 16;
        return (int)bits;
    }

    public static long interleaveBitPairs(int val1, int val2) {
        return EncodedInts.insertBlankPairs(val1) | EncodedInts.insertBlankPairs(val2) << 2;
    }

    public static int deinterleaveBitPairs1(long pairs) {
        return EncodedInts.removeBlankPairs(pairs);
    }

    public static int deinterleaveBitPairs2(long pairs) {
        return EncodedInts.removeBlankPairs(pairs >>> 2);
    }

    private static final long insertBlankPairs(int value) {
        long bits = UnsignedInts.toLong(value);
        bits = (bits | bits << 16) & 0xFFFF0000FFFFL;
        bits = (bits | bits << 8) & 0xFF00FF00FF00FFL;
        bits = (bits | bits << 4) & 0xF0F0F0F0F0F0F0FL;
        bits = (bits | bits << 2) & 0x3333333333333333L;
        return bits;
    }

    private static int removeBlankPairs(long pairs) {
        pairs &= 0x3333333333333333L;
        pairs |= pairs >>> 2;
        pairs &= 0xF0F0F0F0F0F0F0FL;
        pairs |= pairs >>> 4;
        pairs &= 0xFF00FF00FF00FFL;
        pairs |= pairs >>> 8;
        pairs &= 0xFFFF0000FFFFL;
        pairs |= pairs >>> 16;
        return (int)pairs;
    }
}

