/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.simplify;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.sedona.common.simplify.CoordinateSplitter;
import org.apache.sedona.common.simplify.ZeroToleranceGeometrySimplifier;
import org.locationtech.jts.geom.Coordinate;

public class CoordinatesSimplifier {
    public static Coordinate[] simplifyInPlace(Coordinate[] geom, double tolerance, int minPointsExternal) {
        double itTool;
        if (geom.length < 3 || geom.length <= minPointsExternal) {
            return geom;
        }
        if (tolerance == 0.0 && minPointsExternal <= 2) {
            return ZeroToleranceGeometrySimplifier.simplifyInPlaceTolerance0(geom);
        }
        boolean[] kept_points = new boolean[geom.length];
        kept_points[0] = true;
        int itLast = geom.length - 1;
        kept_points[itLast] = true;
        int keptn = 2;
        Stack<Integer> iteratorStack = new Stack<Integer>();
        iteratorStack.push(0);
        int itFirst = 0;
        double toleranceSquared = tolerance * tolerance;
        double d = itTool = keptn >= minPointsExternal ? toleranceSquared : -1.0;
        while (!iteratorStack.isEmpty()) {
            CoordinateSplitter.SplitInPlace splitInPlaceRes = CoordinateSplitter.splitInPlace(geom, itFirst, itLast, itTool);
            if (splitInPlaceRes.getSplit() == itFirst) {
                itFirst = itLast;
                itLast = (Integer)iteratorStack.pop();
                continue;
            }
            kept_points[splitInPlaceRes.getSplit()] = true;
            iteratorStack.push(itLast);
            itLast = splitInPlaceRes.getSplit();
            itTool = ++keptn >= minPointsExternal ? toleranceSquared : -1.0;
        }
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        for (int i = 0; i < kept_points.length; ++i) {
            if (!kept_points[i]) continue;
            result.add(geom[i]);
        }
        return result.toArray(new Coordinate[0]);
    }
}

