/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v13SynchedPool;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.util.Refs;
import ch.ethz.globis.phtree.v13SynchedPool.Node;
import ch.ethz.globis.phtree.v13SynchedPool.NodeIteratorNoGC;
import ch.ethz.globis.phtree.v13SynchedPool.PhTree13SP;
import java.util.NoSuchElementException;

public final class PhIteratorNoGC<T>
implements PhTree.PhQuery<T> {
    private final int dims;
    private final PhIteratorStack stack;
    private final long[] valTemplate;
    private long[] rangeMin;
    private long[] rangeMax;
    private PhFilter checker;
    private final PhTree13SP<T> pht;
    private PhEntry<T> resultFree;
    private PhEntry<T> resultToReturn;
    private boolean isFinished = false;

    public PhIteratorNoGC(PhTree13SP<T> pht, PhFilter checker) {
        this.dims = pht.getDim();
        this.checker = checker;
        this.stack = new PhIteratorStack();
        this.valTemplate = new long[this.dims];
        this.pht = pht;
        this.resultFree = new PhEntry<Object>(new long[this.dims], null);
        this.resultToReturn = new PhEntry<Object>(new long[this.dims], null);
    }

    @Override
    public PhIteratorNoGC<T> reset(long[] rangeMin, long[] rangeMax) {
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.stack.size = 0;
        this.isFinished = false;
        if (this.pht.getRoot() == null) {
            this.isFinished = true;
            return this;
        }
        this.stack.prepareAndPush(this.pht.getRoot());
        this.findNextElement();
        return this;
    }

    private void findNextElement() {
        PhEntry<T> result = this.resultFree;
        while (!this.stack.isEmpty()) {
            NodeIteratorNoGC<T> p = this.stack.peek();
            while (p.increment(result)) {
                if (result.hasNodeInternal()) {
                    p = this.stack.prepareAndPush((Node)result.getNodeInternal());
                    continue;
                }
                this.resultFree = this.resultToReturn;
                this.resultToReturn = result;
                return;
            }
            this.stack.pop();
        }
        this.isFinished = true;
    }

    @Override
    public long[] nextKey() {
        long[] key = ((PhEntry)this.nextEntryReuse()).getKey();
        long[] ret = new long[key.length];
        if (this.dims > 10) {
            System.arraycopy(key, 0, ret, 0, key.length);
        } else {
            for (int i = 0; i < key.length; ++i) {
                ret[i] = key[i];
            }
        }
        return ret;
    }

    @Override
    public T nextValue() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public PhEntry<T> nextEntry() {
        return new PhEntry(this.nextEntryReuse());
    }

    @Override
    public T next() {
        Object v = ((PhEntry)this.nextEntryReuse()).getValue();
        return v == PhTreeHelper.NULL ? null : (T)v;
    }

    @Override
    public PhEntry<T> nextEntryReuse() {
        if (this.isFinished) {
            throw new NoSuchElementException();
        }
        PhEntry<T> ret = this.resultToReturn;
        this.findNextElement();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void adjustMinMax() {
        while (this.stack.size > 1 && !this.stack.peek().verifyMinMax()) {
            this.stack.pop();
        }
        if (this.checker != null) {
            while (!this.stack.isEmpty() && !this.checker.isValid(this.stack.peek().node().getPostLen() + 1, this.valTemplate)) {
                this.stack.pop();
            }
        }
        while (!this.stack.isEmpty() && !this.stack.peek().adjustMinMax(this.rangeMin, this.rangeMax)) {
            this.stack.pop();
        }
    }

    private class PhIteratorStack {
        private final NodeIteratorNoGC<T>[] stack = Refs.newArray(NodeIteratorNoGC.class, 64);
        private int size = 0;

        public boolean isEmpty() {
            return this.size == 0;
        }

        public NodeIteratorNoGC<T> prepareAndPush(Node node) {
            NodeIteratorNoGC ni;
            if ((ni = this.stack[this.size++]) == null) {
                ni = new NodeIteratorNoGC(PhIteratorNoGC.this.dims, PhIteratorNoGC.this.valTemplate);
                this.stack[this.size - 1] = ni;
            }
            ni.init(PhIteratorNoGC.this.rangeMin, PhIteratorNoGC.this.rangeMax, node, PhIteratorNoGC.this.checker);
            return ni;
        }

        public NodeIteratorNoGC<T> peek() {
            return this.stack[this.size - 1];
        }

        public NodeIteratorNoGC<T> pop() {
            return this.stack[--this.size];
        }
    }
}

