/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.twak.utils.ImageU;
import org.twak.utils.ui.Rainbow;

public class WindowManager {
    public static String iconName = "nonesuch.png";
    static BufferedImage icon;
    static List<WeakReference<JFrame>> frames;
    static long last;
    static String appName;

    public static void init(String name, String iconName) {
        appName = name;
        icon = ImageU.cacheResource.get(iconName);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setTitle(String title) {
        appName = title;
        for (WeakReference<JFrame> r : frames) {
            JFrame f = (JFrame)r.get();
            if (f == null) continue;
            f.setTitle(appName);
        }
    }

    public static void register(JFrame frame) {
        WindowManager.register(frame, "");
    }

    public static void register(JFrame frame, String title) {
        frame.setIconImage(WindowManager.getIcon());
        frame.setTitle(appName + ": " + title);
        frames.add(new WeakReference<JFrame>(frame));
    }

    public static JFrame frame(String title, JComponent content) {
        JFrame out = new JFrame(title);
        out.setContentPane(content);
        WindowManager.register(out, title);
        return out;
    }

    static Image getIcon() {
        if (icon == null) {
            icon = new BufferedImage(256, 256, 6);
            Graphics2D g2 = (Graphics2D)icon.getGraphics();
            g2.setColor(Rainbow.random());
            g2.fillRect(0, 0, icon.getWidth(), icon.getHeight());
            g2.setColor(Color.black);
            g2.drawString("" + System.currentTimeMillis(), 30, 30);
            g2.dispose();
        }
        return icon;
    }

    static {
        frames = new ArrayList<WeakReference<JFrame>>();
        last = System.currentTimeMillis();
        appName = "super happy fun app";
    }
}

