/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.debug;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Point2d;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.Machine;
import org.twak.camp.debug.DebugDevice;
import org.twak.camp.offset.Offset;
import org.twak.camp.offset.OffsetSkeleton;
import org.twak.camp.ui.Bar;
import org.twak.camp.ui.PointEditor;
import org.twak.utils.Cache;
import org.twak.utils.LContext;
import org.twak.utils.Pair;
import org.twak.utils.collections.ConsecutivePairs;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;

public class PartialOffsetPointEditor
extends PointEditor {
    Map<Bar, Boolean> offset = new HashMap<Bar, Boolean>();
    boolean changed = true;
    boolean busy = false;
    LoopL<Corner> output;

    public PartialOffsetPointEditor() {
        EdgeClickListener m3 = new EdgeClickListener();
        this.addMouseListener(m3);
        this.addMouseMotionListener(m3);
    }

    @Override
    protected void createInitial() {
        Loop<Bar> loop = new Loop<Bar>();
        this.edges.add(loop);
        for (Pair<Point2d, Point2d> pair : new ConsecutivePairs<Point2d>(Arrays.asList(new Point2d(250.0, 100.0), new Point2d(350.0, 100.0), new Point2d(350.0, 250.0), new Point2d(500.0, 250.0), new Point2d(500.0, 350.0), new Point2d(350.0, 350.0), new Point2d(350.0, 500.0), new Point2d(250.0, 500.0), new Point2d(250.0, 350.0), new Point2d(100.0, 350.0), new Point2d(100.0, 250.0), new Point2d(250.0, 250.0)), true)) {
            Bar bar = new Bar(pair.first(), pair.second());
            this.offset.put(bar, Math.random() > 0.5);
            loop.append(bar);
        }
    }

    @Override
    public void movePoint(LContext<Bar> ctx, Point2d pt, Point2d location, MouseEvent evt) {
        this.changed = true;
        super.movePoint(ctx, pt, location, evt);
    }

    @Override
    public void remove(LContext<Bar> ctx, Point2d dragged) {
        this.changed = true;
        super.remove(ctx, dragged);
    }

    @Override
    public void addBetween(LContext<Bar> ctx, Point l) {
        this.changed = true;
        super.addBetween(ctx, l);
        this.offset.put((Bar)ctx.loopable.getNext().get(), true);
    }

    @Override
    public void paintPointEditor(Graphics2D g2) {
        for (Loop loop : this.edges) {
            for (Bar bar : loop) {
                g2.setColor(this.offset.get(bar) != false ? Color.red : Color.black);
                g2.drawLine(this.ma.toX(bar.start.x), this.ma.toY(bar.start.y), this.ma.toX(bar.end.x), this.ma.toY(bar.end.y));
            }
        }
        g2.setColor(Color.orange);
        for (Bar bar : this.edges.eIterator()) {
            this.drawPixel((Graphics)g2, bar.start);
        }
        final LoopL out = new LoopL();
        Cache<Point2d, Corner> cCache = new Cache<Point2d, Corner>(){

            @Override
            public Corner create(Point2d i) {
                return new Corner(i.x, i.y);
            }
        };
        final Machine machineO = new Machine(0.7853981633974483);
        final Machine machineN = new Machine(0.7853981633974483);
        for (Loop loop : this.edges) {
            Loop<Corner> loop2 = new Loop<Corner>();
            out.add(loop2);
            for (Bar bar : loop) {
                Corner s2 = (Corner)cCache.get(bar.start);
                Corner e = (Corner)cCache.get(bar.end);
                e.prevL = s2.nextL = new Edge(s2, e);
                s2.nextC = e;
                e.prevC = s2;
                s2.nextL.machine = this.offset.get(bar) != false ? machineO : machineN;
                loop2.append(s2);
            }
        }
        if (!this.busy && this.changed) {
            this.busy = true;
            this.changed = false;
            new Thread(){

                @Override
                public void run() {
                    try {
                        DebugDevice.reset();
                        OffsetSkeleton<Machine> os = new OffsetSkeleton<Machine>(out, 50.0);
                        os.registerProfile(machineN, 0.0, 1);
                        os.registerProfile(machineO, 0.7853981633974483, 1);
                        Offset out2 = os.getResults().get(0);
                        PartialOffsetPointEditor.this.output = out2.shape;
                    }
                    finally {
                        PartialOffsetPointEditor.this.busy = false;
                        PartialOffsetPointEditor.this.repaint();
                    }
                }
            }.start();
        }
        if (this.output != null) {
            for (Loop loop : this.output) {
                Polygon pg = new Polygon();
                for (Corner p : loop) {
                    pg.addPoint(this.ma.toX(p.x), this.ma.toY(p.y));
                }
                g2.setColor(Color.blue);
                g2.drawPolygon(pg);
            }
        }
    }

    public class EdgeClickListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            LContext<Bar> place = PartialOffsetPointEditor.this.getNearest(PartialOffsetPointEditor.this.ma.from(e), 10.0);
            if (place == null) {
                return;
            }
            PartialOffsetPointEditor.this.offset.put(place.get(), PartialOffsetPointEditor.this.offset.get(place.get()) == false);
            PartialOffsetPointEditor.this.changed = true;
            PartialOffsetPointEditor.this.repaint();
        }
    }
}

