/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.geography;

import java.util.ArrayList;
import java.util.List;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.MultiPolygonGeography;
import org.apache.sedona.common.S2Geography.PolygonGeography;
import org.apache.sedona.common.S2Geography.SinglePointGeography;
import org.apache.sedona.shaded.s2.S2LatLng;
import org.apache.sedona.shaded.s2.S2LatLngRect;
import org.apache.sedona.shaded.s2.S2Loop;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Polygon;

public class Functions {
    private static final double EPSILON = 1.0E-9;

    private static boolean nearlyEqual(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return false;
        }
        return Math.abs(a - b) < 1.0E-9;
    }

    public static Geography getEnvelope(Geography geography, boolean splitAtAntiMeridian) {
        Geography envelope;
        if (geography == null) {
            return null;
        }
        S2LatLngRect rect = geography.region().getRectBound();
        double lngLo = rect.lngLo().degrees();
        double latLo = rect.latLo().degrees();
        double lngHi = rect.lngHi().degrees();
        double latHi = rect.latHi().degrees();
        if (Functions.nearlyEqual(latLo, latHi) && Functions.nearlyEqual(lngLo, lngHi)) {
            S2Point point = S2LatLng.fromDegrees(latLo, lngLo).toPoint();
            SinglePointGeography pointGeo = new SinglePointGeography(point);
            pointGeo.setSRID(geography.getSRID());
            return pointGeo;
        }
        if (splitAtAntiMeridian && rect.lng().isInverted()) {
            S2Polygon left = Functions.rectToPolygon(lngLo, latLo, 180.0, latHi);
            S2Polygon right = Functions.rectToPolygon(-180.0, latLo, lngHi, latHi);
            envelope = new MultiPolygonGeography(Geography.GeographyKind.MULTIPOLYGON, List.of(left, right));
        } else {
            envelope = new PolygonGeography(Functions.rectToPolygon(lngLo, latLo, lngHi, latHi));
        }
        envelope.setSRID(geography.getSRID());
        return envelope;
    }

    private static S2Polygon rectToPolygon(double lngLo, double latLo, double lngHi, double latHi) {
        ArrayList<S2Point> v = new ArrayList<S2Point>(4);
        v.add(S2LatLng.fromDegrees(latLo, lngLo).toPoint());
        v.add(S2LatLng.fromDegrees(latLo, lngHi).toPoint());
        v.add(S2LatLng.fromDegrees(latHi, lngHi).toPoint());
        v.add(S2LatLng.fromDegrees(latHi, lngLo).toPoint());
        S2Loop loop = new S2Loop(v);
        loop.normalize();
        return new S2Polygon(loop);
    }

    public static String asEWKT(Geography geography) {
        return geography.toEWKT();
    }
}

