/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import com.thoughtworks.xstream.XStream;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.twak.utils.ui.SimpleFileChooser;

public class SaveLoad {
    Field targetField;
    Object targetObject;
    JMenu menu;
    public File saveAs;
    protected JMenuItem saveMenuItem = new JMenuItem();

    public void addSaveLoadMenuItems(JMenu menu, String targetField, Object targetObject) {
        try {
            this.targetField = targetObject.getClass().getField(targetField);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.targetObject = targetObject;
        this.menu = menu;
        try {
            if (this.getClass().getMethod("makeNew", new Class[0]).getDeclaringClass() != SaveLoad.class) {
                JMenuItem newItem = new JMenuItem();
                newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
                newItem.setText("new");
                newItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        SaveLoad.this.saveAs = null;
                        SaveLoad.this.saveMenuItem.setEnabled(false);
                        SaveLoad.this.makeNew();
                    }
                });
                menu.add(newItem);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        JMenuItem loadMenuItem = new JMenuItem();
        loadMenuItem.setText("load");
        loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveLoad.this.loadMenuItemActionPerformed(evt);
            }
        });
        loadMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menu.add(loadMenuItem);
        this.saveMenuItem.setText("save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveLoad.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.saveMenuItem.setEnabled(false);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menu.add(this.saveMenuItem);
        JMenuItem saveAsMenuItem = new JMenuItem();
        saveAsMenuItem.setText("save as...");
        saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveLoad.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        menu.add(saveAsMenuItem);
        saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        JMenuItem quitMenuItem = new JMenuItem();
        quitMenuItem.setText("quit");
        quitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveLoad.this.quitMenuItemActionPerformed(evt);
            }
        });
        quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        menu.add(quitMenuItem);
    }

    public void makeNew() {
    }

    public void beforeSave() {
    }

    public void afterSave() {
    }

    public void afterLoad() {
    }

    private boolean allowQuit() {
        return true;
    }

    private void quitMenuItemActionPerformed(ActionEvent evt) {
        if (this.allowQuit()) {
            System.exit(0);
        }
    }

    private JFrame findFrame() {
        Container c = this.menu;
        while (!(c instanceof JFrame)) {
            c = c.getParent();
        }
        return (JFrame)c;
    }

    protected void loadMenuItemActionPerformed(ActionEvent evt) {
        new SimpleFileChooser(this.findFrame(), false, "load"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void heresTheFile(File f) throws Throwable {
                FileInputStream fis = null;
                try {
                    XStream xs = SaveLoad.createXStream();
                    SaveLoad.this.saveAs = f;
                    fis = new FileInputStream(SaveLoad.this.saveAs);
                    SaveLoad.this.targetField.set(SaveLoad.this.targetObject, xs.fromXML(fis));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(SaveLoad.this.menu, "error loading file :(");
                    ex.printStackTrace();
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        if (SaveLoad.this.saveAs != null) {
                            SaveLoad.this.saveMenuItem.setEnabled(true);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    SaveLoad.this.afterLoad();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMenuItemActionPerformed(ActionEvent evt) {
        this.beforeSave();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.saveAs);
            SaveLoad.createXStream().toXML(this.targetField.get(this.targetObject), fos);
            this.saveMenuItem.setEnabled(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.menu, "error saving file :(");
            ex.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.afterSave();
        }
    }

    private void saveAsMenuItemActionPerformed(final ActionEvent evt) {
        new SimpleFileChooser(this.findFrame(), true, "save", this.saveAs, null){

            @Override
            public void heresTheFile(File f) throws Throwable {
                SaveLoad.this.saveAs = f;
                SaveLoad.this.saveMenuItemActionPerformed(evt);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debugSave(String fileName, Object toSave) {
        FileOutputStream fos = null;
        try {
            XStream xs = SaveLoad.createXStream();
            fos = new FileOutputStream(fileName);
            xs.toXML(toSave, fos);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static XStream createXStream() {
        return new XStream();
    }
}

