/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.twak.utils.Cache;
import org.twak.utils.MutableInteger;
import org.twak.utils.Pair;

public class CountThings<E> {
    public Cache<E, MutableInteger> counts = new Cache<E, MutableInteger>(){

        @Override
        public MutableInteger create(E i) {
            return new MutableInteger(0);
        }
    };
    int seen = 0;

    public int count(E e) {
        ++this.counts.get(e).i;
        ++this.seen;
        return this.counts.get(e).i;
    }

    public void count(E e, int by) {
        this.counts.get(e).i += by;
        this.seen += by;
    }

    public void uncount(E e) {
        --this.counts.get(e).i;
        --this.seen;
    }

    public int total(E e) {
        return this.counts.get(e).i;
    }

    public Pair<E, Integer> getMax() {
        Object val = null;
        int max = Integer.MIN_VALUE;
        for (Map.Entry e : this.counts.cache.entrySet()) {
            if (((MutableInteger)e.getValue()).i <= max) continue;
            max = ((MutableInteger)e.getValue()).i;
            val = e.getKey();
        }
        return new Pair<Object, Integer>(val, max);
    }

    public Pair<E, Integer> getMin() {
        Object val = null;
        int min2 = Integer.MAX_VALUE;
        for (Map.Entry e : this.counts.cache.entrySet()) {
            if (((MutableInteger)e.getValue()).i >= min2) continue;
            min2 = ((MutableInteger)e.getValue()).i;
            val = e.getKey();
        }
        return new Pair<Object, Integer>(val, min2);
    }

    public Pair<Set<E>, Integer> getMaxes() {
        HashSet val = null;
        int max = Integer.MIN_VALUE;
        for (Map.Entry e : this.counts.cache.entrySet()) {
            if (((MutableInteger)e.getValue()).i <= max) continue;
            if (((MutableInteger)e.getValue()).i != max) {
                val = new HashSet();
                max = ((MutableInteger)e.getValue()).i;
            }
            val.add(e.getKey());
        }
        return new Pair<Object, Integer>(val, max);
    }

    public int getSize() {
        return this.seen;
    }
}

