/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.twak.camp.Edge;
import org.twak.camp.HeightEvent;
import org.twak.camp.Skeleton;
import org.twak.camp.ui.DirectionHeightEvent;

public class Machine {
    public Color color;
    public List<HeightEvent> events = new ArrayList<HeightEvent>();
    String description = "unnamed machine";
    public double currentAngle = 0.7853981633974483;
    public transient HeightEvent heightEvent;
    public transient int currentDirection = -1;
    protected Set<Edge> seenEdges = new LinkedHashSet<Edge>();
    static Color[] rainbow = new Color[]{Color.red, Color.green, Color.blue, Color.magenta};
    static String[] rainbowStrings = new String[]{"red", "green", "blue", "magenta"};
    static int rainbowIndex = 0;

    public Machine() {
        this(0.7853981633974483);
    }

    public Machine(double initial) {
        this.color = rainbow[rainbowIndex % rainbowStrings.length];
        this.description = rainbowStrings[rainbowIndex % rainbowStrings.length];
        ++rainbowIndex;
        this.addHeightEvent(new DirectionHeightEvent(this, initial));
        this.currentAngle = initial;
    }

    public String toString() {
        return this.description;
    }

    public void addEdge(Edge e, Skeleton skel) {
        if (this.heightEvent == null) {
            this.findNextHeight(skel);
        }
        e.setAngle(this.currentAngle);
    }

    public List<Edge> findOurEdges(Skeleton skel) {
        ArrayList<Edge> edgesToChange = new ArrayList<Edge>();
        for (Edge e : skel.liveEdges) {
            if (e.machine != this) continue;
            edgesToChange.add(e);
        }
        return edgesToChange;
    }

    public void findNextHeight(Skeleton skel) {
        if (this.events.isEmpty()) {
            throw new Error("I need height events!");
        }
        ++this.currentDirection;
        if (this.currentDirection == 0) {
            if (this.events.get(0) instanceof DirectionHeightEvent) {
                this.currentAngle = ((DirectionHeightEvent)this.events.get((int)0)).newAngle;
                this.heightEvent = this.events.get(0);
                ++this.currentDirection;
            } else {
                throw new Error("You have to think really hard about how the first event sets it's angle before you do this");
            }
        }
        if (this.currentDirection >= this.getDirections().size()) {
            return;
        }
        this.heightEvent = this.getDirections().get(this.currentDirection);
        skel.qu.add(this.heightEvent);
    }

    public List<HeightEvent> getDirections() {
        return this.events;
    }

    public void sortHeightEvents() {
        Collections.sort(this.events, HeightEvent.heightComparator);
    }

    public void addHeightEvent(HeightEvent dir) {
        this.events.add(dir);
        this.sortHeightEvents();
    }
}

