/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.math.BigDecimal;
import java.util.Optional;
import org.apache.sedona.shaded.guava.annotations.VisibleForTesting;
import org.apache.sedona.shaded.guava.primitives.Doubles;
import org.apache.sedona.shaded.s2.BigPoint;
import org.apache.sedona.shaded.s2.Platform;
import org.apache.sedona.shaded.s2.Real;
import org.apache.sedona.shaded.s2.S2;
import org.apache.sedona.shaded.s2.S2Point;

public final class S2RobustCrossProd {
    public static S2Point robustCrossProd(S2Point a, S2Point b) {
        Optional<S2Point> result = S2RobustCrossProd.stableCrossProd(a, b);
        if (result.isPresent()) {
            return result.get();
        }
        return S2RobustCrossProd.exactCrossProd(a, b);
    }

    @VisibleForTesting
    static S2Point exactCrossProd(S2Point a, S2Point b) {
        if (a.equalsPoint(b)) {
            return S2.ortho(a);
        }
        Optional<S2Point> realResult = S2RobustCrossProd.realCrossProd(a, b);
        if (realResult.isPresent()) {
            return realResult.get();
        }
        Optional<S2Point> bigDecimalCrossProd = S2RobustCrossProd.bigDecimalCrossProd(a, b);
        if (bigDecimalCrossProd.isPresent()) {
            return bigDecimalCrossProd.get();
        }
        return S2RobustCrossProd.symbolicCrossProd(a, b);
    }

    @VisibleForTesting
    static Optional<S2Point> stableCrossProd(S2Point a, S2Point b) {
        S2Point result = b.add(a).crossProd(b.sub(a));
        if (result.norm2() < S2.MIN_NORM * S2.MIN_NORM) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    @VisibleForTesting
    static Optional<S2Point> realCrossProd(S2Point a, S2Point b) {
        try {
            S2Point sum = a.add(b);
            S2Point difference = b.sub(a);
            Real cx = Real.strictMul(sum.getY(), difference.getZ()).sub(Real.strictMul(sum.getZ(), difference.getY()));
            Real cy = Real.strictMul(sum.getZ(), difference.getX()).sub(Real.strictMul(sum.getX(), difference.getZ()));
            Real cz = Real.strictMul(sum.getX(), difference.getY()).sub(Real.strictMul(sum.getY(), difference.getX()));
            S2Point realResult = S2RobustCrossProd.normalizableFromReal(new S2Point(cx.doubleValue(), cy.doubleValue(), cz.doubleValue()));
            if (realResult.equalsPoint(S2Point.ORIGIN) || !S2RobustCrossProd.isNormalizable(realResult)) {
                return Optional.empty();
            }
            return Optional.of(realResult);
        }
        catch (ArithmeticException e) {
            return Optional.empty();
        }
    }

    @VisibleForTesting
    static Optional<S2Point> bigDecimalCrossProd(S2Point a, S2Point b) {
        BigPoint ba = new BigPoint(a);
        BigPoint bb = new BigPoint(b);
        BigPoint axb = ba.crossProd(bb);
        S2Point normalizable = S2RobustCrossProd.normalizeFromBigDecimal(axb.x, axb.y, axb.z);
        if (normalizable.equalsPoint(S2Point.ORIGIN)) {
            return Optional.empty();
        }
        return Optional.of(normalizable);
    }

    @VisibleForTesting
    static S2Point symbolicCrossProd(S2Point a, S2Point b) {
        if (a.lessThan(b)) {
            return S2RobustCrossProd.ensureNormalizable(S2RobustCrossProd.symbolicCrossProdSorted(a, b));
        }
        return S2RobustCrossProd.ensureNormalizable(S2RobustCrossProd.symbolicCrossProdSorted(b, a)).neg();
    }

    @VisibleForTesting
    static S2Point symbolicCrossProdSorted(S2Point a, S2Point b) {
        if (b.getX() != 0.0 || b.getY() != 0.0) {
            return new S2Point(-b.getY(), b.getX(), 0.0);
        }
        if (b.getZ() != 0.0) {
            return new S2Point(b.getZ(), 0.0, 0.0);
        }
        if (a.getX() != 0.0 || a.getY() != 0.0) {
            return new S2Point(a.getY(), -a.getX(), 0.0);
        }
        return new S2Point(1.0, 0.0, 0.0);
    }

    private static S2Point ensureNormalizable(S2Point point) {
        if (S2RobustCrossProd.isNormalizable(point)) {
            return point;
        }
        double pmax = Doubles.max(Math.abs(point.getX()), Math.abs(point.getY()), Math.abs(point.getZ()));
        double factor = Math.pow(2.0, -1 - Platform.getExponent(pmax));
        return point.mul(factor);
    }

    private static S2Point normalizableFromReal(S2Point point) {
        if (S2RobustCrossProd.isNormalizable(point)) {
            return point;
        }
        double largestAbs = Doubles.max(Math.abs(point.getX()), Math.abs(point.getY()), Math.abs(point.getZ()));
        return new S2Point(point.getX() / largestAbs, point.getY() / largestAbs, point.getZ() / largestAbs);
    }

    private static S2Point normalizeFromBigDecimal(BigDecimal x, BigDecimal y, BigDecimal z) {
        S2Point noScaling = new S2Point(x.doubleValue(), y.doubleValue(), z.doubleValue());
        if (S2RobustCrossProd.isNormalizable(noScaling)) {
            return noScaling;
        }
        int xExponent = -x.stripTrailingZeros().scale() + (x.stripTrailingZeros().precision() - 1);
        int yExponent = -y.stripTrailingZeros().scale() + (y.stripTrailingZeros().precision() - 1);
        int zExponent = -z.stripTrailingZeros().scale() + (z.stripTrailingZeros().precision() - 1);
        int maxExponent = Integer.MIN_VALUE;
        if (x.signum() != 0) {
            maxExponent = Math.max(maxExponent, xExponent);
        }
        if (y.signum() != 0) {
            maxExponent = Math.max(maxExponent, yExponent);
        }
        if (z.signum() != 0) {
            maxExponent = Math.max(maxExponent, zExponent);
        }
        if (maxExponent == Integer.MIN_VALUE) {
            return S2Point.ORIGIN;
        }
        double scaledX = x.scaleByPowerOfTen(-maxExponent - 1).doubleValue();
        double scaledY = y.scaleByPowerOfTen(-maxExponent - 1).doubleValue();
        double scaledZ = z.scaleByPowerOfTen(-maxExponent - 1).doubleValue();
        return new S2Point(scaledX, scaledY, scaledZ);
    }

    private static boolean isNormalizable(S2Point point) {
        return Doubles.max(Math.abs(point.getX()), Math.abs(point.getY()), Math.abs(point.getZ())) >= Math.pow(2.0, -242.0);
    }

    private S2RobustCrossProd() {
    }
}

