/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.geoparquet.Covering;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.geoparquet.GeometryFieldMetaData;
import org.apache.spark.sql.sedona_sql.io.stac.StacBatch$;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartition;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartitionReader;
import org.apache.spark.sql.sedona_sql.io.stac.StacUtils$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.json4s.JsonAST;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple8;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001\u0002\u001f>\u00012C\u0001B\u001a\u0001\u0003\u0016\u0004%\ta\u001a\u0005\ti\u0002\u0011\t\u0012)A\u0005Q\"AQ\u000f\u0001BK\u0002\u0013\u0005a\u000fC\u0005\u0002\u0006\u0001\u0011\t\u0012)A\u0005o\"I\u0011q\u0001\u0001\u0003\u0016\u0004%\tA\u001e\u0005\n\u0003\u0013\u0001!\u0011#Q\u0001\n]D!\"a\u0003\u0001\u0005+\u0007I\u0011AA\u0007\u0011)\tY\u0002\u0001B\tB\u0003%\u0011q\u0002\u0005\u000b\u0003;\u0001!Q3A\u0005\u0002\u0005}\u0001BCA\u0014\u0001\tE\t\u0015!\u0003\u0002\"!Q\u0011\u0011\u0006\u0001\u0003\u0016\u0004%\t!a\u000b\t\u0015\u0005\u001d\u0003A!E!\u0002\u0013\ti\u0003\u0003\u0006\u0002J\u0001\u0011)\u001a!C\u0001\u0003\u0017B!\"!\u0018\u0001\u0005#\u0005\u000b\u0011BA'\u0011)\ty\u0006\u0001BK\u0002\u0013\u0005\u0011\u0011\r\u0005\u000b\u0003W\u0002!\u0011#Q\u0001\n\u0005\r\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\n\u0003\u000b\u0003!\u0019!C\u0005\u0003\u000fC\u0001\"!#\u0001A\u0003%\u0011Q\r\u0005\n\u0003\u0017\u0003!\u0019!C\u0005\u0003\u000fC\u0001\"!$\u0001A\u0003%\u0011Q\r\u0005\n\u0003\u001f\u0003\u0001\u0019!C\u0005\u0003\u000fC\u0011\"!%\u0001\u0001\u0004%I!a%\t\u0011\u0005}\u0005\u0001)Q\u0005\u0003KB\u0011\"!)\u0001\u0001\u0004%I!a\"\t\u0013\u0005\r\u0006\u00011A\u0005\n\u0005\u0015\u0006\u0002CAU\u0001\u0001\u0006K!!\u001a\t\u0013\u0005-\u0006A1A\u0005\u0002\u00055\u0006\u0002CAd\u0001\u0001\u0006I!a,\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"9\u0011\u0011\u001b\u0001\u0005B\u0005M\u0007bBAq\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057AqAa\t\u0001\t\u0003\u0012)\u0003C\u0005\u0003.\u0001\t\t\u0011\"\u0001\u00030!I!\u0011\t\u0001\u0012\u0002\u0013\u0005!1\t\u0005\n\u00053\u0002\u0011\u0013!C\u0001\u00057B\u0011Ba\u0018\u0001#\u0003%\tAa\u0017\t\u0013\t\u0005\u0004!%A\u0005\u0002\t\r\u0004\"\u0003B4\u0001E\u0005I\u0011\u0001B5\u0011%\u0011i\u0007AI\u0001\n\u0003\u0011y\u0007C\u0005\u0003t\u0001\t\n\u0011\"\u0001\u0003v!I!\u0011\u0010\u0001\u0012\u0002\u0013\u0005!1\u0010\u0005\n\u0005\u007f\u0002\u0011\u0011!C!\u0005\u0003C\u0011Ba\"\u0001\u0003\u0003%\t!a\"\t\u0013\t%\u0005!!A\u0005\u0002\t-\u0005\"\u0003BK\u0001\u0005\u0005I\u0011\tBL\u0011%\u0011\t\u000bAA\u0001\n\u0003\u0011\u0019\u000bC\u0005\u0003(\u0002\t\t\u0011\"\u0011\u0003*\"I!1\u0016\u0001\u0002\u0002\u0013\u0005#Q\u0016\u0005\n\u0005_\u0003\u0011\u0011!C!\u0005c;\u0011B!.>\u0003\u0003E\tAa.\u0007\u0011qj\u0014\u0011!E\u0001\u0005sCq!!\u001c7\t\u0003\u00119\rC\u0005\u0003,Z\n\t\u0011\"\u0012\u0003.\"I!\u0011\u001a\u001c\u0002\u0002\u0013\u0005%1\u001a\u0005\n\u0005;4\u0014\u0011!CA\u0005?D\u0011B!<7\u0003\u0003%IAa<\u0003\u0013M#\u0018m\u0019\"bi\u000eD'B\u0001 @\u0003\u0011\u0019H/Y2\u000b\u0005\u0001\u000b\u0015AA5p\u0015\t\u00115)\u0001\u0006tK\u0012|g.Y0tc2T!\u0001R#\u0002\u0007M\fHN\u0003\u0002G\u000f\u0006)1\u000f]1sW*\u0011\u0001*S\u0001\u0007CB\f7\r[3\u000b\u0003)\u000b1a\u001c:h\u0007\u0001\u0019R\u0001A'V;\u000e\u0004\"AT*\u000e\u0003=S!\u0001U)\u0002\t1\fgn\u001a\u0006\u0002%\u0006!!.\u0019<b\u0013\t!vJ\u0001\u0004PE*,7\r\u001e\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bAA]3bI*\u0011!lQ\u0001\nG>tg.Z2u_JL!\u0001X,\u0003\u000b\t\u000bGo\u00195\u0011\u0005y\u000bW\"A0\u000b\u0003\u0001\fQa]2bY\u0006L!AY0\u0003\u000fA\u0013x\u000eZ;diB\u0011a\fZ\u0005\u0003K~\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fQB\u0019:pC\u0012\u001c\u0017m\u001d;D_:4W#\u00015\u0011\u0007%dg.D\u0001k\u0015\tYW)A\u0005ce>\fGmY1ti&\u0011QN\u001b\u0002\n\u0005J|\u0017\rZ2bgR\u0004\"a\u001c:\u000e\u0003AT!!]#\u0002\tU$\u0018\u000e\\\u0005\u0003gB\u0014\u0011dU3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006q!M]8bI\u000e\f7\u000f^\"p]\u001a\u0004\u0013!E:uC\u000e\u001cu\u000e\u001c7fGRLwN\\+sYV\tq\u000f\u0005\u0002y\u007f:\u0011\u00110 \t\u0003u~k\u0011a\u001f\u0006\u0003y.\u000ba\u0001\u0010:p_Rt\u0014B\u0001@`\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011AA\u0002\u0005\u0019\u0019FO]5oO*\u0011apX\u0001\u0013gR\f7mQ8mY\u0016\u001cG/[8o+Jd\u0007%\u0001\nti\u0006\u001c7i\u001c7mK\u000e$\u0018n\u001c8Kg>t\u0017aE:uC\u000e\u001cu\u000e\u001c7fGRLwN\u001c&t_:\u0004\u0013AB:dQ\u0016l\u0017-\u0006\u0002\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\r\u000bQ\u0001^=qKNLA!!\u0007\u0002\u0014\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u000fM\u001c\u0007.Z7bA\u0005!q\u000e\u001d;t+\t\t\t\u0003E\u0003y\u0003G9x/\u0003\u0003\u0002&\u0005\r!aA'ba\u0006)q\u000e\u001d;tA\u0005i1\u000f]1uS\u0006dg)\u001b7uKJ,\"!!\f\u0011\u000by\u000by#a\r\n\u0007\u0005ErL\u0001\u0004PaRLwN\u001c\t\u0005\u0003k\t\u0019%\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003)9Wm\u001c9beF,X\r\u001e\u0006\u0005\u0003{\ty$A\u0006eCR\f7o\\;sG\u0016\u001c(bAA!\u0007\u0006IQ\r_3dkRLwN\\\u0005\u0005\u0003\u000b\n9DA\fHK>\u0004\u0016M]9vKR\u001c\u0006/\u0019;jC24\u0015\u000e\u001c;fe\u0006q1\u000f]1uS\u0006dg)\u001b7uKJ\u0004\u0013A\u0004;f[B|'/\u00197GS2$XM]\u000b\u0003\u0003\u001b\u0002RAXA\u0018\u0003\u001f\u0002B!!\u0015\u0002Z5\u0011\u00111\u000b\u0006\u0004}\u0005U#\u0002BA,\u0003\u007f\t!\u0002Z1uCN|WO]2f\u0013\u0011\tY&a\u0015\u0003\u001dQ+W\u000e]8sC24\u0015\u000e\u001c;fe\u0006yA/Z7q_J\fGNR5mi\u0016\u0014\b%A\u0006mS6LGOR5mi\u0016\u0014XCAA2!\u0015q\u0016qFA3!\rq\u0016qM\u0005\u0004\u0003Sz&aA%oi\u0006aA.[7ji\u001aKG\u000e^3sA\u00051A(\u001b8jiz\"\"#!\u001d\u0002v\u0005]\u0014\u0011PA>\u0003{\ny(!!\u0002\u0004B\u0019\u00111\u000f\u0001\u000e\u0003uBQAZ\tA\u0002!DQ!^\tA\u0002]Da!a\u0002\u0012\u0001\u00049\bbBA\u0006#\u0001\u0007\u0011q\u0002\u0005\b\u0003;\t\u0002\u0019AA\u0011\u0011\u001d\tI#\u0005a\u0001\u0003[Aq!!\u0013\u0012\u0001\u0004\ti\u0005C\u0004\u0002`E\u0001\r!a\u0019\u00027\u0011,g-Y;mi&#X-\\:MS6LG\u000fU3s%\u0016\fX/Z:u+\t\t)'\u0001\u000feK\u001a\fW\u000f\u001c;Ji\u0016l7\u000fT5nSR\u0004VM\u001d*fcV,7\u000f\u001e\u0011\u0002?%$X-\\:M_\u0006$\u0007K]8dKN\u001c(+\u001a9peR$\u0006N]3tQ>dG-\u0001\u0011ji\u0016l7\u000fT8bIB\u0013xnY3tgJ+\u0007o\u001c:u)\"\u0014Xm\u001d5pY\u0012\u0004\u0013aC5uK6l\u0015\r\u001f'fMR\fq\"\u001b;f[6\u000b\u0007\u0010T3gi~#S-\u001d\u000b\u0005\u0003+\u000bY\nE\u0002_\u0003/K1!!'`\u0005\u0011)f.\u001b;\t\u0013\u0005uu#!AA\u0002\u0005\u0015\u0014a\u0001=%c\u0005a\u0011\u000e^3n\u001b\u0006DH*\u001a4uA\u0005yA.Y:u%\u0016\u0004xN\u001d;D_VtG/A\nmCN$(+\u001a9peR\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0006\u001d\u0006\"CAO5\u0005\u0005\t\u0019AA3\u0003Aa\u0017m\u001d;SKB|'\u000f^\"pk:$\b%\u0001\u0004nCB\u0004XM]\u000b\u0003\u0003_\u0003B!!-\u0002D6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,\u0001\u0005eCR\f'-\u001b8e\u0015\u0011\tI,a/\u0002\u000f)\f7m[:p]*!\u0011QXA`\u0003%1\u0017m\u001d;feblGN\u0003\u0002\u0002B\u0006\u00191m\\7\n\t\u0005\u0015\u00171\u0017\u0002\r\u001f\nTWm\u0019;NCB\u0004XM]\u0001\b[\u0006\u0004\b/\u001a:!\u00039\u0019X\r^%uK6l\u0015\r\u001f'fMR$B!!&\u0002N\"9\u0011q\u001a\u0010A\u0002\u0005\u0015\u0014!\u0002<bYV,\u0017a\u00059mC:Le\u000e];u!\u0006\u0014H/\u001b;j_:\u001cHCAAk!\u0015q\u0016q[An\u0013\r\tIn\u0018\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004-\u0006u\u0017bAAp/\nq\u0011J\u001c9viB\u000b'\u000f^5uS>t\u0017\u0001E2pY2,7\r^%uK6d\u0015N\\6t))\t)*!:\u0002j\u00065(\u0011\u0001\u0005\u0007\u0003O\u0004\u0003\u0019A<\u0002%\r|G\u000e\\3di&|gNQ1tKB\u000bG\u000f\u001b\u0005\u0007\u0003W\u0004\u0003\u0019A<\u0002\u001d\r|G\u000e\\3di&|gNS:p]\"9\u0011q\u001e\u0011A\u0002\u0005E\u0018!C5uK6d\u0015N\\6t!\u0015\t\u00190!@x\u001b\t\t)P\u0003\u0003\u0002x\u0006e\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003w|\u0016AC2pY2,7\r^5p]&!\u0011q`A{\u0005-\t%O]1z\u0005V4g-\u001a:\t\u000f\t\r\u0001\u00051\u0001\u0003\u0006\u0005\u0011b.Z3e\u0007>,h\u000e\u001e(fqRLE/Z7t!\rq&qA\u0005\u0004\u0005\u0013y&a\u0002\"p_2,\u0017M\\\u0001\fO\u0016$\u0018\n^3n\u0019&t7\u000eF\u0005x\u0005\u001f\u0011\u0019B!\u0006\u0003\u0018!1!\u0011C\u0011A\u0002]\fq!\u001b;f[V\u0013H\u000eC\u0004\u0002\u0006\u0006\u0002\r!!\u001a\t\u000f\u0005%\u0012\u00051\u0001\u0002.!9\u0011\u0011J\u0011A\u0002\u00055\u0013\u0001\u00054jYR,'oQ8mY\u0016\u001cG/[8o)!\u0011)A!\b\u0003 \t\u0005\u0002BBAvE\u0001\u0007q\u000fC\u0004\u0002*\t\u0002\r!!\f\t\u000f\u0005%#\u00051\u0001\u0002N\u0005\u00192M]3bi\u0016\u0014V-\u00193fe\u001a\u000b7\r^8ssR\u0011!q\u0005\t\u0004-\n%\u0012b\u0001B\u0016/\n1\u0002+\u0019:uSRLwN\u001c*fC\u0012,'OR1di>\u0014\u00180\u0001\u0003d_BLHCEA9\u0005c\u0011\u0019D!\u000e\u00038\te\"1\bB\u001f\u0005\u007fAqA\u001a\u0013\u0011\u0002\u0003\u0007\u0001\u000eC\u0004vIA\u0005\t\u0019A<\t\u0011\u0005\u001dA\u0005%AA\u0002]D\u0011\"a\u0003%!\u0003\u0005\r!a\u0004\t\u0013\u0005uA\u0005%AA\u0002\u0005\u0005\u0002\"CA\u0015IA\u0005\t\u0019AA\u0017\u0011%\tI\u0005\nI\u0001\u0002\u0004\ti\u0005C\u0005\u0002`\u0011\u0002\n\u00111\u0001\u0002d\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B#U\rA'qI\u0016\u0003\u0005\u0013\u0002BAa\u0013\u0003V5\u0011!Q\n\u0006\u0005\u0005\u001f\u0012\t&A\u0005v]\u000eDWmY6fI*\u0019!1K0\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003X\t5#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B/U\r9(qI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"A!\u001a+\t\u0005=!qI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011YG\u000b\u0003\u0002\"\t\u001d\u0013AD2paf$C-\u001a4bk2$HEN\u000b\u0003\u0005cRC!!\f\u0003H\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012:TC\u0001B<U\u0011\tiEa\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%qU\u0011!Q\u0010\u0016\u0005\u0003G\u00129%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0007\u00032A\u0014BC\u0013\r\t\taT\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011iIa%\u0011\u0007y\u0013y)C\u0002\u0003\u0012~\u00131!\u00118z\u0011%\tijLA\u0001\u0002\u0004\t)'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\n\u0005\u0004\u0003\u001c\nu%QR\u0007\u0003\u0003sLAAa(\u0002z\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011)A!*\t\u0013\u0005u\u0015'!AA\u0002\t5\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u0015\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\r\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0003\u0006\tM\u0006\"CAOi\u0005\u0005\t\u0019\u0001BG\u0003%\u0019F/Y2CCR\u001c\u0007\u000eE\u0002\u0002tY\u001aBA\u000eB^GB\u0019\"Q\u0018BbQ^<\u0018qBA\u0011\u0003[\ti%a\u0019\u0002r5\u0011!q\u0018\u0006\u0004\u0005\u0003|\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005\u000b\u0014yLA\tBEN$(/Y2u\rVt7\r^5p]b\"\"Aa.\u0002\u000b\u0005\u0004\b\u000f\\=\u0015%\u0005E$Q\u001aBh\u0005#\u0014\u0019N!6\u0003X\ne'1\u001c\u0005\u0006Mf\u0002\r\u0001\u001b\u0005\u0006kf\u0002\ra\u001e\u0005\u0007\u0003\u000fI\u0004\u0019A<\t\u000f\u0005-\u0011\b1\u0001\u0002\u0010!9\u0011QD\u001dA\u0002\u0005\u0005\u0002bBA\u0015s\u0001\u0007\u0011Q\u0006\u0005\b\u0003\u0013J\u0004\u0019AA'\u0011\u001d\ty&\u000fa\u0001\u0003G\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003b\n%\b#\u00020\u00020\t\r\b\u0003\u00050\u0003f\"<x/a\u0004\u0002\"\u00055\u0012QJA2\u0013\r\u00119o\u0018\u0002\u0007)V\u0004H.\u001a\u001d\t\u0013\t-((!AA\u0002\u0005E\u0014a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005i\u0005")
public class StacBatch
implements Batch,
Product,
scala.Serializable {
    private final Broadcast<SerializableConfiguration> broadcastConf;
    private final String stacCollectionUrl;
    private final String stacCollectionJson;
    private final StructType schema;
    private final Map<String, String> opts;
    private final Option<GeoParquetSpatialFilter> spatialFilter;
    private final Option<TemporalFilter> temporalFilter;
    private final Option<Object> limitFilter;
    private final int defaultItemsLimitPerRequest;
    private final int itemsLoadProcessReportThreshold;
    private int itemMaxLeft;
    private int lastReportCount;
    private final ObjectMapper mapper;

    public static Option<Tuple8<Broadcast<SerializableConfiguration>, String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>, Option<Object>>> unapply(StacBatch stacBatch) {
        return StacBatch$.MODULE$.unapply(stacBatch);
    }

    public static StacBatch apply(Broadcast<SerializableConfiguration> broadcast, String string, String string2, StructType structType, Map<String, String> map, Option<GeoParquetSpatialFilter> option, Option<TemporalFilter> option2, Option<Object> option3) {
        return StacBatch$.MODULE$.apply(broadcast, string, string2, structType, map, option, option2, option3);
    }

    public static Function1<Tuple8<Broadcast<SerializableConfiguration>, String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>, Option<Object>>, StacBatch> tupled() {
        return StacBatch$.MODULE$.tupled();
    }

    public static Function1<Broadcast<SerializableConfiguration>, Function1<String, Function1<String, Function1<StructType, Function1<Map<String, String>, Function1<Option<GeoParquetSpatialFilter>, Function1<Option<TemporalFilter>, Function1<Option<Object>, StacBatch>>>>>>>> curried() {
        return StacBatch$.MODULE$.curried();
    }

    public Broadcast<SerializableConfiguration> broadcastConf() {
        return this.broadcastConf;
    }

    public String stacCollectionUrl() {
        return this.stacCollectionUrl;
    }

    public String stacCollectionJson() {
        return this.stacCollectionJson;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> opts() {
        return this.opts;
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    public Option<TemporalFilter> temporalFilter() {
        return this.temporalFilter;
    }

    public Option<Object> limitFilter() {
        return this.limitFilter;
    }

    private int defaultItemsLimitPerRequest() {
        return this.defaultItemsLimitPerRequest;
    }

    private int itemsLoadProcessReportThreshold() {
        return this.itemsLoadProcessReportThreshold;
    }

    private int itemMaxLeft() {
        return this.itemMaxLeft;
    }

    private void itemMaxLeft_$eq(int x$1) {
        this.itemMaxLeft = x$1;
    }

    private int lastReportCount() {
        return this.lastReportCount;
    }

    private void lastReportCount_$eq(int x$1) {
        this.lastReportCount = x$1;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public void setItemMaxLeft(int value) {
        this.itemMaxLeft_$eq(value);
    }

    public InputPartition[] planInputPartitions() {
        Some some;
        int limit;
        String stacCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(this.stacCollectionUrl());
        ArrayBuffer itemLinks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option<Object> option = this.limitFilter();
        int n = option instanceof Some && (limit = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value())) >= 0 ? limit : new StringOps(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"itemsLimitMax", (Function0 & Serializable & scala.Serializable)() -> "-1"))).toInt();
        int itemsLimitMax = n;
        boolean checkItemsLimitMax = itemsLimitMax > 0;
        this.setItemMaxLeft(itemsLimitMax);
        this.collectItemLinks(stacCollectionBasePath, this.stacCollectionJson(), (ArrayBuffer<String>)itemLinks, checkItemsLimitMax);
        if (itemLinks.isEmpty()) {
            return (InputPartition[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int numPartitions = StacUtils$.MODULE$.getNumPartitions(itemLinks.length(), new StringOps(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"numPartitions", (Function0 & Serializable & scala.Serializable)() -> "-1"))).toInt(), new StringOps(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"maxPartitionItemFiles", (Function0 & Serializable & scala.Serializable)() -> "-1"))).toInt(), new StringOps(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"defaultParallelism", (Function0 & Serializable & scala.Serializable)() -> "1"))).toInt());
        if (itemLinks.length() < numPartitions) {
            return (InputPartition[])((TraversableOnce)((TraversableLike)itemLinks.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String item = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                StacPartition stacPartition = new StacPartition(index, (String[])((Object[])new String[]{item}), new HashMap<String, String>());
                return stacPartition;
            }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int partitionSize = (int)Math.ceil((double)itemLinks.length() / (double)numPartitions);
        return (InputPartition[])((IterableLike)Random$.MODULE$.shuffle((TraversableOnce)itemLinks, ArrayBuffer$.MODULE$.canBuildFrom())).grouped(partitionSize).zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ArrayBuffer items = (ArrayBuffer)tuple2._1();
            int index = tuple2._2$mcI$sp();
            StacPartition stacPartition = new StacPartition(index, (String[])items.toArray(ClassTag$.MODULE$.apply(String.class)), new HashMap<String, String>());
            return stacPartition;
        }).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public void collectItemLinks(String collectionBasePath, String collectionJson, ArrayBuffer<String> itemLinks, boolean needCountNextItems) {
        if (needCountNextItems && this.itemMaxLeft() <= 0) {
            return;
        }
        if (itemLinks.size() - this.lastReportCount() >= this.itemsLoadProcessReportThreshold()) {
            Console$.MODULE$.out().println(new StringBuilder(38).append("Searched or partitioned ").append(itemLinks.size()).append(" items so far.").toString());
            this.lastReportCount_$eq(itemLinks.size());
        }
        JsonNode rootNode = this.mapper().readTree(collectionJson);
        JsonNode linksNode = rootNode.get("links");
        java.util.Iterator iterator = linksNode.elements();
        while (iterator.hasNext()) {
            String href;
            String rel;
            block9: {
                block8: {
                    JsonNode linkNode = (JsonNode)iterator.next();
                    rel = linkNode.get("rel").asText();
                    href = linkNode.get("href").asText();
                    String string = rel;
                    String string2 = "item";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block8;
                    String string3 = rel;
                    String string4 = "items";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block9;
                }
                String itemUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
                String string = rel;
                String string5 = "items";
                ArrayBuffer arrayBuffer = !(string != null ? !string.equals(string5) : string5 != null) && href.startsWith("http") ? itemLinks.$plus$eq((Object)new StringBuilder(7).append(itemUrl).append("?limit=").append(this.defaultItemsLimitPerRequest()).toString()) : itemLinks.$plus$eq((Object)itemUrl);
                if (needCountNextItems && this.itemMaxLeft() <= 0) {
                    return;
                }
                String string6 = rel;
                String string7 = "item";
                if (!(string6 != null ? !string6.equals(string7) : string7 != null) && needCountNextItems) {
                    this.itemMaxLeft_$eq(this.itemMaxLeft() - 1);
                    continue;
                }
                String string8 = rel;
                String string9 = "items";
                if (string8 != null ? !string8.equals(string9) : string9 != null) continue;
                if (!href.startsWith("http") || !this.iterateItemsWithLimit$1(this.getItemLink(itemUrl, this.defaultItemsLimitPerRequest(), this.spatialFilter(), this.temporalFilter()), needCountNextItems, collectionBasePath, itemLinks)) continue;
                return;
            }
            String string = rel;
            String string10 = "child";
            if (string != null ? !string.equals(string10) : string10 != null) continue;
            String childUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
            String linkedCollectionJson = StacUtils$.MODULE$.loadStacCollectionToJson(childUrl, StacUtils$.MODULE$.loadStacCollectionToJson$default$2());
            String nestedCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(childUrl);
            boolean collectionFiltered = this.filterCollection(linkedCollectionJson, this.spatialFilter(), this.temporalFilter());
            if (collectionFiltered) continue;
            this.collectItemLinks(nestedCollectionBasePath, linkedCollectionJson, itemLinks, needCountNextItems);
        }
    }

    public String getItemLink(String itemUrl, int defaultItemsLimitPerRequest, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        String baseUrl = new StringBuilder(7).append(itemUrl).append("?limit=").append(defaultItemsLimitPerRequest).toString();
        String urlWithFilters = StacUtils$.MODULE$.addFiltersToUrl(baseUrl, spatialFilter, temporalFilter);
        return urlWithFilters;
    }

    public boolean filterCollection(String collectionJson, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        boolean bl;
        boolean bl2;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(collectionJson);
        Option<GeoParquetSpatialFilter> option = spatialFilter;
        if (option instanceof Some) {
            List bbox;
            Some some = (Some)option;
            GeoParquetSpatialFilter filter = (GeoParquetSpatialFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("spatial").path("bbox");
            bl2 = extentNode.isMissingNode() ? false : !(bbox = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(extentNode.elements()).asScala()).map((Function1 & Serializable & scala.Serializable)bboxNode -> {
                double minX = bboxNode.get(0).asDouble();
                double minY = bboxNode.get(1).asDouble();
                double maxX = bboxNode.get(2).asDouble();
                double maxY = bboxNode.get(3).asDouble();
                return new Tuple4((Object)BoxesRunTime.boxToDouble((double)minX), (Object)BoxesRunTime.boxToDouble((double)minY), (Object)BoxesRunTime.boxToDouble((double)maxX), (Object)BoxesRunTime.boxToDouble((double)maxY));
            }).toList()).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$2(filter, x0$1)));
        } else if (None$.MODULE$.equals(option)) {
            bl2 = false;
        } else {
            throw new MatchError(option);
        }
        boolean spatialFiltered = bl2;
        Option<TemporalFilter> option2 = temporalFilter;
        if (option2 instanceof Some) {
            boolean bl3;
            Some some = (Some)option2;
            TemporalFilter filter = (TemporalFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("temporal").path("interval");
            if (extentNode.isMissingNode()) {
                bl3 = true;
            } else {
                DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).optionalEnd().appendPattern("'Z'").toFormatter();
                List intervals = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(extentNode.elements()).asScala()).map((Function1 & Serializable & scala.Serializable)intervalNode -> {
                    LocalDateTime start = LocalDateTime.parse(intervalNode.get(0).asText(), formatter);
                    LocalDateTime end = LocalDateTime.parse(intervalNode.get(1).asText(), formatter);
                    return new Tuple2((Object)start, (Object)end);
                }).toList();
                bl3 = !intervals.exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$4(filter, x0$2)));
            }
            bl = bl3;
        } else if (None$.MODULE$.equals(option2)) {
            bl = false;
        } else {
            throw new MatchError(option2);
        }
        boolean temporalFiltered = bl;
        return spatialFiltered || temporalFiltered;
    }

    public PartitionReaderFactory createReaderFactory() {
        return (PartitionReaderFactory & Serializable)partition -> new StacPartitionReader(this.broadcastConf(), (StacPartition)partition, this.schema(), this.opts(), this.spatialFilter(), this.temporalFilter());
    }

    public StacBatch copy(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        return new StacBatch(broadcastConf, stacCollectionUrl, stacCollectionJson, schema, opts, spatialFilter, temporalFilter, limitFilter);
    }

    public Broadcast<SerializableConfiguration> copy$default$1() {
        return this.broadcastConf();
    }

    public String copy$default$2() {
        return this.stacCollectionUrl();
    }

    public String copy$default$3() {
        return this.stacCollectionJson();
    }

    public StructType copy$default$4() {
        return this.schema();
    }

    public Map<String, String> copy$default$5() {
        return this.opts();
    }

    public Option<GeoParquetSpatialFilter> copy$default$6() {
        return this.spatialFilter();
    }

    public Option<TemporalFilter> copy$default$7() {
        return this.temporalFilter();
    }

    public Option<Object> copy$default$8() {
        return this.limitFilter();
    }

    public String productPrefix() {
        return "StacBatch";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.broadcastConf();
                break;
            }
            case 1: {
                object = this.stacCollectionUrl();
                break;
            }
            case 2: {
                object = this.stacCollectionJson();
                break;
            }
            case 3: {
                object = this.schema();
                break;
            }
            case 4: {
                object = this.opts();
                break;
            }
            case 5: {
                object = this.spatialFilter();
                break;
            }
            case 6: {
                object = this.temporalFilter();
                break;
            }
            case 7: {
                object = this.limitFilter();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StacBatch;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StacBatch)) return false;
        boolean bl = true;
        if (!bl) return false;
        StacBatch stacBatch = (StacBatch)x$1;
        Broadcast<SerializableConfiguration> broadcast = this.broadcastConf();
        Broadcast<SerializableConfiguration> broadcast2 = stacBatch.broadcastConf();
        if (broadcast == null) {
            if (broadcast2 != null) {
                return false;
            }
        } else if (!broadcast.equals(broadcast2)) return false;
        String string = this.stacCollectionUrl();
        String string2 = stacBatch.stacCollectionUrl();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.stacCollectionJson();
        String string4 = stacBatch.stacCollectionJson();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        StructType structType = this.schema();
        StructType structType2 = stacBatch.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        Map<String, String> map = this.opts();
        Map<String, String> map2 = stacBatch.opts();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<GeoParquetSpatialFilter> option = this.spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = stacBatch.spatialFilter();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<TemporalFilter> option3 = this.temporalFilter();
        Option<TemporalFilter> option4 = stacBatch.temporalFilter();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Object> option5 = this.limitFilter();
        Option<Object> option6 = stacBatch.limitFilter();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!stacBatch.canEqual(this)) return false;
        return true;
    }

    private final boolean iterateItemsWithLimit$1(String itemUrl, boolean needCountNextItems, String collectionBasePath$1, ArrayBuffer itemLinks$1) {
        boolean bl;
        Object object = new Object();
        try {
            ObjectRef nextUrl = ObjectRef.create((Object)new Some((Object)itemUrl));
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                while (((Option)nextUrl$1.elem).isDefined()) {
                    String itemJson = StacUtils$.MODULE$.loadStacCollectionToJson((String)((Option)nextUrl$1.elem).get(), StacUtils$.MODULE$.loadStacCollectionToJson$default$2());
                    JsonNode itemRootNode = this.mapper().readTree(itemJson);
                    JsonNode itemLinksNode = itemRootNode.get("links");
                    if (itemLinksNode == null) {
                        throw new NonLocalReturnControl.mcZ.sp(object, true);
                    }
                    java.util.Iterator itemIterator = itemLinksNode.elements();
                    nextUrl$1.elem = None$.MODULE$;
                    while (itemIterator.hasNext()) {
                        JsonNode itemLinkNode = (JsonNode)itemIterator.next();
                        String itemRel = itemLinkNode.get("rel").asText();
                        String itemHref = itemLinkNode.get("href").asText();
                        String string = itemRel;
                        String string2 = "next";
                        if (string != null ? !string.equals(string2) : string2 != null) continue;
                        JsonNode numberReturnedNode = itemRootNode.get("numberReturned");
                        int numberReturned = numberReturnedNode == null ? this.defaultItemsLimitPerRequest() : numberReturnedNode.asInt();
                        this.itemMaxLeft_$eq(this.itemMaxLeft() - numberReturned);
                        if (needCountNextItems && this.itemMaxLeft() <= 0) {
                            throw new NonLocalReturnControl.mcZ.sp(object, true);
                        }
                        nextUrl$1.elem = new Some((Object)(itemHref.startsWith("http") || itemHref.startsWith("file") ? itemHref : new StringBuilder(0).append(collectionBasePath$1).append(itemHref).toString()));
                    }
                    Object object = ((Option)nextUrl$1.elem).isDefined() ? itemLinks$1.$plus$eq(((Option)nextUrl$1.elem).get()) : BoxedUnit.UNIT;
                }
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$2(GeoParquetSpatialFilter filter$1, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        double minX = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double minY = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double maxX = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double maxY = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Seq geometryTypes = (Seq)new .colon.colon((Object)"Polygon", (List)Nil$.MODULE$);
        Seq bbox = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{minX, minY, maxX, maxY}));
        GeometryFieldMetaData geometryFieldMetaData = new GeometryFieldMetaData("WKB", (Seq<String>)geometryTypes, (Seq<Object>)bbox, (Option<JsonAST.JValue>)None$.MODULE$, (Option<Covering>)None$.MODULE$);
        boolean bl = filter$1.evaluate((Map<String, GeometryFieldMetaData>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"geometry"), (Object)geometryFieldMetaData)}))));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$4(TemporalFilter filter$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LocalDateTime start = (LocalDateTime)tuple2._1();
        LocalDateTime end = (LocalDateTime)tuple2._2();
        boolean bl = filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)start)})))) || filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)end)}))));
        return bl;
    }

    public StacBatch(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        this.broadcastConf = broadcastConf;
        this.stacCollectionUrl = stacCollectionUrl;
        this.stacCollectionJson = stacCollectionJson;
        this.schema = schema;
        this.opts = opts;
        this.spatialFilter = spatialFilter;
        this.temporalFilter = temporalFilter;
        this.limitFilter = limitFilter;
        Product.$init$((Product)this);
        int itemsLimitMax = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitMax", (Function0 & Serializable & scala.Serializable)() -> "-1"))).toInt();
        int limitPerRequest = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitPerRequest", (Function0 & Serializable & scala.Serializable)() -> "10"))).toInt();
        this.defaultItemsLimitPerRequest = itemsLimitMax > 0 && limitPerRequest > itemsLimitMax ? itemsLimitMax : limitPerRequest;
        this.itemsLoadProcessReportThreshold = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLoadProcessReportThreshold", (Function0 & Serializable & scala.Serializable)() -> "1000000"))).toInt();
        this.itemMaxLeft = -1;
        this.lastReportCount = 0;
        this.mapper = new ObjectMapper();
    }
}

