/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.LittleEndianInput;
import org.apache.sedona.shaded.s2.LittleEndianOutput;
import org.apache.sedona.shaded.s2.PrimitiveArrays;
import org.apache.sedona.shaded.s2.S2;
import org.apache.sedona.shaded.s2.S2Cap;
import org.apache.sedona.shaded.s2.S2Cell;
import org.apache.sedona.shaded.s2.S2Coder;
import org.apache.sedona.shaded.s2.S2LatLng;
import org.apache.sedona.shaded.s2.S2LatLngRect;
import org.apache.sedona.shaded.s2.S2PointVectorCoder;
import org.apache.sedona.shaded.s2.S2Region;
import org.apache.sedona.shaded.s2.S2Shape;

@JsType
@Immutable
public final class S2Point
implements S2Region,
Comparable<S2Point>,
Serializable {
    public static final S2Point ORIGIN = new S2Point(0.0, 0.0, 0.0);
    public static final S2Point X_POS = new S2Point(1.0, 0.0, 0.0);
    public static final S2Point X_NEG = new S2Point(-1.0, 0.0, 0.0);
    public static final S2Point Y_POS = new S2Point(0.0, 1.0, 0.0);
    public static final S2Point Y_NEG = new S2Point(0.0, -1.0, 0.0);
    public static final S2Point Z_POS = new S2Point(0.0, 0.0, 1.0);
    public static final S2Point Z_NEG = new S2Point(0.0, 0.0, -1.0);
    public static final S2Coder<S2Point> CODER = new S2Coder<S2Point>(){

        @Override
        @JsIgnore
        public void encode(S2Point value, OutputStream output) throws IOException {
            value.encode(output);
        }

        @Override
        public S2Point decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
            return S2Point.decode(data.toInputStream(cursor));
        }

        @Override
        public boolean isLazy() {
            return false;
        }
    };
    final double x;
    final double y;
    final double z;

    @JsIgnore
    public S2Point() {
        this(0.0, 0.0, 0.0);
    }

    @JsConstructor
    public S2Point(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @JsIgnore
    public S2Point(double[] vec) {
        this(vec[0], vec[1], vec[2]);
    }

    public void fill(double[] vec) {
        vec[0] = this.x;
        vec[1] = this.y;
        vec[2] = this.z;
    }

    public final double get(int axis) {
        return axis == 0 ? this.x : (axis == 1 ? this.y : this.z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public S2Point add(S2Point p) {
        return S2Point.add(this, p);
    }

    @JsIgnore
    public static final S2Point add(S2Point p1, S2Point p2) {
        return new S2Point(p1.x + p2.x, p1.y + p2.y, p1.z + p2.z);
    }

    @JsIgnore
    public static final S2Point sum(S2Point ... points) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (S2Point p : points) {
            x += p.x;
            y += p.y;
            z += p.z;
        }
        return new S2Point(x, y, z);
    }

    public S2Point sub(S2Point p) {
        return S2Point.sub(this, p);
    }

    @JsIgnore
    public static final S2Point sub(S2Point p1, S2Point p2) {
        return new S2Point(p1.x - p2.x, p1.y - p2.y, p1.z - p2.z);
    }

    public static final S2Point minus(S2Point p1, S2Point p2) {
        return S2Point.sub(p1, p2);
    }

    public S2Point mul(double scale) {
        return S2Point.mul(this, scale);
    }

    @JsIgnore
    public static final S2Point mul(S2Point p, double m3) {
        return new S2Point(m3 * p.x, m3 * p.y, m3 * p.z);
    }

    public S2Point div(double scale) {
        return S2Point.div(this, scale);
    }

    @JsIgnore
    public static final S2Point div(S2Point p, double m3) {
        return new S2Point(p.x / m3, p.y / m3, p.z / m3);
    }

    public final double dotProd(S2Point that) {
        return this.x * that.x + this.y * that.y + this.z * that.z;
    }

    public S2Point crossProd(S2Point p) {
        return S2Point.crossProd(this, p);
    }

    @JsIgnore
    public static final S2Point crossProd(S2Point p1, S2Point p2) {
        return new S2Point(p1.y * p2.z - p1.z * p2.y, p1.z * p2.x - p1.x * p2.z, p1.x * p2.y - p1.y * p2.x);
    }

    public S2Point neg() {
        return S2Point.neg(this);
    }

    @JsIgnore
    public static final S2Point neg(S2Point p) {
        return new S2Point(-p.x, -p.y, -p.z);
    }

    public S2Point fabs() {
        return S2Point.fabs(this);
    }

    @JsIgnore
    public static final S2Point fabs(S2Point p) {
        return new S2Point(Math.abs(p.x), Math.abs(p.y), Math.abs(p.z));
    }

    public S2Point normalize() {
        return S2Point.normalize(this);
    }

    @JsIgnore
    public static final S2Point normalize(S2Point p) {
        double norm = p.norm();
        if (norm != 0.0) {
            norm = 1.0 / norm;
        }
        return S2Point.mul(p, norm);
    }

    public double norm() {
        return Math.sqrt(this.norm2());
    }

    public final double norm2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public static final double scalarTripleProduct(S2Point a, S2Point b, S2Point c) {
        double x = b.y * c.z - b.z * c.y;
        double y = b.z * c.x - b.x * c.z;
        double z = b.x * c.y - b.y * c.x;
        double result = a.x * x + a.y * y + a.z * z;
        assert (result == a.dotProd(S2Point.crossProd(b, c)) || Double.isNaN(result) && Double.isNaN(a.dotProd(S2Point.crossProd(b, c))));
        return result;
    }

    public double getDistance(S2Point that) {
        return Math.sqrt(this.getDistance2(that));
    }

    public double getDistance2(S2Point that) {
        double dx = this.x - that.x;
        double dy = this.y - that.y;
        double dz = this.z - that.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public final S2Point ortho() {
        switch (this.largestAbsComponent()) {
            case 1: {
                return this.crossProd(X_POS).normalize();
            }
            case 2: {
                return this.crossProd(Y_POS).normalize();
            }
        }
        return this.crossProd(Z_POS).normalize();
    }

    public final int largestAbsComponent() {
        return S2Point.largestAbsComponent(this.x, this.y, this.z);
    }

    static final int largestAbsComponent(double x, double y, double z) {
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double absZ = Math.abs(z);
        return absX > absY ? (absX > absZ ? 0 : 2) : (absY > absZ ? 1 : 2);
    }

    public final double crossProdNorm(S2Point va) {
        double x = this.y * va.z - this.z * va.y;
        double y = this.z * va.x - this.x * va.z;
        double z = this.x * va.y - this.y * va.x;
        double result = Math.sqrt(x * x + y * y + z * z);
        assert (result == S2Point.crossProd(this, va).norm());
        return result;
    }

    public S2Point rotate(S2Point axis, double radians2) {
        return S2Point.rotate(this.normalize(), axis.normalize(), radians2);
    }

    public static S2Point rotate(S2Point point, S2Point axis, double radians2) {
        assert (S2.isUnitLength(point));
        assert (S2.isUnitLength(axis));
        S2Point center = axis.mul(point.dotProd(axis));
        S2Point axisToCenter = point.sub(center);
        return S2Point.sum(axisToCenter.mul(Math.cos(radians2)), axis.crossProd(point).mul(Math.sin(radians2)), center).normalize();
    }

    public final double angle(S2Point va) {
        return Math.atan2(this.crossProdNorm(va), this.dotProd(va));
    }

    boolean aequal(S2Point that, double margin) {
        return Math.abs(this.x - that.x) < margin && Math.abs(this.y - that.y) < margin && Math.abs(this.z - that.z) < margin;
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2Point)) {
            return false;
        }
        S2Point thatPoint = (S2Point)that;
        return this.x == thatPoint.x && this.y == thatPoint.y && this.z == thatPoint.z;
    }

    public boolean equalsPoint(S2Point that) {
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public boolean lessThan(S2Point vb) {
        if (this.x < vb.x) {
            return true;
        }
        if (vb.x < this.x) {
            return false;
        }
        if (this.y < vb.y) {
            return true;
        }
        if (vb.y < this.y) {
            return false;
        }
        return this.z < vb.z;
    }

    @Override
    public int compareTo(S2Point other) {
        return this.lessThan(other) ? -1 : (this.equalsPoint(other) ? 0 : 1);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public String toDegreesString() {
        return new S2LatLng(this).toStringDegrees();
    }

    public Builder toBuilder() {
        return new Builder().add(this);
    }

    public int hashCode() {
        long value = 17L;
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.x));
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.y));
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.z));
        return (int)(value ^ value >>> 32);
    }

    @Override
    @JsMethod(name="containsCell")
    public boolean contains(S2Cell cell) {
        return false;
    }

    @Override
    public boolean contains(S2Point other) {
        return this.equalsPoint(other);
    }

    @Override
    public S2Cap getCapBound() {
        return S2Cap.fromAxisHeight(this, 0.0);
    }

    @Override
    public S2LatLngRect getRectBound() {
        S2LatLng latLng = new S2LatLng(this);
        return S2LatLngRect.fromPoint(latLng);
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        return cell.contains(this);
    }

    @JsIgnore
    public void encode(OutputStream os) throws IOException {
        LittleEndianOutput.writeDouble(os, this.x);
        LittleEndianOutput.writeDouble(os, this.y);
        LittleEndianOutput.writeDouble(os, this.z);
    }

    @JsIgnore
    void encode(LittleEndianOutput os) throws IOException {
        this.encode(os.output());
    }

    @JsIgnore
    public static S2Point decode(InputStream is) throws IOException {
        return S2Point.decode(new LittleEndianInput(is));
    }

    @JsIgnore
    static S2Point decode(LittleEndianInput is) throws IOException {
        return new S2Point(is.readDouble(), is.readDouble(), is.readDouble());
    }

    @JsType
    public static final class Builder {
        private double x;
        private double y;
        private double z;

        @CanIgnoreReturnValue
        public Builder add(S2Point point) {
            this.x += point.x;
            this.y += point.y;
            this.z += point.z;
            return this;
        }

        public S2Point build() {
            return new S2Point(this.x, this.y, this.z);
        }
    }

    public static abstract class Shape
    extends AbstractList<S2Point>
    implements S2Shape,
    Serializable {
        private static final long serialVersionUID = 1L;
        public static final S2Coder<Shape> FAST_CODER = S2PointVectorCoder.FAST.delegating(s2 -> s2, Shape::fromList);
        public static final S2Coder<Shape> COMPACT_CODER = S2PointVectorCoder.COMPACT.delegating(s2 -> s2, Shape::fromList);

        public static Shape singleton(final S2Point point) {
            return new Shape(){
                private static final long serialVersionUID = 1L;

                @Override
                public int size() {
                    return 1;
                }

                @Override
                public S2Point get(int index) {
                    if (index != 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    return point;
                }
            };
        }

        public static Shape fromList(final List<S2Point> points) {
            return new Shape(){
                private static final long serialVersionUID = 1L;

                @Override
                public int size() {
                    return points.size();
                }

                @Override
                public S2Point get(int index) {
                    return (S2Point)points.get(index);
                }
            };
        }

        @Override
        public boolean hasInterior() {
            return false;
        }

        @Override
        public boolean containsOrigin() {
            return false;
        }

        @Override
        public int numEdges() {
            return this.size();
        }

        @Override
        public void getEdge(int index, S2Shape.MutableEdge result) {
            result.a = result.b = (S2Point)this.get(index);
        }

        @Override
        public int numChains() {
            return this.size();
        }

        @Override
        public int getChainStart(int chainId) {
            Preconditions.checkElementIndex(chainId, this.numChains());
            return chainId;
        }

        @Override
        public int getChainLength(int chainId) {
            Preconditions.checkElementIndex(chainId, this.numChains());
            return 1;
        }

        @Override
        public void getChainEdge(int chainId, int offset, S2Shape.MutableEdge result) {
            result.a = result.b = this.getChainVertex(chainId, offset);
        }

        @Override
        public S2Point getChainVertex(int chainId, int edgeOffset) {
            Preconditions.checkElementIndex(edgeOffset, 2);
            return (S2Point)this.get(chainId);
        }

        @Override
        public void getChainPosition(int edgeId, S2Shape.ChainPosition result) {
            Preconditions.checkElementIndex(edgeId, this.numEdges());
            result.set(edgeId, 0);
        }

        @Override
        public int dimension() {
            return 0;
        }

        public static class Coder
        implements S2Coder<Shape> {
            static final Coder FAST = new Coder(S2PointVectorCoder.FAST);
            static final Coder COMPACT = new Coder(S2PointVectorCoder.COMPACT);
            private final S2PointVectorCoder coder;

            private Coder(S2PointVectorCoder coder) {
                this.coder = coder;
            }

            @Override
            public void encode(Shape shape, OutputStream output) throws IOException {
                this.coder.encode(shape, output);
            }

            @Override
            public Shape decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
                return Shape.fromList((List<S2Point>)this.coder.decode(data, cursor));
            }

            @Override
            public boolean isLazy() {
                return this.coder.isLazy();
            }
        }
    }
}

