/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.Boundable;
import org.locationtech.jts.index.strtree.STRtree;

public class RtreePartitioning
implements Serializable {
    final List<Envelope> grids = new ArrayList<Envelope>();

    public RtreePartitioning(List<Envelope> samples, int partitions) throws Exception {
        STRtree strtree = new STRtree(samples.size() / partitions);
        for (Envelope sample : samples) {
            strtree.insert(sample, (Object)sample);
        }
        List envelopes = this.findLeafBounds(strtree);
        for (Envelope envelope : envelopes) {
            this.grids.add(envelope);
        }
    }

    public List<Envelope> getGrids() {
        return this.grids;
    }

    private List findLeafBounds(STRtree stRtree) {
        stRtree.build();
        ArrayList boundaries = new ArrayList();
        if (stRtree.isEmpty()) {
            return boundaries;
        }
        this.findLeafBounds(stRtree.getRoot(), boundaries);
        return boundaries;
    }

    private void findLeafBounds(AbstractNode node, List boundaries) {
        Boundable childBoundable;
        List childBoundables = node.getChildBoundables();
        boolean flagLeafnode = true;
        for (Object boundable : childBoundables) {
            childBoundable = (Boundable)boundable;
            if (!(childBoundable instanceof AbstractNode)) continue;
            flagLeafnode = false;
            break;
        }
        if (flagLeafnode) {
            boundaries.add(node.getBounds());
        } else {
            for (Object boundable : childBoundables) {
                childBoundable = (Boundable)boundable;
                if (!(childBoundable instanceof AbstractNode)) continue;
                this.findLeafBounds((AbstractNode)childBoundable, boundaries);
            }
        }
    }
}

