/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.parquet.Covering;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.parquet.GeometryFieldMetaData;
import org.apache.spark.sql.sedona_sql.io.stac.StacBatch$;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartition;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartitionReader;
import org.apache.spark.sql.sedona_sql.io.stac.StacUtils$;
import org.apache.spark.sql.types.StructType;
import org.json4s.JsonAST;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Growable;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\tMf\u0001\u0002\u001c8\u0001\u001aC\u0001\"\u001b\u0001\u0003\u0016\u0004%\tA\u001b\u0005\tg\u0002\u0011\t\u0012)A\u0005W\"AA\u000f\u0001BK\u0002\u0013\u0005!\u000e\u0003\u0005v\u0001\tE\t\u0015!\u0003l\u0011!1\bA!f\u0001\n\u00039\b\u0002\u0003@\u0001\u0005#\u0005\u000b\u0011\u0002=\t\u0013}\u0004!Q3A\u0005\u0002\u0005\u0005\u0001BCA\u0005\u0001\tE\t\u0015!\u0003\u0002\u0004!Q\u00111\u0002\u0001\u0003\u0016\u0004%\t!!\u0004\t\u0015\u0005%\u0002A!E!\u0002\u0013\ty\u0001\u0003\u0006\u0002,\u0001\u0011)\u001a!C\u0001\u0003[A!\"a\u0010\u0001\u0005#\u0005\u000b\u0011BA\u0018\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007B\u0011\"!\u0016\u0001\u0005\u0004%I!a\u0016\t\u0011\u0005}\u0003\u0001)A\u0005\u00033B\u0011\"!\u0019\u0001\u0005\u0004%I!a\u0016\t\u0011\u0005\r\u0004\u0001)A\u0005\u00033B\u0011\"!\u001a\u0001\u0001\u0004%I!a\u0016\t\u0013\u0005\u001d\u0004\u00011A\u0005\n\u0005%\u0004\u0002CA;\u0001\u0001\u0006K!!\u0017\t\u0013\u0005]\u0004\u00011A\u0005\n\u0005]\u0003\"CA=\u0001\u0001\u0007I\u0011BA>\u0011!\ty\b\u0001Q!\n\u0005e\u0003\"CAA\u0001\t\u0007I\u0011AAB\u0011!\ti\n\u0001Q\u0001\n\u0005\u0015\u0005bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003O\u0003A\u0011IAU\u0011\u001d\t9\f\u0001C\u0001\u0003sCq!!9\u0001\t\u0003\t\u0019\u000fC\u0004\u0002l\u0002!\t%!<\t\u0013\u0005U\b!!A\u0005\u0002\u0005]\b\"\u0003B\u0003\u0001E\u0005I\u0011\u0001B\u0004\u0011%\u0011i\u0002AI\u0001\n\u0003\u00119\u0001C\u0005\u0003 \u0001\t\n\u0011\"\u0001\u0003\"!I!Q\u0005\u0001\u0012\u0002\u0013\u0005!q\u0005\u0005\n\u0005W\u0001\u0011\u0013!C\u0001\u0005[A\u0011B!\r\u0001#\u0003%\tAa\r\t\u0013\t]\u0002!!A\u0005B\te\u0002\"\u0003B \u0001\u0005\u0005I\u0011AA,\u0011%\u0011\t\u0005AA\u0001\n\u0003\u0011\u0019\u0005C\u0005\u0003N\u0001\t\t\u0011\"\u0011\u0003P!I!\u0011\f\u0001\u0002\u0002\u0013\u0005!1\f\u0005\n\u0005?\u0002\u0011\u0011!C!\u0005CB\u0011B!\u001a\u0001\u0003\u0003%\tEa\u001a\t\u0013\t%\u0004!!A\u0005B\t-\u0004\"\u0003B7\u0001\u0005\u0005I\u0011\tB8\u000f%\u0011\u0019hNA\u0001\u0012\u0003\u0011)H\u0002\u00057o\u0005\u0005\t\u0012\u0001B<\u0011\u001d\t\t\u0005\rC\u0001\u0005\u001bC\u0011B!\u001b1\u0003\u0003%)Ea\u001b\t\u0013\t=\u0005'!A\u0005\u0002\nE\u0005\"\u0003BPa\u0005\u0005I\u0011\u0011BQ\u0011%\u0011y\u000bMA\u0001\n\u0013\u0011\tLA\u0005Ti\u0006\u001c')\u0019;dQ*\u0011\u0001(O\u0001\u0005gR\f7M\u0003\u0002;w\u0005\u0011\u0011n\u001c\u0006\u0003yu\n!b]3e_:\fwl]9m\u0015\tqt(A\u0002tc2T!\u0001Q!\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001b\u0015AB1qC\u000eDWMC\u0001E\u0003\ry'oZ\u0002\u0001'\u0015\u0001qiT,^!\tAU*D\u0001J\u0015\tQ5*\u0001\u0003mC:<'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u0013aa\u00142kK\u000e$\bC\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0011\u0011X-\u00193\u000b\u0005Qk\u0014!C2p]:,7\r^8s\u0013\t1\u0016KA\u0003CCR\u001c\u0007\u000e\u0005\u0002Y76\t\u0011LC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016LA\u0004Qe>$Wo\u0019;\u0011\u0005y3gBA0e\u001d\t\u00017-D\u0001b\u0015\t\u0011W)\u0001\u0004=e>|GOP\u0005\u00025&\u0011Q-W\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007N\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002f3\u0006\t2\u000f^1d\u0007>dG.Z2uS>tWK\u001d7\u0016\u0003-\u0004\"\u0001\u001c9\u000f\u00055t\u0007C\u00011Z\u0013\ty\u0017,\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8Z\u0003I\u0019H/Y2D_2dWm\u0019;j_:,&\u000f\u001c\u0011\u0002%M$\u0018mY\"pY2,7\r^5p]*\u001bxN\\\u0001\u0014gR\f7mQ8mY\u0016\u001cG/[8o\u0015N|g\u000eI\u0001\u0007g\u000eDW-\\1\u0016\u0003a\u0004\"!\u001f?\u000e\u0003iT!a_\u001f\u0002\u000bQL\b/Z:\n\u0005uT(AC*ueV\u001cG\u000fV=qK\u000691o\u00195f[\u0006\u0004\u0013\u0001B8qiN,\"!a\u0001\u0011\u000b1\f)a[6\n\u0007\u0005\u001d!OA\u0002NCB\fQa\u001c9ug\u0002\nQb\u001d9bi&\fGNR5mi\u0016\u0014XCAA\b!\u0015A\u0016\u0011CA\u000b\u0013\r\t\u0019\"\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005]\u0011QE\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u00059\u0001/\u0019:rk\u0016$(\u0002BA\u0010\u0003C\t1\u0002Z1uCN|WO]2fg*\u0019\u00111E\u001f\u0002\u0013\u0015DXmY;uS>t\u0017\u0002BA\u0014\u00033\u0011qcR3p!\u0006\u0014\u0018/^3u'B\fG/[1m\r&dG/\u001a:\u0002\u001dM\u0004\u0018\r^5bY\u001aKG\u000e^3sA\u0005qA/Z7q_J\fGNR5mi\u0016\u0014XCAA\u0018!\u0015A\u0016\u0011CA\u0019!\u0011\t\u0019$a\u000f\u000e\u0005\u0005U\"b\u0001\u001d\u00028)!\u0011\u0011HA\u0011\u0003)!\u0017\r^1t_V\u00148-Z\u0005\u0005\u0003{\t)D\u0001\bUK6\u0004xN]1m\r&dG/\u001a:\u0002\u001fQ,W\u000e]8sC24\u0015\u000e\u001c;fe\u0002\na\u0001P5oSRtDCDA#\u0003\u0013\nY%!\u0014\u0002P\u0005E\u00131\u000b\t\u0004\u0003\u000f\u0002Q\"A\u001c\t\u000b%l\u0001\u0019A6\t\u000bQl\u0001\u0019A6\t\u000bYl\u0001\u0019\u0001=\t\r}l\u0001\u0019AA\u0002\u0011\u001d\tY!\u0004a\u0001\u0003\u001fAq!a\u000b\u000e\u0001\u0004\ty#A\u000eeK\u001a\fW\u000f\u001c;Ji\u0016l7\u000fT5nSR\u0004VM\u001d*fcV,7\u000f^\u000b\u0003\u00033\u00022\u0001WA.\u0013\r\ti&\u0017\u0002\u0004\u0013:$\u0018\u0001\b3fM\u0006,H\u000e^%uK6\u001cH*[7jiB+'OU3rk\u0016\u001cH\u000fI\u0001 SR,Wn\u001d'pC\u0012\u0004&o\\2fgN\u0014V\r]8siRC'/Z:i_2$\u0017\u0001I5uK6\u001cHj\\1e!J|7-Z:t%\u0016\u0004xN\u001d;UQJ,7\u000f[8mI\u0002\n1\"\u001b;f[6\u000b\u0007\u0010T3gi\u0006y\u0011\u000e^3n\u001b\u0006DH*\u001a4u?\u0012*\u0017\u000f\u0006\u0003\u0002l\u0005E\u0004c\u0001-\u0002n%\u0019\u0011qN-\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003g\u001a\u0012\u0011!a\u0001\u00033\n1\u0001\u001f\u00132\u00031IG/Z7NCbdUM\u001a;!\u0003=a\u0017m\u001d;SKB|'\u000f^\"pk:$\u0018a\u00057bgR\u0014V\r]8si\u000e{WO\u001c;`I\u0015\fH\u0003BA6\u0003{B\u0011\"a\u001d\u0017\u0003\u0003\u0005\r!!\u0017\u0002!1\f7\u000f\u001e*fa>\u0014HoQ8v]R\u0004\u0013AB7baB,'/\u0006\u0002\u0002\u0006B!\u0011qQAM\u001b\t\tII\u0003\u0003\u0002\f\u00065\u0015\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\t\u0005=\u0015\u0011S\u0001\bU\u0006\u001c7n]8o\u0015\u0011\t\u0019*!&\u0002\u0013\u0019\f7\u000f^3sq6d'BAAL\u0003\r\u0019w.\\\u0005\u0005\u00037\u000bII\u0001\u0007PE*,7\r^'baB,'/A\u0004nCB\u0004XM\u001d\u0011\u0002\u001dM,G/\u0013;f[6\u000b\u0007\u0010T3giR!\u00111NAR\u0011\u001d\t)K\u0007a\u0001\u00033\nQA^1mk\u0016\f1\u0003\u001d7b]&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N$\"!a+\u0011\u000ba\u000bi+!-\n\u0007\u0005=\u0016LA\u0003BeJ\f\u0017\u0010E\u0002Q\u0003gK1!!.R\u00059Ie\u000e];u!\u0006\u0014H/\u001b;j_:\f\u0001cY8mY\u0016\u001cG/\u0013;f[2Kgn[:\u0015\u0015\u0005-\u00141XA`\u0003\u0007\f9\u000e\u0003\u0004\u0002>r\u0001\ra[\u0001\u0013G>dG.Z2uS>t')Y:f!\u0006$\b\u000e\u0003\u0004\u0002Br\u0001\ra[\u0001\u000fG>dG.Z2uS>t'j]8o\u0011\u001d\t)\r\ba\u0001\u0003\u000f\f\u0011\"\u001b;f[2Kgn[:\u0011\u000b\u0005%\u00171[6\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\fq!\\;uC\ndWMC\u0002\u0002Rf\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t).a3\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\b\u00033d\u0002\u0019AAn\u0003IqW-\u001a3D_VtGOT3yi&#X-\\:\u0011\u0007a\u000bi.C\u0002\u0002`f\u0013qAQ8pY\u0016\fg.\u0001\tgS2$XM]\"pY2,7\r^5p]RA\u00111\\As\u0003O\fI\u000f\u0003\u0004\u0002Bv\u0001\ra\u001b\u0005\b\u0003\u0017i\u0002\u0019AA\b\u0011\u001d\tY#\ba\u0001\u0003_\t1c\u0019:fCR,'+Z1eKJ4\u0015m\u0019;pef$\"!a<\u0011\u0007A\u000b\t0C\u0002\u0002tF\u0013a\u0003U1si&$\u0018n\u001c8SK\u0006$WM\u001d$bGR|'/_\u0001\u0005G>\u0004\u0018\u0010\u0006\b\u0002F\u0005e\u00181`A\u007f\u0003\u007f\u0014\tAa\u0001\t\u000f%|\u0002\u0013!a\u0001W\"9Ao\bI\u0001\u0002\u0004Y\u0007b\u0002< !\u0003\u0005\r\u0001\u001f\u0005\t\u007f~\u0001\n\u00111\u0001\u0002\u0004!I\u00111B\u0010\u0011\u0002\u0003\u0007\u0011q\u0002\u0005\n\u0003Wy\u0002\u0013!a\u0001\u0003_\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\n)\u001a1Na\u0003,\u0005\t5\u0001\u0003\u0002B\b\u00053i!A!\u0005\u000b\t\tM!QC\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0006Z\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00057\u0011\tBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\r\"f\u0001=\u0003\f\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001B\u0015U\u0011\t\u0019Aa\u0003\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!q\u0006\u0016\u0005\u0003\u001f\u0011Y!\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\tU\"\u0006BA\u0018\u0005\u0017\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u001e!\rA%QH\u0005\u0003c&\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003F\t-\u0003c\u0001-\u0003H%\u0019!\u0011J-\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002t!\n\t\u00111\u0001\u0002Z\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003RA1!1\u000bB+\u0005\u000bj!!a4\n\t\t]\u0013q\u001a\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\\\nu\u0003\"CA:U\u0005\u0005\t\u0019\u0001B#\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\tm\"1\r\u0005\n\u0003gZ\u0013\u0011!a\u0001\u00033\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u00033\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005w\ta!Z9vC2\u001cH\u0003BAn\u0005cB\u0011\"a\u001d/\u0003\u0003\u0005\rA!\u0012\u0002\u0013M#\u0018m\u0019\"bi\u000eD\u0007cAA$aM)\u0001G!\u001f\u0003\u0006By!1\u0010BAW.D\u00181AA\b\u0003_\t)%\u0004\u0002\u0003~)\u0019!qP-\u0002\u000fI,h\u000e^5nK&!!1\u0011B?\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\u000e\t\u0005\u0005\u000f\u0013Y)\u0004\u0002\u0003\n*\u0011!hS\u0005\u0004O\n%EC\u0001B;\u0003\u0015\t\u0007\u000f\u001d7z)9\t)Ea%\u0003\u0016\n]%\u0011\u0014BN\u0005;CQ![\u001aA\u0002-DQ\u0001^\u001aA\u0002-DQA^\u001aA\u0002aDaa`\u001aA\u0002\u0005\r\u0001bBA\u0006g\u0001\u0007\u0011q\u0002\u0005\b\u0003W\u0019\u0004\u0019AA\u0018\u0003\u001d)h.\u00199qYf$BAa)\u0003,B)\u0001,!\u0005\u0003&Ba\u0001La*lWb\f\u0019!a\u0004\u00020%\u0019!\u0011V-\u0003\rQ+\b\u000f\\37\u0011%\u0011i\u000bNA\u0001\u0002\u0004\t)%A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\u0012a\u0012")
public class StacBatch
implements Batch,
Product,
Serializable {
    private final String stacCollectionUrl;
    private final String stacCollectionJson;
    private final StructType schema;
    private final Map<String, String> opts;
    private final Option<GeoParquetSpatialFilter> spatialFilter;
    private final Option<TemporalFilter> temporalFilter;
    private final int defaultItemsLimitPerRequest;
    private final int itemsLoadProcessReportThreshold;
    private int itemMaxLeft;
    private int lastReportCount;
    private final ObjectMapper mapper;

    public static Option<Tuple6<String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>>> unapply(StacBatch x$0) {
        return StacBatch$.MODULE$.unapply(x$0);
    }

    public static StacBatch apply(String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        return StacBatch$.MODULE$.apply(stacCollectionUrl, stacCollectionJson, schema, opts, spatialFilter, temporalFilter);
    }

    public static Function1<Tuple6<String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>>, StacBatch> tupled() {
        return StacBatch$.MODULE$.tupled();
    }

    public static Function1<String, Function1<String, Function1<StructType, Function1<Map<String, String>, Function1<Option<GeoParquetSpatialFilter>, Function1<Option<TemporalFilter>, StacBatch>>>>>> curried() {
        return StacBatch$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String stacCollectionUrl() {
        return this.stacCollectionUrl;
    }

    public String stacCollectionJson() {
        return this.stacCollectionJson;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> opts() {
        return this.opts;
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    public Option<TemporalFilter> temporalFilter() {
        return this.temporalFilter;
    }

    private int defaultItemsLimitPerRequest() {
        return this.defaultItemsLimitPerRequest;
    }

    private int itemsLoadProcessReportThreshold() {
        return this.itemsLoadProcessReportThreshold;
    }

    private int itemMaxLeft() {
        return this.itemMaxLeft;
    }

    private void itemMaxLeft_$eq(int x$1) {
        this.itemMaxLeft = x$1;
    }

    private int lastReportCount() {
        return this.lastReportCount;
    }

    private void lastReportCount_$eq(int x$1) {
        this.lastReportCount = x$1;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public void setItemMaxLeft(int value) {
        this.itemMaxLeft_$eq(value);
    }

    public InputPartition[] planInputPartitions() {
        String stacCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(this.stacCollectionUrl());
        ArrayBuffer itemLinks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int itemsLimitMax = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"itemsLimitMax", (Function0 & Serializable)() -> "-1")));
        boolean checkItemsLimitMax = itemsLimitMax > 0;
        this.setItemMaxLeft(itemsLimitMax);
        this.collectItemLinks(stacCollectionBasePath, this.stacCollectionJson(), (ArrayBuffer<String>)itemLinks, checkItemsLimitMax);
        if (itemLinks.isEmpty()) {
            return (InputPartition[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int numPartitions = StacUtils$.MODULE$.getNumPartitions(itemLinks.length(), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"numPartitions", (Function0 & Serializable)() -> "-1"))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"maxPartitionItemFiles", (Function0 & Serializable)() -> "-1"))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"defaultParallelism", (Function0 & Serializable)() -> "1"))));
        if (itemLinks.length() < numPartitions) {
            return (InputPartition[])((IterableOnceOps)((StrictOptimizedIterableOps)itemLinks.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String item = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return new StacPartition(index, (String[])((Object[])new String[]{item}), new HashMap<String, String>());
                }
                throw new MatchError((Object)tuple2);
            })).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int partitionSize = (int)Math.ceil((double)itemLinks.length() / (double)numPartitions);
        return (InputPartition[])itemLinks.grouped(partitionSize).zipWithIndex().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                ArrayBuffer items = (ArrayBuffer)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return new StacPartition(index, (String[])items.toArray(ClassTag$.MODULE$.apply(String.class)), new HashMap<String, String>());
            }
            throw new MatchError((Object)tuple2);
        }).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public void collectItemLinks(String collectionBasePath, String collectionJson, ArrayBuffer<String> itemLinks, boolean needCountNextItems) {
        if (needCountNextItems && this.itemMaxLeft() <= 0) {
            return;
        }
        if (itemLinks.size() - this.lastReportCount() >= this.itemsLoadProcessReportThreshold()) {
            Console$.MODULE$.out().println(new StringBuilder(38).append("Searched or partitioned ").append(itemLinks.size()).append(" items so far.").toString());
            this.lastReportCount_$eq(itemLinks.size());
        }
        JsonNode rootNode = this.mapper().readTree(collectionJson);
        JsonNode linksNode = rootNode.get("links");
        java.util.Iterator iterator = linksNode.elements();
        while (iterator.hasNext()) {
            String href;
            String rel;
            block9: {
                block8: {
                    JsonNode linkNode = (JsonNode)iterator.next();
                    rel = linkNode.get("rel").asText();
                    href = linkNode.get("href").asText();
                    String string = rel;
                    String string2 = "item";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block8;
                    String string3 = rel;
                    String string4 = "items";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block9;
                }
                String itemUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
                String string = rel;
                String string5 = "items";
                Growable growable = !(string != null ? !string.equals(string5) : string5 != null) && href.startsWith("http") ? itemLinks.$plus$eq((Object)new StringBuilder(7).append(itemUrl).append("?limit=").append(this.defaultItemsLimitPerRequest()).toString()) : itemLinks.$plus$eq((Object)itemUrl);
                if (needCountNextItems && this.itemMaxLeft() <= 0) {
                    return;
                }
                String string6 = rel;
                String string7 = "item";
                if (!(string6 != null ? !string6.equals(string7) : string7 != null) && needCountNextItems) {
                    this.itemMaxLeft_$eq(this.itemMaxLeft() - 1);
                    continue;
                }
                String string8 = rel;
                String string9 = "items";
                if (string8 != null ? !string8.equals(string9) : string9 != null) continue;
                if (!href.startsWith("http") || !this.iterateItemsWithLimit$1(new StringBuilder(7).append(itemUrl).append("?limit=").append(this.defaultItemsLimitPerRequest()).toString(), needCountNextItems, collectionBasePath, itemLinks)) continue;
                return;
            }
            String string = rel;
            String string10 = "child";
            if (string != null ? !string.equals(string10) : string10 != null) continue;
            String childUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
            String linkedCollectionJson = StacUtils$.MODULE$.loadStacCollectionToJson(childUrl, StacUtils$.MODULE$.loadStacCollectionToJson$default$2());
            String nestedCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(childUrl);
            boolean collectionFiltered = this.filterCollection(linkedCollectionJson, this.spatialFilter(), this.temporalFilter());
            if (collectionFiltered) continue;
            this.collectItemLinks(nestedCollectionBasePath, linkedCollectionJson, itemLinks, needCountNextItems);
        }
    }

    public boolean filterCollection(String collectionJson, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        boolean bl;
        boolean bl2;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(collectionJson);
        Option<GeoParquetSpatialFilter> option = spatialFilter;
        if (option instanceof Some) {
            List bbox;
            Some some = (Some)option;
            GeoParquetSpatialFilter filter = (GeoParquetSpatialFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("spatial").path("bbox");
            bl2 = extentNode.isMissingNode() ? false : !(bbox = CollectionConverters$.MODULE$.IteratorHasAsScala(extentNode.elements()).asScala().map((Function1 & Serializable)bboxNode -> {
                double minX = bboxNode.get(0).asDouble();
                double minY = bboxNode.get(1).asDouble();
                double maxX = bboxNode.get(2).asDouble();
                double maxY = bboxNode.get(3).asDouble();
                return new Tuple4((Object)BoxesRunTime.boxToDouble((double)minX), (Object)BoxesRunTime.boxToDouble((double)minY), (Object)BoxesRunTime.boxToDouble((double)maxX), (Object)BoxesRunTime.boxToDouble((double)maxY));
            }).toList()).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$2(filter, x0$1)));
        } else if (None$.MODULE$.equals(option)) {
            bl2 = false;
        } else {
            throw new MatchError(option);
        }
        boolean spatialFiltered = bl2;
        Option<TemporalFilter> option2 = temporalFilter;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            TemporalFilter filter = (TemporalFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("temporal").path("interval");
            if (extentNode.isMissingNode()) {
                bl = true;
            } else {
                DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).optionalEnd().appendPattern("'Z'").toFormatter();
                List intervals = CollectionConverters$.MODULE$.IteratorHasAsScala(extentNode.elements()).asScala().map((Function1 & Serializable)intervalNode -> {
                    LocalDateTime start = LocalDateTime.parse(intervalNode.get(0).asText(), formatter);
                    LocalDateTime end = LocalDateTime.parse(intervalNode.get(1).asText(), formatter);
                    return new Tuple2((Object)start, (Object)end);
                }).toList();
                bl = !intervals.exists((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$4(filter, x0$2)));
            }
        } else if (None$.MODULE$.equals(option2)) {
            bl = false;
        } else {
            throw new MatchError(option2);
        }
        boolean temporalFiltered = bl;
        return spatialFiltered || temporalFiltered;
    }

    public PartitionReaderFactory createReaderFactory() {
        return (PartitionReaderFactory & Serializable)partition -> new StacPartitionReader((StacPartition)partition, this.schema(), this.opts(), this.spatialFilter(), this.temporalFilter());
    }

    public StacBatch copy(String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        return new StacBatch(stacCollectionUrl, stacCollectionJson, schema, opts, spatialFilter, temporalFilter);
    }

    public String copy$default$1() {
        return this.stacCollectionUrl();
    }

    public String copy$default$2() {
        return this.stacCollectionJson();
    }

    public StructType copy$default$3() {
        return this.schema();
    }

    public Map<String, String> copy$default$4() {
        return this.opts();
    }

    public Option<GeoParquetSpatialFilter> copy$default$5() {
        return this.spatialFilter();
    }

    public Option<TemporalFilter> copy$default$6() {
        return this.temporalFilter();
    }

    public String productPrefix() {
        return "StacBatch";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.stacCollectionUrl();
            }
            case 1: {
                return this.stacCollectionJson();
            }
            case 2: {
                return this.schema();
            }
            case 3: {
                return this.opts();
            }
            case 4: {
                return this.spatialFilter();
            }
            case 5: {
                return this.temporalFilter();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StacBatch;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "stacCollectionUrl";
            }
            case 1: {
                return "stacCollectionJson";
            }
            case 2: {
                return "schema";
            }
            case 3: {
                return "opts";
            }
            case 4: {
                return "spatialFilter";
            }
            case 5: {
                return "temporalFilter";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StacBatch)) return false;
        boolean bl = true;
        if (!bl) return false;
        StacBatch stacBatch = (StacBatch)x$1;
        String string = this.stacCollectionUrl();
        String string2 = stacBatch.stacCollectionUrl();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.stacCollectionJson();
        String string4 = stacBatch.stacCollectionJson();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        StructType structType = this.schema();
        StructType structType2 = stacBatch.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        Map<String, String> map = this.opts();
        Map<String, String> map2 = stacBatch.opts();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<GeoParquetSpatialFilter> option = this.spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = stacBatch.spatialFilter();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<TemporalFilter> option3 = this.temporalFilter();
        Option<TemporalFilter> option4 = stacBatch.temporalFilter();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!stacBatch.canEqual(this)) return false;
        return true;
    }

    private final boolean iterateItemsWithLimit$1(String itemUrl, boolean needCountNextItems, String collectionBasePath$1, ArrayBuffer itemLinks$1) {
        boolean bl;
        Object object = new Object();
        try {
            ObjectRef nextUrl = ObjectRef.create((Object)new Some((Object)itemUrl));
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                while (((Option)nextUrl$1.elem).isDefined()) {
                    String itemJson = StacUtils$.MODULE$.loadStacCollectionToJson((String)((Option)nextUrl$1.elem).get(), StacUtils$.MODULE$.loadStacCollectionToJson$default$2());
                    JsonNode itemRootNode = this.mapper().readTree(itemJson);
                    JsonNode itemLinksNode = itemRootNode.get("links");
                    if (itemLinksNode == null) {
                        throw new NonLocalReturnControl.mcZ.sp(object, true);
                    }
                    java.util.Iterator itemIterator = itemLinksNode.elements();
                    nextUrl$1.elem = None$.MODULE$;
                    while (itemIterator.hasNext()) {
                        JsonNode itemLinkNode = (JsonNode)itemIterator.next();
                        String itemRel = itemLinkNode.get("rel").asText();
                        String itemHref = itemLinkNode.get("href").asText();
                        String string = itemRel;
                        String string2 = "next";
                        if (string != null ? !string.equals(string2) : string2 != null) continue;
                        JsonNode numberReturnedNode = itemRootNode.get("numberReturned");
                        int numberReturned = numberReturnedNode == null ? this.defaultItemsLimitPerRequest() : numberReturnedNode.asInt();
                        this.itemMaxLeft_$eq(this.itemMaxLeft() - numberReturned);
                        if (needCountNextItems && this.itemMaxLeft() <= 0) {
                            throw new NonLocalReturnControl.mcZ.sp(object, true);
                        }
                        nextUrl$1.elem = new Some((Object)(itemHref.startsWith("http") || itemHref.startsWith("file") ? itemHref : new StringBuilder(0).append(collectionBasePath$1).append(itemHref).toString()));
                    }
                    Object object = ((Option)nextUrl$1.elem).isDefined() ? itemLinks$1.$plus$eq(((Option)nextUrl$1.elem).get()) : BoxedUnit.UNIT;
                }
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$2(GeoParquetSpatialFilter filter$1, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 != null) {
            double minX = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double minY = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double maxX = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double maxY = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            .colon.colon geometryTypes = new .colon.colon((Object)"Polygon", (List)Nil$.MODULE$);
            Seq bbox = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{minX, minY, maxX, maxY}));
            GeometryFieldMetaData geometryFieldMetaData = new GeometryFieldMetaData("WKB", (Seq<String>)geometryTypes, (Seq<Object>)bbox, (Option<JsonAST.JValue>)None$.MODULE$, (Option<Covering>)None$.MODULE$);
            return filter$1.evaluate((Map<String, GeometryFieldMetaData>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"geometry"), (Object)geometryFieldMetaData)}))));
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$4(TemporalFilter filter$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            LocalDateTime start = (LocalDateTime)tuple2._1();
            LocalDateTime end = (LocalDateTime)tuple2._2();
            return filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)start)})))) || filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)end)}))));
        }
        throw new MatchError((Object)tuple2);
    }

    public StacBatch(String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        this.stacCollectionUrl = stacCollectionUrl;
        this.stacCollectionJson = stacCollectionJson;
        this.schema = schema;
        this.opts = opts;
        this.spatialFilter = spatialFilter;
        this.temporalFilter = temporalFilter;
        Product.$init$((Product)this);
        int itemsLimitMax = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitMax", (Function0 & Serializable)() -> "-1")));
        int limitPerRequest = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitPerRequest", (Function0 & Serializable)() -> "10")));
        this.defaultItemsLimitPerRequest = itemsLimitMax > 0 && limitPerRequest > itemsLimitMax ? itemsLimitMax : limitPerRequest;
        this.itemsLoadProcessReportThreshold = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLoadProcessReportThreshold", (Function0 & Serializable)() -> "1000000")));
        this.itemMaxLeft = -1;
        this.lastReportCount = 0;
        this.mapper = new ObjectMapper();
    }
}

