/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.osmpbf;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sedona.sql.datasources.osmpbf.TruncatedStream;

public class StartEndStream
extends TruncatedStream {
    private long counter = 0L;
    private long lengthLimit = 0L;

    @Override
    public boolean continueReading() {
        return this.lengthLimit > this.counter;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result != -1) {
            ++this.counter;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result != -1) {
            this.counter += (long)result;
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        this.counter += skipped;
        return skipped;
    }

    public StartEndStream(InputStream in, long lengthLimit) {
        super(in);
        this.lengthLimit = lengthLimit;
    }
}

