/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.media.jai.RasterFactory;
import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.common.raster.RasterAccessors;
import org.apache.sedona.common.raster.RasterBandEditors;
import org.apache.sedona.common.raster.inputstream.ByteArrayImageInputStream;
import org.apache.sedona.common.raster.netcdf.NetCdfReader;
import org.apache.sedona.common.utils.ImageUtils;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.vector.VectorToRasterProcess;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;

public class RasterConstructors {
    public static GridCoverage2D fromArcInfoAsciiGrid(byte[] bytes) throws IOException {
        ArcGridReader reader = new ArcGridReader((Object)new ByteArrayImageInputStream(bytes), new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
        return reader.read(null);
    }

    public static GridCoverage2D fromGeoTiff(byte[] bytes) throws IOException {
        GeoTiffReader geoTiffReader = new GeoTiffReader((Object)new ByteArrayImageInputStream(bytes), new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE));
        return geoTiffReader.read(null);
    }

    public static GridCoverage2D fromNetCDF(byte[] bytes, String variableName, String lonDimensionName, String latDimensionName) throws IOException, FactoryException {
        NetcdfFile netcdfFile = RasterConstructors.openNetCdfBytes(bytes);
        return NetCdfReader.getRaster(netcdfFile, variableName, latDimensionName, lonDimensionName);
    }

    public static GridCoverage2D fromNetCDF(byte[] bytes, String recordVariableName) throws IOException, FactoryException {
        NetcdfFile netcdfFile = RasterConstructors.openNetCdfBytes(bytes);
        return NetCdfReader.getRaster(netcdfFile, recordVariableName);
    }

    public static String getRecordInfo(byte[] bytes) throws IOException {
        NetcdfFile netcdfFile = RasterConstructors.openNetCdfBytes(bytes);
        return NetCdfReader.getRecordInfo(netcdfFile);
    }

    private static NetcdfFile openNetCdfBytes(byte[] bytes) throws IOException {
        return NetcdfFiles.openInMemory("", bytes);
    }

    public static GridCoverage2D asRaster(Geometry geom, GridCoverage2D raster, String pixelType, double value, Double noDataValue, boolean useGeometryExtent) throws FactoryException {
        List<Object> objects = RasterConstructors.rasterization(geom, raster, pixelType, value, noDataValue, useGeometryExtent);
        WritableRaster writableRaster = (WritableRaster)objects.get(0);
        GridCoverage2D rasterized = (GridCoverage2D)objects.get(1);
        return RasterUtils.clone(writableRaster, rasterized.getSampleDimensions(), rasterized, noDataValue, false);
    }

    public static GridCoverage2D asRaster(Geometry geom, GridCoverage2D raster, String pixelType, double value, Double noDataValue) throws FactoryException {
        return RasterConstructors.asRaster(geom, raster, pixelType, value, noDataValue, true);
    }

    public static GridCoverage2D asRaster(Geometry geom, GridCoverage2D raster, String pixelType) throws FactoryException {
        return RasterConstructors.asRaster(geom, raster, pixelType, 1.0, null);
    }

    public static GridCoverage2D asRaster(Geometry geom, GridCoverage2D raster, String pixelType, double value) throws FactoryException {
        return RasterConstructors.asRaster(geom, raster, pixelType, value, null);
    }

    private static List<Object> rasterization(Geometry geom, GridCoverage2D raster, String pixelType, double value, Double noDataValue, boolean useGeometryExtent) throws FactoryException {
        DefaultFeatureCollection featureCollection = RasterConstructors.getFeatureCollection(geom, raster.getCoordinateReferenceSystem());
        double[] metadata = RasterAccessors.metadata(raster);
        if (metadata[4] < 0.0) {
            throw new IllegalArgumentException(String.format("ScaleX %f of the raster is negative, it should be positive", metadata[4]));
        }
        if (metadata[5] > 0.0) {
            throw new IllegalArgumentException(String.format("ScaleY %f of the raster is positive. It should be negative.", metadata[5]));
        }
        if (metadata[6] != 0.0) {
            throw new IllegalArgumentException(String.format("SkewX %d of the raster is not zero.", metadata[6]));
        }
        if (metadata[7] != 0.0) {
            throw new IllegalArgumentException(String.format("SkewY %d of the raster is not zero.", metadata[7]));
        }
        Envelope2D bound = null;
        if (useGeometryExtent) {
            bound = JTS.getEnvelope2D((Envelope)geom.getEnvelopeInternal(), (CoordinateReferenceSystem)raster.getCoordinateReferenceSystem2D());
        } else {
            ReferencedEnvelope envelope = ReferencedEnvelope.create((org.opengis.geometry.Envelope)raster.getEnvelope(), (CoordinateReferenceSystem)raster.getCoordinateReferenceSystem());
            bound = JTS.getEnvelope2D((Envelope)envelope, (CoordinateReferenceSystem)raster.getCoordinateReferenceSystem2D());
        }
        double scaleX = Math.abs(metadata[4]);
        double scaleY = Math.abs(metadata[5]);
        int width = (int)bound.getWidth();
        int height = (int)bound.getHeight();
        if (width == 0 && height == 0) {
            bound = new Envelope2D(bound.getCoordinateReferenceSystem(), bound.getCenterX() - scaleX * 0.5, bound.getCenterY() - scaleY * 0.5, scaleX, scaleY);
            width = 1;
            height = 1;
        } else if (height == 0) {
            bound = new Envelope2D(bound.getCoordinateReferenceSystem(), bound.getCenterX() - scaleX * 0.5, bound.getCenterY() - scaleY * 0.5, (double)width, scaleY);
            height = 1;
        } else if (width == 0) {
            bound = new Envelope2D(bound.getCoordinateReferenceSystem(), bound.getCenterX() - scaleX * 0.5, bound.getCenterY() - scaleY * 0.5, scaleX, (double)height);
            width = 1;
        } else {
            width = (int)((double)width / scaleX);
            height = (int)((double)height / scaleY);
        }
        VectorToRasterProcess rasterProcess = new VectorToRasterProcess();
        GridCoverage2D rasterized = rasterProcess.execute((SimpleFeatureCollection)featureCollection, Integer.valueOf(width), Integer.valueOf(height), "value", Double.toString(value), (org.opengis.geometry.Envelope)bound, null);
        if (noDataValue != null) {
            rasterized = RasterBandEditors.setBandNoDataValue(rasterized, 1, noDataValue);
        }
        WritableRaster writableRaster = RasterFactory.createBandedRaster((int)RasterUtils.getDataTypeCode(pixelType), (int)width, (int)height, (int)1, null);
        double[] samples = RasterUtils.getRaster(rasterized.getRenderedImage()).getSamples(0, 0, width, height, 0, (double[])null);
        writableRaster.setSamples(0, 0, width, height, 0, samples);
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(writableRaster);
        objects.add(rasterized);
        return objects;
    }

    public static GridCoverage2D asRasterWithRasterExtent(Geometry geom, GridCoverage2D raster, String pixelType, double value, Double noDataValue) throws FactoryException {
        return RasterConstructors.asRaster(geom, raster, pixelType, value, noDataValue, false);
    }

    public static DefaultFeatureCollection getFeatureCollection(Geometry geom, CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName("Raster");
        simpleFeatureTypeBuilder.setCRS(crs);
        simpleFeatureTypeBuilder.add("geometry", Geometry.class);
        SimpleFeatureType featureType = simpleFeatureTypeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        featureBuilder.add((Object)geom);
        SimpleFeature simpleFeature = featureBuilder.buildFeature("1");
        DefaultFeatureCollection featureCollection = new DefaultFeatureCollection();
        featureCollection.add(simpleFeature);
        return featureCollection;
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double pixelSize) throws FactoryException {
        return RasterConstructors.makeEmptyRaster(numBand, widthInPixel, heightInPixel, upperLeftX, upperLeftY, pixelSize, -pixelSize, 0.0, 0.0, 0);
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, String dataType, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double pixelSize) throws FactoryException {
        return RasterConstructors.makeEmptyRaster(numBand, dataType, widthInPixel, heightInPixel, upperLeftX, upperLeftY, pixelSize, -pixelSize, 0.0, 0.0, 0);
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid) throws FactoryException {
        return RasterConstructors.makeEmptyRaster(numBand, "d", widthInPixel, heightInPixel, upperLeftX, upperLeftY, scaleX, scaleY, skewX, skewY, srid);
    }

    public static GridCoverage2D makeEmptyRaster(int numBand, String bandDataType, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid) throws FactoryException {
        Object crs = srid == 0 ? DefaultEngineeringCRS.GENERIC_2D : FunctionsGeoTools.sridToCRS(srid);
        WritableRaster raster = RasterFactory.createBandedRaster((int)RasterUtils.getDataTypeCode(bandDataType), (int)widthInPixel, (int)heightInPixel, (int)numBand, null);
        AffineTransform2D transform = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, widthInPixel, heightInPixel), PixelInCell.CELL_CORNER, (MathTransform)transform, (CoordinateReferenceSystem)crs, null);
        return RasterUtils.create(raster, gridGeometry, null, null);
    }

    public static GridCoverage2D makeNonEmptyRaster(int numBand, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid, double[][] data, Map<String, List<String>> properties, Double noDataValue, PixelInCell anchor) throws FactoryException {
        Object crs = srid == 0 ? DefaultEngineeringCRS.GENERIC_2D : CRS.decode((String)("EPSG:" + srid), (boolean)true);
        WritableRaster raster = RasterFactory.createBandedRaster((int)5, (int)widthInPixel, (int)heightInPixel, (int)numBand, null);
        for (int i = 0; i < numBand; ++i) {
            raster.setSamples(0, 0, widthInPixel, heightInPixel, i, data[i]);
        }
        AffineTransform2D transform = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, widthInPixel, heightInPixel), anchor, (MathTransform)transform, (CoordinateReferenceSystem)crs, null);
        return RasterUtils.create(raster, gridGeometry, null, noDataValue, properties);
    }

    public static GridCoverage2D makeNonEmptyRaster(int numBands, String bandDataType, int widthInPixel, int heightInPixel, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY, int srid, double[][] rasterValues) {
        Object crs = srid == 0 ? DefaultEngineeringCRS.GENERIC_2D : FunctionsGeoTools.sridToCRS(srid);
        WritableRaster raster = RasterFactory.createBandedRaster((int)RasterUtils.getDataTypeCode(bandDataType), (int)widthInPixel, (int)heightInPixel, (int)numBands, null);
        for (int i = 0; i < numBands; ++i) {
            raster.setSamples(0, 0, widthInPixel, heightInPixel, i, rasterValues[i]);
        }
        AffineTransform2D transform = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, widthInPixel, heightInPixel), PixelInCell.CELL_CORNER, (MathTransform)transform, (CoordinateReferenceSystem)crs, null);
        return RasterUtils.create(raster, gridGeometry, null);
    }

    public static Tile[] generateTiles(GridCoverage2D gridCoverage2D, int[] bandIndices, int tileWidth, int tileHeight, boolean padWithNoData, double padNoDataValue) {
        int numBands = gridCoverage2D.getNumSampleDimensions();
        if (bandIndices == null || bandIndices.length == 0) {
            bandIndices = new int[numBands];
            for (int i = 0; i < numBands; ++i) {
                bandIndices[i] = i + 1;
            }
        } else {
            for (int bandIndex : bandIndices) {
                if (bandIndex > 0 && bandIndex <= numBands) continue;
                throw new IllegalArgumentException(String.format("Provided band index %d is not present in the raster", bandIndex));
            }
        }
        return RasterConstructors.doGenerateTiles(gridCoverage2D, bandIndices, tileWidth, tileHeight, padWithNoData, padNoDataValue);
    }

    private static Tile[] doGenerateTiles(GridCoverage2D gridCoverage2D, int[] bandIndices, int tileWidth, int tileHeight, boolean padWithNoData, double padNoDataValue) {
        AffineTransform2D affine = RasterUtils.getAffineTransform(gridCoverage2D, PixelOrientation.CENTER);
        RenderedImage image = gridCoverage2D.getRenderedImage();
        double[] noDataValues = new double[bandIndices.length];
        for (int i = 0; i < bandIndices.length; ++i) {
            noDataValues[i] = RasterUtils.getNoDataValue(gridCoverage2D.getSampleDimension(bandIndices[i] - 1));
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int numTileX = (int)Math.ceil((double)width / (double)tileWidth);
        int numTileY = (int)Math.ceil((double)height / (double)tileHeight);
        Tile[] tiles = new Tile[numTileX * numTileY];
        for (int tileY = 0; tileY < numTileY; ++tileY) {
            for (int tileX = 0; tileX < numTileX; ++tileX) {
                int x0 = tileX * tileWidth;
                int y0 = tileY * tileHeight;
                int rectWidth = Math.min(tileWidth, width - x0);
                int rectHeight = Math.min(tileHeight, height - y0);
                int currentTileWidth = padWithNoData ? tileWidth : rectWidth;
                int currentTileHeight = padWithNoData ? tileHeight : rectHeight;
                boolean needPadding = padWithNoData && (rectWidth < tileWidth || rectHeight < tileHeight);
                AffineTransform2D tileAffine = RasterUtils.translateAffineTransform(affine, x0, y0);
                GridGeometry2D gridGeometry2D = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, currentTileWidth, currentTileHeight), PixelInCell.CELL_CENTER, (MathTransform)tileAffine, gridCoverage2D.getCoordinateReferenceSystem(), null);
                WritableRaster raster = RasterFactory.createBandedRaster((int)image.getSampleModel().getDataType(), (int)currentTileWidth, (int)currentTileHeight, (int)bandIndices.length, null);
                GridSampleDimension[] sampleDimensions = new GridSampleDimension[bandIndices.length];
                Raster sourceRaster = image.getData(new Rectangle(x0, y0, rectWidth, rectHeight));
                for (int k = 0; k < bandIndices.length; ++k) {
                    int bandIndex = bandIndices[k] - 1;
                    GridSampleDimension sampleDimension = gridCoverage2D.getSampleDimension(bandIndex);
                    double noDataValue = noDataValues[k];
                    if (needPadding && !Double.isNaN(padNoDataValue)) {
                        sampleDimension = RasterUtils.createSampleDimensionWithNoDataValue(sampleDimension, padNoDataValue);
                        noDataValue = padNoDataValue;
                    }
                    sampleDimensions[k] = sampleDimension;
                    ImageUtils.copyRasterWithPadding(sourceRaster, bandIndex, raster, k, noDataValue);
                }
                GridCoverage2D tile = RasterUtils.create(raster, gridGeometry2D, sampleDimensions);
                tiles[tileY * numTileX + tileX] = new Tile(tileX, tileY, tile);
            }
        }
        return tiles;
    }

    public static GridCoverage2D[] rsTile(GridCoverage2D gridCoverage2D, int[] bandIndices, int tileWidth, int tileHeight, boolean padWithNoData, Double padNoDataValue) {
        if (gridCoverage2D == null) {
            return null;
        }
        if (padNoDataValue == null) {
            padNoDataValue = Double.NaN;
        }
        Tile[] tiles = RasterConstructors.generateTiles(gridCoverage2D, bandIndices, tileWidth, tileHeight, padWithNoData, padNoDataValue);
        GridCoverage2D[] result = new GridCoverage2D[tiles.length];
        for (int i = 0; i < tiles.length; ++i) {
            result[i] = tiles[i].getCoverage();
        }
        return result;
    }

    public static GridCoverage2D[] rsTile(GridCoverage2D gridCoverage2D, int[] bandIndices, int tileWidth, int tileHeight, boolean padWithNoData) {
        return RasterConstructors.rsTile(gridCoverage2D, bandIndices, tileWidth, tileHeight, padWithNoData, Double.NaN);
    }

    public static GridCoverage2D[] rsTile(GridCoverage2D gridCoverage2D, int[] bandIndices, int tileWidth, int tileHeight) {
        return RasterConstructors.rsTile(gridCoverage2D, bandIndices, tileWidth, tileHeight, false);
    }

    public static GridCoverage2D[] rsTile(GridCoverage2D gridCoverage2D, int tileWidth, int tileHeight) {
        return RasterConstructors.rsTile(gridCoverage2D, null, tileWidth, tileHeight);
    }

    public static class Tile {
        private final int tileX;
        private final int tileY;
        private final GridCoverage2D coverage;

        public Tile(int tileX, int tileY, GridCoverage2D coverage) {
            this.tileX = tileX;
            this.tileY = tileY;
            this.coverage = coverage;
        }

        public int getTileX() {
            return this.tileX;
        }

        public int getTileY() {
            return this.tileY;
        }

        public GridCoverage2D getCoverage() {
            return this.coverage;
        }
    }
}

