/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.point.remote.PointDatasetRemote;
import ucar.nc2.ft.point.writer.FeatureDatasetCapabilitiesWriter;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.ft2.coverage.remote.CdmrfReader;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.Optional;
import ucar.unidata.geoloc.LatLonRect;

public class CdmrFeatureDataset {
    public static final String PROTOCOL = "cdmrFeature";
    public static final String SCHEME = "cdmrFeature:";
    private static boolean debug;
    private static boolean showXML;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FeatureType isCdmrfEndpoint(String endpoint) throws IOException {
        HTTPSession httpClient = HTTPFactory.newSession(endpoint);
        String url = endpoint + "?req=featureType";
        try (HTTPMethod method = HTTPFactory.Get(httpClient, url);){
            method.setFollowRedirects(true);
            int statusCode = method.execute();
            if (statusCode != 200) {
                FeatureType featureType2 = null;
                return featureType2;
            }
            String content = method.getResponseAsString();
            FeatureType featureType = FeatureType.getType(content);
            return featureType;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static Optional<FeatureDataset> factory(FeatureType wantFeatureType, String endpoint) throws IOException {
        FeatureType featureType;
        if (endpoint.startsWith(SCHEME)) {
            endpoint = endpoint.substring(SCHEME.length());
        }
        try {
            featureType = CdmrFeatureDataset.isCdmrfEndpoint(endpoint);
            if (featureType == null) {
                return Optional.empty("Not a valid CdmrFeatureDataset endpoint=" + endpoint);
            }
        }
        catch (IOException ioe) {
            return Optional.empty(String.format("Error opening CdmrFeatureDataset endpoint=%s err=%s", endpoint, ioe.getMessage()));
        }
        if (!FeatureDatasetFactoryManager.featureTypeOk(wantFeatureType, featureType)) {
            return Optional.empty(String.format("Not a compatible featureType=%s, want=%s, endpoint=%s", new Object[]{featureType, wantFeatureType, endpoint}));
        }
        if (featureType.isCoverageFeatureType()) {
            CdmrfReader reader = new CdmrfReader(endpoint);
            CoverageCollection covColl = reader.open();
            return Optional.of(new FeatureDatasetCoverage(endpoint, covColl, covColl));
        }
        if (featureType.isPointFeatureType()) {
            Document doc = CdmrFeatureDataset.getCapabilities(endpoint);
            Element root = doc.getRootElement();
            Element elem = root.getChild("featureDataset");
            String fType = elem.getAttribute("type").getValue();
            endpoint = elem.getAttribute("url").getValue();
            wantFeatureType = FeatureType.getType(fType);
            if (debug) {
                System.out.printf("CdmrFeatureDataset endpoint %s%n ftype= '%s' url=%s%n", endpoint, fType, endpoint);
            }
            List<VariableSimpleIF> dataVars = FeatureDatasetCapabilitiesWriter.getDataVariables(doc);
            LatLonRect bb = FeatureDatasetCapabilitiesWriter.getSpatialExtent(doc);
            CalendarDateRange dr = FeatureDatasetCapabilitiesWriter.getTimeSpan(doc);
            CalendarDateUnit timeUnit = FeatureDatasetCapabilitiesWriter.getTimeUnit(doc);
            String altUnits = FeatureDatasetCapabilitiesWriter.getAltUnits(doc);
            return Optional.of(new PointDatasetRemote(wantFeatureType, endpoint, timeUnit, altUnits, dataVars, bb, dr));
        }
        return Optional.empty(String.format("Unimplemented featureType=%s, want=%s, endpoint=%s", new Object[]{featureType, wantFeatureType, endpoint}));
    }

    private static Document getCapabilities(String endpoint) throws IOException {
        Document doc;
        try (InputStream in = CdmRemote.sendQuery(null, endpoint, "req=capabilities");){
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            doc = builder.build(in);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        if (showXML) {
            System.out.printf("*** endpoint = %s %n", endpoint);
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.printf("*** CdmrFeatureDataset/showParsedXML = %n %s %n", xmlOut.outputString(doc));
        }
        return doc;
    }
}

