/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.core;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.sedona.viz.core.ImageSerializableWrapper;
import org.apache.sedona.viz.utils.ImageType;
import org.apache.sedona.viz.utils.RasterizationUtils;
import org.apache.sedona.viz.utils.S3Operator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import scala.Tuple2;

public class ImageGenerator
implements Serializable {
    static final Logger logger = Logger.getLogger(ImageGenerator.class);

    public boolean SaveRasterImageAsLocalFile(JavaPairRDD<Integer, ImageSerializableWrapper> distributedImage, final String outputPath, final ImageType imageType, final int zoomLevel, final int partitionOnX, final int partitionOnY) throws Exception {
        logger.info((Object)"[Sedona-Viz][SaveRasterImageAsLocalFile][Start]");
        for (int i = 0; i < partitionOnX * partitionOnY; ++i) {
            this.deleteLocalFile(outputPath + "-" + RasterizationUtils.getImageTileName(zoomLevel, partitionOnX, partitionOnY, i), imageType);
        }
        distributedImage.foreach((VoidFunction)new VoidFunction<Tuple2<Integer, ImageSerializableWrapper>>(){

            public void call(Tuple2<Integer, ImageSerializableWrapper> integerImageSerializableWrapperTuple2) throws Exception {
                ImageGenerator.this.SaveRasterImageAsLocalFile(((ImageSerializableWrapper)integerImageSerializableWrapperTuple2._2).image, outputPath + "-" + RasterizationUtils.getImageTileName(zoomLevel, partitionOnX, partitionOnY, (Integer)integerImageSerializableWrapperTuple2._1), imageType);
            }
        });
        logger.info((Object)"[Sedona-Viz][SaveRasterImageAsLocalFile][Stop]");
        return true;
    }

    public boolean SaveRasterImageAsLocalFile(JavaPairRDD<Integer, ImageSerializableWrapper> distributedImage, String outputPath, ImageType imageType) throws Exception {
        List imagePartitions = distributedImage.collect();
        for (Tuple2 imagePartition : imagePartitions) {
            this.SaveRasterImageAsLocalFile(((ImageSerializableWrapper)imagePartition._2).image, outputPath + "-" + imagePartition._1, imageType);
        }
        return true;
    }

    public boolean SaveRasterImageAsHadoopFile(JavaPairRDD<Integer, ImageSerializableWrapper> distributedImage, final String outputPath, final ImageType imageType, final int zoomLevel, final int partitionOnX, final int partitionOnY) throws Exception {
        logger.info((Object)"[Sedona-Viz][SaveRasterImageAsHadoopFile][Start]");
        for (int i = 0; i < partitionOnX * partitionOnY; ++i) {
            this.deleteHadoopFile(outputPath + "-" + RasterizationUtils.getImageTileName(zoomLevel, partitionOnX, partitionOnY, i) + ".", imageType);
        }
        distributedImage.foreach((VoidFunction)new VoidFunction<Tuple2<Integer, ImageSerializableWrapper>>(){

            public void call(Tuple2<Integer, ImageSerializableWrapper> integerImageSerializableWrapperTuple2) throws Exception {
                ImageGenerator.this.SaveRasterImageAsHadoopFile(((ImageSerializableWrapper)integerImageSerializableWrapperTuple2._2).image, outputPath + "-" + RasterizationUtils.getImageTileName(zoomLevel, partitionOnX, partitionOnY, (Integer)integerImageSerializableWrapperTuple2._1), imageType);
            }
        });
        logger.info((Object)"[Sedona-Viz][SaveRasterImageAsHadoopFile][Stop]");
        return true;
    }

    public boolean SaveRasterImageAsS3File(JavaPairRDD<Integer, ImageSerializableWrapper> distributedImage, final String regionName, final String accessKey, final String secretKey, final String bucketName, final String path, final ImageType imageType, final int zoomLevel, final int partitionOnX, final int partitionOnY) {
        logger.info((Object)"[Sedona-Viz][SaveRasterImageAsS3File][Start]");
        S3Operator s3Operator = new S3Operator(regionName, accessKey, secretKey);
        for (int i = 0; i < partitionOnX * partitionOnY; ++i) {
            s3Operator.deleteImage(bucketName, path + "-" + RasterizationUtils.getImageTileName(zoomLevel, partitionOnX, partitionOnY, i) + "." + imageType.getTypeName());
        }
        distributedImage.foreach((VoidFunction)new VoidFunction<Tuple2<Integer, ImageSerializableWrapper>>(){

            public void call(Tuple2<Integer, ImageSerializableWrapper> integerImageSerializableWrapperTuple2) throws Exception {
                ImageGenerator.this.SaveRasterImageAsS3File(((ImageSerializableWrapper)integerImageSerializableWrapperTuple2._2).image, regionName, accessKey, secretKey, bucketName, path + "-" + RasterizationUtils.getImageTileName(zoomLevel, partitionOnX, partitionOnY, (Integer)integerImageSerializableWrapperTuple2._1), imageType);
            }
        });
        logger.info((Object)"[Sedona-Viz][SaveRasterImageAsS3File][Stop]");
        return true;
    }

    public boolean SaveRasterImageAsLocalFile(BufferedImage rasterImage, String outputPath, ImageType imageType) throws Exception {
        logger.info((Object)"[Sedona-Viz][SaveRasterImageAsLocalFile][Start]");
        File outputImage = new File(outputPath + "." + imageType.getTypeName());
        outputImage.getParentFile().mkdirs();
        try {
            ImageIO.write((RenderedImage)rasterImage, imageType.getTypeName(), outputImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info((Object)"[Sedona-Viz][SaveRasterImageAsLocalFile][Stop]");
        return true;
    }

    public boolean SaveRasterImageAsHadoopFile(BufferedImage rasterImage, String originalOutputPath, ImageType imageType) throws Exception {
        logger.info((Object)"[Sedona-Viz][SaveRasterImageAsHadoopFile][Start]");
        String outputPath = originalOutputPath + "." + imageType.getTypeName();
        String[] splitString = outputPath.split(":");
        String hostName = splitString[0] + ":" + splitString[1];
        String[] portAndPath = splitString[2].split("/");
        String port = portAndPath[0];
        String localPath = "";
        for (int i = 1; i < portAndPath.length; ++i) {
            localPath = localPath + "/" + portAndPath[i];
        }
        localPath = localPath + "." + imageType.getTypeName();
        Configuration hadoopConf = new Configuration();
        logger.info((Object)("[Sedona-Viz][SaveRasterImageAsSparkFile] HDFS URI BASE: " + hostName + ":" + port));
        FileSystem hdfs = FileSystem.get((URI)new URI(hostName + ":" + port), (Configuration)hadoopConf);
        logger.info((Object)("[Sedona-Viz][SaveRasterImageAsSparkFile] Check the existence of path: " + localPath));
        if (hdfs.exists(new Path(localPath))) {
            logger.info((Object)("[Sedona-Viz][SaveRasterImageAsSparkFile] Deleting path: " + localPath));
            hdfs.delete(new Path(localPath), true);
            logger.info((Object)("[Sedona-Viz][SaveRasterImageAsSparkFile] Deleted path: " + localPath));
        }
        Path path = new Path(outputPath);
        FSDataOutputStream out = hdfs.create(path);
        ImageIO.write((RenderedImage)rasterImage, "png", (OutputStream)out);
        out.close();
        hdfs.close();
        logger.info((Object)"[Sedona-Viz][SaveRasterImageAsHadoopFile][Stop]");
        return true;
    }

    public boolean SaveRasterImageAsS3File(BufferedImage rasterImage, String regionName, String accessKey, String secretKey, String bucketName, String path, ImageType imageType) throws IOException {
        logger.info((Object)"[Sedona-Viz][SaveRasterImageAsS3File][Start]");
        S3Operator s3Operator = new S3Operator(regionName, accessKey, secretKey);
        s3Operator.putImage(bucketName, path + "." + imageType.getTypeName(), rasterImage);
        logger.info((Object)"[Sedona-Viz][SaveRasterImageAsS3File][Stop]");
        return true;
    }

    public boolean SaveVectorImageAsLocalFile(JavaPairRDD<Integer, String> distributedImage, String outputPath, ImageType imageType) throws Exception {
        logger.info((Object)"[Sedona-Viz][SaveVectormageAsLocalFile][Start]");
        JavaRDD distributedVectorImageNoKey = distributedImage.map((Function)new Function<Tuple2<Integer, String>, String>(){

            public String call(Tuple2<Integer, String> vectorObject) throws Exception {
                return (String)vectorObject._2();
            }
        });
        this.SaveVectorImageAsLocalFile(distributedVectorImageNoKey.collect(), outputPath, imageType);
        logger.info((Object)"[Sedona-Viz][SaveVectormageAsLocalFile][Stop]");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SaveVectorImageAsLocalFile(List<String> vectorImage, String outputPath, ImageType imageType) throws Exception {
        logger.info((Object)"[Sedona-Viz][SaveVectorImageAsLocalFile][Start]");
        File outputImage = new File(outputPath + "." + imageType.getTypeName());
        outputImage.getParentFile().mkdirs();
        BufferedWriter bw = null;
        FileWriter fw = null;
        try {
            fw = new FileWriter(outputImage);
            bw = new BufferedWriter(fw);
            for (String svgElement : vectorImage) {
                bw.write(svgElement);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        logger.info((Object)"[Sedona-Viz][SaveVectorImageAsLocalFile][Stop]");
        return true;
    }

    public boolean deleteHadoopFile(String originalOutputPath, ImageType imageType) throws Exception {
        String outputPath = originalOutputPath + "." + imageType.getTypeName();
        String[] splitString = outputPath.split(":");
        String hostName = splitString[0] + ":" + splitString[1];
        String[] portAndPath = splitString[2].split("/");
        String port = portAndPath[0];
        String localPath = "";
        for (int i = 1; i < portAndPath.length; ++i) {
            localPath = localPath + "/" + portAndPath[i];
        }
        localPath = localPath + "." + imageType.getTypeName();
        Configuration hadoopConf = new Configuration();
        logger.info((Object)("[Sedona-Viz][SaveRasterImageAsSparkFile] HDFS URI BASE: " + hostName + ":" + port));
        FileSystem hdfs = FileSystem.get((URI)new URI(hostName + ":" + port), (Configuration)hadoopConf);
        logger.info((Object)("[Sedona-Viz][SaveRasterImageAsSparkFile] Check the existence of path: " + localPath));
        if (hdfs.exists(new Path(localPath))) {
            logger.info((Object)("[Sedona-Viz][SaveRasterImageAsSparkFile] Deleting path: " + localPath));
            hdfs.delete(new Path(localPath), true);
            logger.info((Object)("[Sedona-Viz][SaveRasterImageAsSparkFile] Deleted path: " + localPath));
        }
        return true;
    }

    public boolean deleteLocalFile(String originalOutputPath, ImageType imageType) {
        File file = null;
        try {
            file = new File(originalOutputPath + "." + imageType.getTypeName());
            file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

