/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.StationTimeSeriesFeatureImpl;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.util.StringUtil2;

public class CoverageAsPoint {
    private static final boolean debug = false;
    private CoverageCollection gcd;
    private List<VarData> varData;
    private SubsetParams subset;
    private LatLonPoint latLonPoint;
    private LatLonPoint nearestLatLonPoint;
    private CalendarDateUnit dateUnit;

    public CoverageAsPoint(CoverageCollection gcd, List<String> varNames, SubsetParams subset) throws IOException {
        this.gcd = gcd;
        this.subset = subset;
        this.latLonPoint = (LatLonPoint)subset.get("latlonPoint");
        if (this.latLonPoint == null) {
            throw new IllegalArgumentException("No latlon point");
        }
        this.varData = new ArrayList<VarData>(varNames.size());
        for (String varName : varNames) {
            Coverage cov = gcd.findCoverage(varName);
            if (cov == null) continue;
            this.varData.add(new VarData(cov));
            if (this.dateUnit == null) {
                CoverageCoordSys csys = cov.getCoordSys();
                CoverageCoordAxis timeAxis = csys.getTimeAxis();
                this.dateUnit = timeAxis.getCalendarDateUnit();
            }
            if (this.nearestLatLonPoint != null) continue;
            CoverageCoordSys subsetCs = this.varData.get((int)0).array.getCoordSysForData();
            this.nearestLatLonPoint = subsetCs.getHorizCoordSys().getLatLon(0, 0);
        }
    }

    public FeatureDatasetPoint asFeatureDatasetPoint() {
        return new CoverageAsFeatureDatasetPoint(FeatureType.STATION);
    }

    private class MyStationFeature
    extends StationTimeSeriesFeatureImpl {
        MyStationFeature(String name, String desc, String wmoId, double lat, double lon, double alt, CalendarDateUnit timeUnit, String altUnits, int npts) {
            super(name, desc, wmoId, lat, lon, alt, timeUnit, altUnits, npts, StructureData.EMPTY);
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() {
            return StructureData.EMPTY;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator() {
            return new TimeseriesIterator();
        }

        private class MyPointFeature
        extends PointFeatureImpl
        implements StationPointFeature {
            StationFeature stn;
            StructureData sdata;

            MyPointFeature(StationFeature stn, double obsTime, double nomTime, CalendarDateUnit timeUnit, StructureData sdata) {
                super(MyStationFeature.this, stn, obsTime, nomTime, timeUnit);
                this.stn = stn;
                this.sdata = sdata;
            }

            @Override
            @Nonnull
            public StationFeature getStation() {
                return this.stn;
            }

            @Override
            @Nonnull
            public StructureData getFeatureData() {
                return this.sdata;
            }

            @Override
            @Nonnull
            public StructureData getDataAll() {
                return this.sdata;
            }
        }

        private class TimeseriesIterator
        extends PointIteratorAbstract {
            int curr;
            int nvalues;
            List<VarIter> varIters = new ArrayList<VarIter>();
            CoverageCoordAxis1D timeAxis;

            TimeseriesIterator() {
                for (VarData vd : CoverageAsPoint.this.varData) {
                    Array data = vd.array.getData();
                    this.varIters.add(new VarIter(vd.cov, vd.array, data.getIndexIterator()));
                    this.nvalues = (int)data.getSize();
                    if (this.timeAxis != null) continue;
                    CoverageCoordSys csys = vd.array.getCoordSysForData();
                    this.timeAxis = (CoverageCoordAxis1D)csys.getTimeAxis();
                }
            }

            @Override
            public boolean hasNext() {
                boolean more;
                boolean bl = more = this.curr < this.nvalues;
                if (!more) {
                    this.close();
                }
                return more;
            }

            @Override
            public PointFeature next() {
                double obsTime = this.timeAxis.getCoordMidpoint(this.curr);
                StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
                for (VarIter vi : this.varIters) {
                    smb.addMemberScalar(vi.cov.getName(), null, null, vi.cov.getDataType(), (Number)vi.dataIter.getObjectNext());
                }
                StructureDataFromMember coords = new StructureDataFromMember(smb.build());
                ++this.curr;
                MyPointFeature pf = new MyPointFeature(MyStationFeature.this, obsTime, 0.0, MyStationFeature.this.timeUnit, coords);
                this.calcBounds(pf);
                return pf;
            }

            @Override
            public void close() {
                this.finishCalcBounds();
            }
        }

        private class VarIter {
            Coverage cov;
            GeoReferencedArray geoA;
            IndexIterator dataIter;

            VarIter(Coverage cov, GeoReferencedArray array, IndexIterator dataIter) {
                this.cov = cov;
                this.geoA = array;
                this.dataIter = dataIter;
            }
        }
    }

    private class CoverageAsStationFeatureCollection
    extends StationTimeSeriesCollectionImpl {
        CoverageAsStationFeatureCollection(String name, CalendarDateUnit dateUnit, String altUnits) {
            super(name, dateUnit, altUnits);
        }

        @Override
        protected StationHelper createStationHelper() {
            StationHelper helper = new StationHelper();
            String name = String.format("GridPointRequestedAt[%s]", LatLonPoints.toString(CoverageAsPoint.this.latLonPoint, 3));
            name = StringUtil2.replace(name.trim(), ' ', "_");
            helper.addStation(new MyStationFeature(name, name, null, CoverageAsPoint.this.nearestLatLonPoint.getLatitude(), CoverageAsPoint.this.nearestLatLonPoint.getLongitude(), 0.0, CoverageAsPoint.this.dateUnit, null, -1));
            return helper;
        }
    }

    private class CoverageAsFeatureDatasetPoint
    extends PointDatasetImpl {
        CoverageAsFeatureDatasetPoint(FeatureType featureType) {
            super(featureType);
            CoverageAsStationFeatureCollection fc = new CoverageAsStationFeatureCollection(CoverageAsPoint.this.gcd.getName() + " AsStationFeatureCollection", CoverageAsPoint.this.dateUnit, null);
            this.setPointFeatureCollection(fc);
            ArrayList<VariableSimpleIF> dataVars = new ArrayList<VariableSimpleIF>();
            for (VarData vd : CoverageAsPoint.this.varData) {
                VariableSimpleIF simple = VariableSimpleBuilder.makeScalar(vd.cov.getName(), vd.cov.getDescription(), vd.cov.getUnitsString(), vd.cov.getDataType()).build();
                dataVars.add(simple);
            }
            this.dataVariables = dataVars;
        }
    }

    private class VarData {
        Coverage cov;
        GeoReferencedArray array;

        VarData(Coverage cov) throws IOException {
            this.cov = cov;
            try {
                this.array = cov.readData(CoverageAsPoint.this.subset);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        }
    }
}

