/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.utils;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.enums.JoinBuildSide;
import org.apache.sedona.core.enums.JoinSparitionDominantSide;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.locationtech.jts.geom.Envelope;

public class SedonaConf
implements Serializable {
    private boolean useIndex;
    private IndexType indexType;
    private JoinSparitionDominantSide joinSparitionDominantSide;
    private JoinBuildSide joinBuildSide;
    private long joinApproximateTotalCount;
    private Envelope datasetBoundary;
    private int fallbackPartitionNum;
    private GridType joinGridType;

    public static SedonaConf fromActiveSession() {
        return new SedonaConf(SparkSession.active().conf());
    }

    public SedonaConf(RuntimeConfig runtimeConfig) {
        this.useIndex = Boolean.parseBoolean(runtimeConfig.get("sedona.global.index", "true"));
        this.indexType = IndexType.getIndexType(runtimeConfig.get("sedona.global.indextype", "quadtree"));
        this.joinApproximateTotalCount = Long.parseLong(runtimeConfig.get("sedona.join.approxcount", "-1"));
        String[] boundaryString = runtimeConfig.get("sedona.join.boundary", "0,0,0,0").split(",");
        this.datasetBoundary = new Envelope(Double.parseDouble(boundaryString[0]), Double.parseDouble(boundaryString[1]), Double.parseDouble(boundaryString[2]), Double.parseDouble(boundaryString[3]));
        this.joinGridType = GridType.getGridType(runtimeConfig.get("sedona.join.gridtype", "kdbtree"));
        this.joinBuildSide = JoinBuildSide.getBuildSide(runtimeConfig.get("sedona.join.indexbuildside", "left"));
        this.joinSparitionDominantSide = JoinSparitionDominantSide.getJoinSparitionDominantSide(runtimeConfig.get("sedona.join.spatitionside", "left"));
        this.fallbackPartitionNum = Integer.parseInt(runtimeConfig.get("sedona.join.numpartition", "-1"));
    }

    public boolean getUseIndex() {
        return this.useIndex;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public long getJoinApproximateTotalCount() {
        return this.joinApproximateTotalCount;
    }

    public Envelope getDatasetBoundary() {
        return this.datasetBoundary;
    }

    public JoinBuildSide getJoinBuildSide() {
        return this.joinBuildSide;
    }

    public GridType getJoinGridType() {
        return this.joinGridType;
    }

    public JoinSparitionDominantSide getJoinSparitionDominantSide() {
        return this.joinSparitionDominantSide;
    }

    public int getFallbackPartitionNum() {
        return this.fallbackPartitionNum;
    }

    public String toString() {
        try {
            Field[] fields;
            String sb = "";
            Class<?> objClass = this.getClass();
            sb = sb + "Sedona Configuration:\n";
            for (Field field : fields = objClass.getDeclaredFields()) {
                String name = field.getName();
                Object value = field.get(this);
                sb = sb + name + ": " + value.toString() + "\n";
            }
            return sb;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

