/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.expressions.simplify;

import org.apache.spark.sql.sedona_sql.expressions.simplify.CoordinatesSplitter;
import org.apache.spark.sql.sedona_sql.expressions.simplify.SimplifyingParameters;
import org.locationtech.jts.geom.Coordinate;
import scala.Function1;
import scala.Serializable;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

public final class CoordinatesSplitter$
implements SimplifyingParameters {
    public static CoordinatesSplitter$ MODULE$;
    private final double DBL_EPSILON;

    static {
        new CoordinatesSplitter$();
    }

    @Override
    public double DBL_EPSILON() {
        return this.DBL_EPSILON;
    }

    @Override
    public void org$apache$spark$sql$sedona_sql$expressions$simplify$SimplifyingParameters$_setter_$DBL_EPSILON_$eq(double x$1) {
        this.DBL_EPSILON = x$1;
    }

    public CoordinatesSplitter.SplitInPlace splitInPlace(Coordinate[] geom, int itFirst, int itLast, double maxDistanceSquared) {
        IntRef split = IntRef.create((int)itFirst);
        DoubleRef maxDistance = DoubleRef.create((double)maxDistanceSquared);
        Object object = itFirst - itLast < 2 ? new CoordinatesSplitter.SplitInPlace(geom, itFirst) : BoxedUnit.UNIT;
        Coordinate pointA = geom[itFirst];
        Coordinate pointB = geom[itLast];
        if (this.calcualteSquaredDistance(pointA, pointB) < this.DBL_EPSILON()) {
            package$.MODULE$.Range().apply(itFirst + 1, itLast).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)itk -> {
                block0: {
                    Coordinate pk = geom[itk];
                    double squaredDistance = MODULE$.calcualteSquaredDistance(pk, pointA);
                    if (!(squaredDistance > maxDistance$1.elem)) break block0;
                    split$1.elem = itk;
                    maxDistance$1.elem = squaredDistance;
                }
            });
        }
        double ba_x = pointB.x - pointA.x;
        double ba_y = pointB.y - pointA.y;
        double ab_length_sqr = ba_x * ba_x + ba_y * ba_y;
        maxDistance.elem *= ab_length_sqr;
        package$.MODULE$.Range().apply(itFirst + 1, itLast).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)itk -> {
            block4: {
                Coordinate c = geom[itk];
                double distance_sqr = 0.0;
                double ca_x = c.x - pointA$1.x;
                double ca_y = c.y - pointA$1.y;
                double dot_ac_ab = ca_x * ba_x + ca_y * ba_y;
                if (dot_ac_ab <= 0.0) {
                    distance_sqr = MODULE$.calcualteSquaredDistance(c, pointA) * ab_length_sqr;
                } else if (dot_ac_ab >= ab_length_sqr) {
                    distance_sqr = MODULE$.calcualteSquaredDistance(c, pointB) * ab_length_sqr;
                } else {
                    double s_numerator = ca_x * ba_y - ca_y * ba_x;
                    distance_sqr = s_numerator * s_numerator;
                }
                if (!(distance_sqr > maxDistance$1.elem)) break block4;
                split$1.elem = itk;
                maxDistance$1.elem = distance_sqr;
            }
        });
        return new CoordinatesSplitter.SplitInPlace(geom, split.elem);
    }

    private double calcualteSquaredDistance(Coordinate geomA, Coordinate geomB) {
        double distance = geomA.distance(geomB);
        return distance * distance;
    }

    private CoordinatesSplitter$() {
        MODULE$ = this;
        SimplifyingParameters.$init$(this);
    }
}

