/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.app.config.ConnectorDataSourceMapperConfig;
import org.apache.seatunnel.app.dal.dao.IJobLineDao;
import org.apache.seatunnel.app.dal.dao.IJobTaskDao;
import org.apache.seatunnel.app.dal.dao.IJobVersionDao;
import org.apache.seatunnel.app.dal.entity.JobLine;
import org.apache.seatunnel.app.dal.entity.JobTask;
import org.apache.seatunnel.app.dal.entity.JobVersion;
import org.apache.seatunnel.app.domain.request.connector.SceneMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.DatabaseTableSchemaReq;
import org.apache.seatunnel.app.domain.request.job.Edge;
import org.apache.seatunnel.app.domain.request.job.JobDAG;
import org.apache.seatunnel.app.domain.request.job.JobTaskInfo;
import org.apache.seatunnel.app.domain.request.job.PluginConfig;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.request.job.transform.Copy;
import org.apache.seatunnel.app.domain.request.job.transform.CopyTransformOptions;
import org.apache.seatunnel.app.domain.request.job.transform.FieldMapperTransformOptions;
import org.apache.seatunnel.app.domain.request.job.transform.RenameField;
import org.apache.seatunnel.app.domain.request.job.transform.SQLTransformOptions;
import org.apache.seatunnel.app.domain.request.job.transform.SplitTransformOptions;
import org.apache.seatunnel.app.domain.request.job.transform.Transform;
import org.apache.seatunnel.app.domain.request.job.transform.TransformOption;
import org.apache.seatunnel.app.domain.request.job.transform.TransformOptions;
import org.apache.seatunnel.app.domain.response.job.JobTaskCheckRes;
import org.apache.seatunnel.app.domain.response.job.SchemaError;
import org.apache.seatunnel.app.domain.response.job.SchemaErrorType;
import org.apache.seatunnel.app.service.IDatasourceService;
import org.apache.seatunnel.app.service.IJobInstanceService;
import org.apache.seatunnel.app.service.IJobTaskService;
import org.apache.seatunnel.app.service.impl.SeatunnelBaseServiceImpl;
import org.apache.seatunnel.app.utils.TaskOptionUtils;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.server.common.CodeGenerateUtils;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobTaskServiceImpl
extends SeatunnelBaseServiceImpl
implements IJobTaskService {
    private static final Logger log = LoggerFactory.getLogger(JobTaskServiceImpl.class);
    @Resource(name="jobLineDaoImpl")
    private IJobLineDao jobLineDao;
    @Resource(name="jobTaskDaoImpl")
    private IJobTaskDao jobTaskDao;
    @Resource(name="jobVersionDaoImpl")
    private IJobVersionDao jobVersionDao;
    @Resource
    private IDatasourceService datasourceService;
    @Resource
    private IJobInstanceService jobInstanceService;
    @Resource
    private ConnectorDataSourceMapperConfig connectorDataSourceMapperConfig;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private void checkConfigIntegrity(JobVersion version, JobTaskInfo jobTaskInfo) {
        if (StringUtils.isEmpty((CharSequence)version.getEnv())) {
            throw new SeatunnelException(SeatunnelErrorEnum.ERROR_CONFIG, new Object[]{"job env can't be empty, please change config"});
        }
        Map pluginConfigMap = jobTaskInfo.getPlugins().stream().collect(Collectors.toMap(PluginConfig::getPluginId, Function.identity()));
        List allPluginIdsFromEdge = Stream.concat(jobTaskInfo.getEdges().stream().map(Edge::getInputPluginId), jobTaskInfo.getEdges().stream().map(Edge::getTargetPluginId)).collect(Collectors.toList());
        jobTaskInfo.getPlugins().stream().filter(p -> !allPluginIdsFromEdge.contains(p.getPluginId())).findAny().ifPresent(p -> {
            throw new SeatunnelException(SeatunnelErrorEnum.ERROR_CONFIG, new Object[]{"plugin '" + p.getName() + "' is not used in any edge"});
        });
        jobTaskInfo.getEdges().forEach(e -> {
            jobTaskInfo.getPlugins().stream().filter(p -> Objects.equals(p.getPluginId(), e.getInputPluginId())).findFirst().orElseThrow(() -> new SeatunnelException(SeatunnelErrorEnum.ERROR_CONFIG, new Object[]{"input plugin not found"}));
            jobTaskInfo.getPlugins().stream().filter(p -> Objects.equals(p.getPluginId(), e.getTargetPluginId())).findFirst().orElseThrow(() -> new SeatunnelException(SeatunnelErrorEnum.ERROR_CONFIG, new Object[]{"target plugin not found"}));
        });
        List inputTransformId = jobTaskInfo.getEdges().stream().map(Edge::getInputPluginId).filter(e -> ((PluginConfig)pluginConfigMap.get(e)).getType().equals((Object)PluginType.TRANSFORM)).collect(Collectors.toList());
        List targetTransformId = jobTaskInfo.getEdges().stream().map(Edge::getTargetPluginId).filter(e -> ((PluginConfig)pluginConfigMap.get(e)).getType().equals((Object)PluginType.TRANSFORM)).collect(Collectors.toList());
        if (!new HashSet(inputTransformId).containsAll(targetTransformId) || !new HashSet(targetTransformId).containsAll(inputTransformId)) {
            throw new SeatunnelException(SeatunnelErrorEnum.ERROR_CONFIG, new Object[]{"transform plugin must be connected"});
        }
        for (Edge edge : jobTaskInfo.getEdges()) {
            if (this.pluginTypeMatch(((PluginConfig)pluginConfigMap.get(edge.getInputPluginId())).getType(), ((PluginConfig)pluginConfigMap.get(edge.getTargetPluginId())).getType())) continue;
            throw new SeatunnelException(SeatunnelErrorEnum.ERROR_CONFIG, new Object[]{"plugin line not match, please check plugin line"});
        }
    }

    private boolean pluginTypeMatch(PluginType inputType, PluginType outputType) {
        if (inputType == PluginType.SOURCE) {
            return outputType != PluginType.SOURCE;
        }
        if (inputType == PluginType.SINK) {
            return false;
        }
        if (inputType == PluginType.TRANSFORM) {
            return outputType != PluginType.SOURCE;
        }
        return false;
    }

    private static void checkConfigFormat(String config) {
        if (StringUtils.isNotEmpty((CharSequence)config)) {
            ConfigFactory.parseString((String)config);
        }
    }

    @Override
    public JobTaskInfo getTaskConfig(long jobVersionId) {
        this.funcPermissionCheck("project:seatunnel-task:job-detail", 0);
        List<JobTask> tasks = this.jobTaskDao.getTasksByVersionId(jobVersionId);
        if (tasks.isEmpty()) {
            return null;
        }
        List<JobLine> lines = this.jobLineDao.getLinesByVersionId(jobVersionId);
        return new JobTaskInfo(lines.stream().map(l -> new Edge(l.getInputPluginId(), l.getTargetPluginId())).collect(Collectors.toList()), tasks.stream().map(t -> {
            try {
                return JobTaskServiceImpl.getPluginConfigFromJobTask(t);
            }
            catch (Exception e) {
                throw new SeatunnelException(SeatunnelErrorEnum.UNKNOWN, new Object[]{e.getMessage()});
            }
        }).collect(Collectors.toList()));
    }

    @Override
    @Transactional
    public JobTaskCheckRes saveJobDAG(long jobVersionId, JobDAG jobDAG) {
        this.funcPermissionCheck("project:seatunnel-task:job-dag-create", 0);
        JobVersion version = this.jobVersionDao.getVersionById(jobVersionId);
        List<JobTask> tasks = this.jobTaskDao.getTasksByVersionId(jobVersionId);
        List<PluginConfig> pluginConfigs = tasks.stream().map(JobTaskServiceImpl::getPluginConfigFromJobTask).collect(Collectors.toList());
        JobTaskInfo taskInfo = new JobTaskInfo(jobDAG.getEdges(), pluginConfigs);
        this.checkConfigIntegrity(version, taskInfo);
        List<JobLine> lines = jobDAG.getEdges().stream().map(e -> {
            try {
                return JobLine.builder().id(CodeGenerateUtils.getInstance().genCode()).inputPluginId(e.getInputPluginId()).targetPluginId(e.getTargetPluginId()).versionId(jobVersionId).build();
            }
            catch (CodeGenerateUtils.CodeGenerateException ex) {
                throw new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{ex.getMessage()});
            }
        }).collect(Collectors.toList());
        try {
            JobTaskCheckRes jobTaskCheckRes = this.checkPluginSchemaIntegrity(taskInfo);
            if (jobTaskCheckRes != null) {
                return jobTaskCheckRes;
            }
            this.jobInstanceService.generateJobConfig(version.getJobId(), tasks, lines, version.getEnv());
        }
        catch (SeaTunnelException e2) {
            log.error(ExceptionUtils.getMessage((Throwable)e2));
            throw e2;
        }
        catch (Exception e3) {
            throw new SeatunnelException(SeatunnelErrorEnum.ERROR_CONFIG, new Object[]{e3.getMessage()});
        }
        this.jobLineDao.deleteLinesByVersionId(jobVersionId);
        this.jobLineDao.insertLines(lines);
        return null;
    }

    private JobTaskCheckRes checkPluginSchemaIntegrity(JobTaskInfo taskInfo) throws IOException {
        List source = taskInfo.getPlugins().stream().filter(p -> p.getType().equals((Object)PluginType.SOURCE)).collect(Collectors.toList());
        Map<String, PluginConfig> pluginMap = taskInfo.getPlugins().stream().collect(Collectors.toMap(PluginConfig::getPluginId, Function.identity()));
        Map<String, String> edgeMap = taskInfo.getEdges().stream().collect(Collectors.toMap(Edge::getInputPluginId, Edge::getTargetPluginId));
        for (PluginConfig config : source) {
            PluginConfig nextConfig;
            JobTaskCheckRes res = this.checkNextTaskSchema(config, nextConfig = (PluginConfig)pluginMap.get(edgeMap.get(config.getPluginId())), pluginMap, edgeMap);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private JobTaskCheckRes checkNextTaskSchema(PluginConfig config, PluginConfig nextConfig, Map<String, PluginConfig> pluginMap, Map<String, String> edgeMap) throws IOException {
        Map<String, Object> options = nextConfig.getTransformOptions();
        if (options != null && !options.isEmpty()) {
            Transform transform = Transform.valueOf(nextConfig.getConnectorType().toUpperCase());
            String transformOptionsStr = OBJECT_MAPPER.writeValueAsString(options);
            ArrayList<TransformOption> transformOptions = new ArrayList<TransformOption>();
            switch (transform) {
                case FIELDMAPPER: {
                    FieldMapperTransformOptions fieldMapperTransformOptions = (FieldMapperTransformOptions)TaskOptionUtils.getTransformOption(transform, transformOptionsStr);
                    if (fieldMapperTransformOptions == null) break;
                    JobTaskServiceImpl.fillTransformOptions(transformOptions, fieldMapperTransformOptions.getRenameFields());
                    JobTaskServiceImpl.fillTransformOptions(transformOptions, fieldMapperTransformOptions.getChangeOrders());
                    break;
                }
                case MULTIFIELDSPLIT: {
                    SplitTransformOptions splitTransformOptions = (SplitTransformOptions)TaskOptionUtils.getTransformOption(transform, transformOptionsStr);
                    if (splitTransformOptions == null) break;
                    JobTaskServiceImpl.fillTransformOptions(transformOptions, splitTransformOptions.getSplits());
                    break;
                }
                case COPY: {
                    CopyTransformOptions copyTransformOptions = (CopyTransformOptions)TaskOptionUtils.getTransformOption(transform, transformOptionsStr);
                    if (copyTransformOptions == null) break;
                    JobTaskServiceImpl.fillTransformOptions(transformOptions, copyTransformOptions.getCopyList());
                    break;
                }
                case SQL: {
                    SQLTransformOptions sqlTransformOptions = (SQLTransformOptions)TaskOptionUtils.getTransformOption(transform, transformOptionsStr);
                    if (sqlTransformOptions == null) break;
                    JobTaskServiceImpl.fillTransformOptions(transformOptions, Collections.singletonList(sqlTransformOptions.getSql()));
                    break;
                }
                default: {
                    throw new SeatunnelException(SeatunnelErrorEnum.UNSUPPORTED_CONNECTOR_TYPE, new Object[]{"Unsupported Transform Option " + (Object)((Object)transform)});
                }
            }
            if (!transformOptions.isEmpty()) {
                DatabaseTableSchemaReq databaseTableSchemaReq = config.getOutputSchema().get(0);
                List fields = databaseTableSchemaReq.getFields().stream().map(TableField::getName).collect(Collectors.toList());
                Optional<TransformOption> transformOption = transformOptions.stream().filter(option -> !fields.contains(option.getSourceFieldName())).findFirst();
                if (transformOption.isPresent()) {
                    String sourceFiledName = transformOption.get().getSourceFieldName();
                    return new JobTaskCheckRes(false, nextConfig.getPluginId(), new SchemaError(databaseTableSchemaReq.getDatabase(), databaseTableSchemaReq.getTableName(), sourceFiledName, SchemaErrorType.MISS_FIELD), null);
                }
            }
        }
        if (edgeMap.containsKey(nextConfig.getPluginId())) {
            return this.checkNextTaskSchema(nextConfig, pluginMap.get(edgeMap.get(nextConfig.getPluginId())), pluginMap, edgeMap);
        }
        return null;
    }

    private static void fillTransformOptions(List<TransformOption> transformOptions, List<? extends TransformOption> options) {
        if (options != null) {
            transformOptions.addAll(options);
        }
    }

    @Override
    public void saveSingleTask(long jobVersionId, PluginConfig pluginConfig) {
        JobTask jobTask;
        this.funcPermissionCheck("project:seatunnel-task:task-create", 0);
        JobTask old = this.jobTaskDao.getTask(jobVersionId, pluginConfig.getPluginId());
        try {
            String connectorType;
            JobTaskServiceImpl.checkConfigFormat(pluginConfig.getConfig());
            long id = old != null ? old.getId().longValue() : CodeGenerateUtils.getInstance().genCode();
            String transformOptionsStr = null;
            if (pluginConfig.getType().equals((Object)PluginType.TRANSFORM)) {
                connectorType = pluginConfig.getConnectorType();
                if (pluginConfig.getTransformOptions() != null) {
                    transformOptionsStr = OBJECT_MAPPER.writeValueAsString(pluginConfig.getTransformOptions());
                }
                this.transformOptionCheck(connectorType, transformOptionsStr);
            } else {
                connectorType = this.getConnectorTypeFromDataSource(pluginConfig.getDataSourceId());
            }
            jobTask = JobTask.builder().id(id).pluginId(pluginConfig.getPluginId()).name(pluginConfig.getName()).type(pluginConfig.getType().name().toUpperCase()).dataSourceId(pluginConfig.getDataSourceId()).config(pluginConfig.getConfig()).sceneMode(pluginConfig.getSceneMode() == null ? null : pluginConfig.getSceneMode().name()).versionId(jobVersionId).connectorType(connectorType).dataSourceOption(pluginConfig.getTableOption() == null ? null : OBJECT_MAPPER.writeValueAsString((Object)pluginConfig.getTableOption())).selectTableFields(pluginConfig.getSelectTableFields() == null ? null : OBJECT_MAPPER.writeValueAsString((Object)pluginConfig.getSelectTableFields())).outputSchema(pluginConfig.getOutputSchema() == null ? null : OBJECT_MAPPER.writeValueAsString(pluginConfig.getOutputSchema())).transformOptions(transformOptionsStr).build();
        }
        catch (Exception e) {
            throw new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{e.getMessage()});
        }
        if (old != null) {
            this.jobTaskDao.updateTask(jobTask);
        } else {
            this.jobTaskDao.insertTask(jobTask);
        }
    }

    private void transformOptionCheck(String connectorType, String transformOptionsStr) throws IOException {
        Transform transform = Transform.valueOf(connectorType.toUpperCase());
        switch (transform) {
            case FIELDMAPPER: {
                FieldMapperTransformOptions fieldMapperTransformOptions = (FieldMapperTransformOptions)TaskOptionUtils.getTransformOption(transform, transformOptionsStr);
                if (fieldMapperTransformOptions == null) break;
                List<RenameField> renameFields = fieldMapperTransformOptions.getRenameFields();
                this.checkTransformTargetFieldRepeat(renameFields.stream().map(RenameField::getTargetName).collect(Collectors.toList()));
                break;
            }
            case MULTIFIELDSPLIT: {
                SplitTransformOptions splitTransformOptions = (SplitTransformOptions)TaskOptionUtils.getTransformOption(transform, transformOptionsStr);
                if (splitTransformOptions == null) break;
                List<String> fields = splitTransformOptions.getSplits().stream().flatMap(split -> split.getOutputFields().stream()).collect(Collectors.toList());
                this.checkTransformTargetFieldRepeat(fields);
                break;
            }
            case COPY: {
                CopyTransformOptions copyTransformOptions = (CopyTransformOptions)TaskOptionUtils.getTransformOption(transform, transformOptionsStr);
                if (copyTransformOptions == null) break;
                List<String> fields = copyTransformOptions.getCopyList().stream().map(Copy::getTargetFieldName).collect(Collectors.toList());
                this.checkTransformTargetFieldRepeat(fields);
                break;
            }
            case SQL: {
                SQLTransformOptions sqlTransformOptions = (SQLTransformOptions)TaskOptionUtils.getTransformOption(transform, transformOptionsStr);
                if (sqlTransformOptions == null) break;
                ArrayList<String> fields = new ArrayList<String>();
                this.checkTransformTargetFieldRepeat(fields);
                break;
            }
        }
    }

    private void checkTransformTargetFieldRepeat(List<String> fields) {
        Set duplicates = fields.stream().filter(i -> Collections.frequency(fields, i) > 1).collect(Collectors.toSet());
        if (!duplicates.isEmpty()) {
            throw new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{"Can't convert same target name: " + new ArrayList(duplicates)});
        }
    }

    @Override
    public PluginConfig getSingleTask(long jobVersionId, String pluginId) {
        this.funcPermissionCheck("project:seatunnel-task:task-detail", 0);
        return JobTaskServiceImpl.getPluginConfigFromJobTask(this.jobTaskDao.getTask(jobVersionId, pluginId));
    }

    @Override
    public <T extends TransformOptions> T getTransformOptions(long jobVersionId, String pluginId) {
        JobTask jobTask = this.jobTaskDao.getTask(jobVersionId, pluginId);
        try {
            Transform transform = Transform.valueOf(jobTask.getConnectorType().toUpperCase());
            return TaskOptionUtils.getTransformOption(transform, jobTask.getTransformOptions());
        }
        catch (IOException e) {
            throw new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{e.getMessage()});
        }
    }

    @Override
    public void deleteSingleTask(long jobVersionId, String pluginId) {
        this.funcPermissionCheck("project:seatunnel-task:task-delete", 0);
        this.jobTaskDao.deleteTask(jobVersionId, pluginId);
    }

    @Override
    public void deleteTaskByVersionId(long id) {
        this.funcPermissionCheck("project:seatunnel-task:task-delete", 0);
        this.jobTaskDao.deleteTaskByVersionId(id);
    }

    private String getConnectorTypeFromDataSource(long datasourceId) {
        String pluginName = this.datasourceService.queryDatasourceDetailById(String.valueOf(datasourceId)).getPluginName();
        return this.connectorDataSourceMapperConfig.findConnectorForDatasourceName(pluginName).orElseThrow(() -> new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{"can not find connector for datasourceName: " + pluginName}));
    }

    private static PluginConfig getPluginConfigFromJobTask(JobTask jobTask) {
        try {
            return PluginConfig.builder().pluginId(jobTask.getPluginId()).name(jobTask.getName()).type(PluginType.valueOf((String)jobTask.getType().toUpperCase())).dataSourceId(jobTask.getDataSourceId()).config(jobTask.getConfig()).connectorType(jobTask.getConnectorType()).sceneMode(StringUtils.isEmpty((CharSequence)jobTask.getSceneMode()) ? null : SceneMode.valueOf(jobTask.getSceneMode())).tableOption(StringUtils.isEmpty((CharSequence)jobTask.getDataSourceOption()) ? null : (DataSourceOption)OBJECT_MAPPER.readValue(jobTask.getDataSourceOption(), DataSourceOption.class)).selectTableFields(StringUtils.isEmpty((CharSequence)jobTask.getSelectTableFields()) ? null : (SelectTableFields)OBJECT_MAPPER.readValue(jobTask.getSelectTableFields(), SelectTableFields.class)).outputSchema(StringUtils.isEmpty((CharSequence)jobTask.getOutputSchema()) ? null : (List)OBJECT_MAPPER.readValue(jobTask.getOutputSchema(), (TypeReference)new TypeReference<List<DatabaseTableSchemaReq>>(){})).transformOptions(StringUtils.isEmpty((CharSequence)jobTask.getTransformOptions()) ? null : (Map)OBJECT_MAPPER.readValue(jobTask.getTransformOptions(), (TypeReference)new TypeReference<Map<String, Object>>(){})).config(jobTask.getConfig()).build();
        }
        catch (Exception e) {
            throw new SeatunnelException(SeatunnelErrorEnum.UNKNOWN, new Object[]{e.getMessage()});
        }
    }
}

