/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.sql.zeta;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.transform.exception.TransformException;
import org.apache.seatunnel.transform.sql.zeta.ZetaUDF;

public class ZetaSQLType {
    public static final String DECIMAL = "DECIMAL";
    public static final String VARCHAR = "VARCHAR";
    public static final String STRING = "STRING";
    public static final String INT = "INT";
    public static final String INTEGER = "INTEGER";
    public static final String BIGINT = "BIGINT";
    public static final String LONG = "LONG";
    public static final String BYTE = "BYTE";
    public static final String DOUBLE = "DOUBLE";
    public static final String FLOAT = "FLOAT";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String DATETIME = "DATETIME";
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    private final SeaTunnelRowType inputRowType;
    private final List<ZetaUDF> udfList;

    public ZetaSQLType(SeaTunnelRowType inputRowType, List<ZetaUDF> udfList) {
        this.inputRowType = inputRowType;
        this.udfList = udfList;
    }

    public SeaTunnelDataType<?> getExpressionType(Expression expression) {
        if (expression instanceof NullValue) {
            return BasicType.VOID_TYPE;
        }
        if (expression instanceof DoubleValue) {
            return BasicType.DOUBLE_TYPE;
        }
        if (expression instanceof LongValue) {
            long longVal = ((LongValue)expression).getValue();
            if (longVal <= Integer.MAX_VALUE && longVal >= Integer.MIN_VALUE) {
                return BasicType.INT_TYPE;
            }
            return BasicType.LONG_TYPE;
        }
        if (expression instanceof StringValue) {
            return BasicType.STRING_TYPE;
        }
        if (expression instanceof Column) {
            String columnName = ((Column)expression).getColumnName();
            return this.inputRowType.getFieldType(this.inputRowType.indexOf(columnName));
        }
        if (expression instanceof Function) {
            return this.getFunctionType((Function)expression);
        }
        if (expression instanceof TimeKeyExpression) {
            return this.getTimeKeyExprType((TimeKeyExpression)expression);
        }
        if (expression instanceof ExtractExpression) {
            return BasicType.INT_TYPE;
        }
        if (expression instanceof Parenthesis) {
            Parenthesis parenthesis = (Parenthesis)expression;
            return this.getExpressionType(parenthesis.getExpression());
        }
        if (expression instanceof Concat) {
            return BasicType.STRING_TYPE;
        }
        if (expression instanceof CastExpression) {
            return this.getCastType((CastExpression)expression);
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            SeaTunnelDataType<?> leftType = this.getExpressionType(binaryExpression.getLeftExpression());
            SeaTunnelDataType<?> rightType = this.getExpressionType(binaryExpression.getRightExpression());
            if (leftType.getSqlType() == SqlType.INT && rightType.getSqlType() == SqlType.INT) {
                return BasicType.INT_TYPE;
            }
            if (!(leftType.getSqlType() != SqlType.INT && leftType.getSqlType() != SqlType.BIGINT || rightType.getSqlType() != SqlType.INT && rightType.getSqlType() != SqlType.BIGINT)) {
                return BasicType.LONG_TYPE;
            }
            if (leftType.getSqlType() == SqlType.DECIMAL || rightType.getSqlType() == SqlType.DECIMAL) {
                DecimalType decimalType;
                int precision = 0;
                int scale = 0;
                if (leftType.getSqlType() == SqlType.DECIMAL) {
                    decimalType = (DecimalType)leftType;
                    precision = decimalType.getPrecision();
                    scale = decimalType.getScale();
                }
                if (rightType.getSqlType() == SqlType.DECIMAL) {
                    decimalType = (DecimalType)rightType;
                    precision = Math.max(decimalType.getPrecision(), precision);
                    scale = Math.max(decimalType.getScale(), scale);
                }
                return new DecimalType(precision, scale);
            }
            if (leftType.getSqlType() == SqlType.FLOAT || leftType.getSqlType() == SqlType.DOUBLE || rightType.getSqlType() == SqlType.FLOAT || rightType.getSqlType() == SqlType.DOUBLE) {
                return BasicType.DOUBLE_TYPE;
            }
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Unsupported SQL Expression: %s ", expression.toString()));
    }

    private SeaTunnelDataType<?> getCastType(CastExpression castExpression) {
        String dataType = castExpression.getType().getDataType();
        switch (dataType.toUpperCase()) {
            case "DECIMAL": {
                List<String> ps = castExpression.getType().getArgumentsStringList();
                return new DecimalType(Integer.parseInt(ps.get(0)), Integer.parseInt(ps.get(1)));
            }
            case "VARCHAR": 
            case "STRING": {
                return BasicType.STRING_TYPE;
            }
            case "INT": 
            case "INTEGER": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": 
            case "LONG": {
                return BasicType.LONG_TYPE;
            }
            case "BYTE": {
                return BasicType.BYTE_TYPE;
            }
            case "DOUBLE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "FLOAT": {
                return BasicType.FLOAT_TYPE;
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Unsupported CAST AS type: %s", dataType));
    }

    private SeaTunnelDataType<?> getFunctionType(Function function) {
        switch (function.getName().toUpperCase()) {
            case "CHAR": 
            case "CHR": 
            case "CONCAT": 
            case "CONCAT_WS": 
            case "HEXTORAW": 
            case "RAWTOHEX": 
            case "INSERT": 
            case "LOWER": 
            case "LCASE": 
            case "UPPER": 
            case "UCASE": 
            case "LEFT": 
            case "RIGHT": 
            case "LPAD": 
            case "RPAD": 
            case "LTRIM": 
            case "RTRIM": 
            case "TRIM": 
            case "REGEXP_REPLACE": 
            case "REGEXP_SUBSTR": 
            case "REPEAT": 
            case "REPLACE": 
            case "SOUNDEX": 
            case "SPACE": 
            case "SUBSTRING": 
            case "SUBSTR": 
            case "TO_CHAR": 
            case "TRANSLATE": 
            case "DAYNAME": 
            case "MONTHNAME": 
            case "FORMATDATETIME": {
                return BasicType.STRING_TYPE;
            }
            case "ASCII": 
            case "LOCATE": 
            case "INSTR": 
            case "POSITION": 
            case "CEIL": 
            case "CEILING": 
            case "FLOOR": 
            case "DAY_OF_MONTH": 
            case "DAY_OF_WEEK": 
            case "DAY_OF_YEAR": 
            case "EXTRACT": 
            case "HOUR": 
            case "MINUTE": 
            case "MONTH": 
            case "QUARTER": 
            case "SECOND": 
            case "WEEK": 
            case "YEAR": 
            case "SIGN": {
                return BasicType.INT_TYPE;
            }
            case "BIT_LENGTH": 
            case "CHAR_LENGTH": 
            case "LENGTH": 
            case "OCTET_LENGTH": 
            case "DATEDIFF": {
                return BasicType.LONG_TYPE;
            }
            case "REGEXP_LIKE": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "ACOS": 
            case "ASIN": 
            case "ATAN": 
            case "COS": 
            case "COSH": 
            case "COT": 
            case "SIN": 
            case "SINH": 
            case "TAN": 
            case "TANH": 
            case "ATAN2": 
            case "EXP": 
            case "LN": 
            case "LOG": 
            case "LOG10": 
            case "RADIANS": 
            case "SQRT": 
            case "PI": 
            case "POWER": 
            case "RAND": 
            case "RANDOM": 
            case "TRUNC": 
            case "TRUNCATE": {
                return BasicType.DOUBLE_TYPE;
            }
            case "NOW": 
            case "DATE_TRUNC": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case "PARSEDATETIME": 
            case "TO_DATE": {
                String format = function.getParameters().getExpressions().get(1).toString();
                if (format.contains("yy") && format.contains("mm")) {
                    return LocalTimeType.LOCAL_DATE_TIME_TYPE;
                }
                if (format.contains("yy")) {
                    return LocalTimeType.LOCAL_DATE_TYPE;
                }
                if (format.contains("mm")) {
                    return LocalTimeType.LOCAL_TIME_TYPE;
                }
                throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Unknown pattern letter %s for function: %s", format, function.getName()));
            }
            case "ABS": 
            case "DATEADD": 
            case "TIMESTAMPADD": 
            case "ROUND": 
            case "NULLIF": 
            case "COALESCE": 
            case "IFNULL": {
                return this.getExpressionType(function.getParameters().getExpressions().get(0));
            }
            case "MOD": {
                return this.getExpressionType(function.getParameters().getExpressions().get(1));
            }
        }
        for (ZetaUDF udf : this.udfList) {
            List<Expression> expressions;
            if (!udf.functionName().equalsIgnoreCase(function.getName())) continue;
            ArrayList argsType = new ArrayList();
            ExpressionList expressionList = function.getParameters();
            if (expressionList != null && (expressions = expressionList.getExpressions()) != null) {
                for (Expression expression : expressions) {
                    argsType.add(this.getExpressionType(expression));
                }
            }
            return udf.resultType(argsType);
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Unsupported function: %s ", function.getName()));
    }

    private SeaTunnelDataType<?> getTimeKeyExprType(TimeKeyExpression timeKeyExpression) {
        switch (timeKeyExpression.getStringValue().toUpperCase()) {
            case "CURRENT_DATE": 
            case "CURRENT_DATE()": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "CURRENT_TIME": 
            case "CURRENT_TIME()": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "CURRENT_TIMESTAMP": 
            case "CURRENT_TIMESTAMP()": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
        }
        throw new TransformException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, String.format("Unsupported TimeKey expression: %s ", timeKeyExpression.getStringValue()));
    }
}

