/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.IndexConfigCodec;
import com.hazelcast.config.IndexConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;

public final class MCGetMapConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x200300;
    public static final int RESPONSE_MESSAGE_TYPE = 2097921;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_IN_MEMORY_FORMAT_FIELD_OFFSET = 13;
    private static final int RESPONSE_BACKUP_COUNT_FIELD_OFFSET = 17;
    private static final int RESPONSE_ASYNC_BACKUP_COUNT_FIELD_OFFSET = 21;
    private static final int RESPONSE_TIME_TO_LIVE_SECONDS_FIELD_OFFSET = 25;
    private static final int RESPONSE_MAX_IDLE_SECONDS_FIELD_OFFSET = 29;
    private static final int RESPONSE_MAX_SIZE_FIELD_OFFSET = 33;
    private static final int RESPONSE_MAX_SIZE_POLICY_FIELD_OFFSET = 37;
    private static final int RESPONSE_READ_BACKUP_DATA_FIELD_OFFSET = 41;
    private static final int RESPONSE_EVICTION_POLICY_FIELD_OFFSET = 42;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 46;

    private MCGetMapConfigCodec() {
    }

    public static ClientMessage encodeRequest(String mapName) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("MC.GetMapConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x200300);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, mapName);
        return clientMessage;
    }

    public static String decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        iterator.next();
        return StringCodec.decode(iterator);
    }

    public static ClientMessage encodeResponse(int inMemoryFormat, int backupCount, int asyncBackupCount, int timeToLiveSeconds, int maxIdleSeconds, int maxSize, int maxSizePolicy, boolean readBackupData, int evictionPolicy, String mergePolicy, Collection<IndexConfig> globalIndexes) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[46], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2097921);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 13, inMemoryFormat);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 17, backupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 21, asyncBackupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 25, timeToLiveSeconds);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 29, maxIdleSeconds);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 33, maxSize);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 37, maxSizePolicy);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 41, readBackupData);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 42, evictionPolicy);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, mergePolicy);
        ListMultiFrameCodec.encode(clientMessage, globalIndexes, IndexConfigCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.inMemoryFormat = FixedSizeTypesCodec.decodeInt(initialFrame.content, 13);
        response.backupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 17);
        response.asyncBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 21);
        response.timeToLiveSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 25);
        response.maxIdleSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 29);
        response.maxSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 33);
        response.maxSizePolicy = FixedSizeTypesCodec.decodeInt(initialFrame.content, 37);
        response.readBackupData = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 41);
        response.evictionPolicy = FixedSizeTypesCodec.decodeInt(initialFrame.content, 42);
        response.mergePolicy = StringCodec.decode(iterator);
        if (iterator.hasNext()) {
            response.globalIndexes = ListMultiFrameCodec.decode(iterator, IndexConfigCodec::decode);
            response.isGlobalIndexesExists = true;
        } else {
            response.isGlobalIndexesExists = false;
        }
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public int inMemoryFormat;
        public int backupCount;
        public int asyncBackupCount;
        public int timeToLiveSeconds;
        public int maxIdleSeconds;
        public int maxSize;
        public int maxSizePolicy;
        public boolean readBackupData;
        public int evictionPolicy;
        public String mergePolicy;
        public List<IndexConfig> globalIndexes;
        public boolean isGlobalIndexesExists;
    }
}

