"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTeleport = exports.isActive = exports.disconnect = exports.connect = void 0;
const vue_demi_1 = require("vue-demi");
let active = false;
const items = (0, vue_demi_1.reactive)({});
function connect(id, component, container, node, graph) {
    if (active) {
        items[id] = (0, vue_demi_1.markRaw)((0, vue_demi_1.defineComponent)({
            render: () => (0, vue_demi_1.h)(vue_demi_1.Teleport, { to: container }, [(0, vue_demi_1.h)(component, { node, graph })]),
            provide: () => ({
                getNode: () => node,
                getGraph: () => graph,
            }),
        }));
    }
}
exports.connect = connect;
function disconnect(id) {
    if (active) {
        delete items[id];
    }
}
exports.disconnect = disconnect;
function isActive() {
    return active;
}
exports.isActive = isActive;
function getTeleport() {
    if (!vue_demi_1.isVue3) {
        throw new Error('teleport is only available in Vue3');
    }
    active = true;
    return (0, vue_demi_1.defineComponent)({
        setup() {
            return () => (0, vue_demi_1.h)(vue_demi_1.Fragment, {}, Object.keys(items).map((id) => (0, vue_demi_1.h)(items[id])));
        },
    });
}
exports.getTeleport = getTeleport;
//# sourceMappingURL=teleport.js.map