/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.sink;

import com.hazelcast.cluster.Address;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.SinkAggregatedCommitterTask;

public class SinkRegisterOperation
extends Operation
implements IdentifiedDataSerializable {
    private static final ILogger LOGGER = Logger.getLogger(SinkRegisterOperation.class);
    private TaskLocation writerTaskID;
    private TaskLocation committerTaskID;

    public SinkRegisterOperation() {
    }

    public SinkRegisterOperation(TaskLocation writerTaskID, TaskLocation committerTaskID) {
        this.writerTaskID = writerTaskID;
        this.committerTaskID = committerTaskID;
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        Address readerAddress = this.getCallerAddress();
        RetryUtils.retryWithException(() -> {
            SinkAggregatedCommitterTask task = (SinkAggregatedCommitterTask)server.getTaskExecutionService().getTask(this.committerTaskID);
            task.receivedWriterRegister(this.writerTaskID, readerAddress);
            return null;
        }, new RetryUtils.RetryMaterial(30, true, e -> e instanceof TaskGroupContextNotFoundException || e instanceof NullPointerException, 2000L));
    }

    @Override
    public String getServiceName() {
        return "st:impl:seaTunnelServer";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.writerTaskID);
        out.writeObject(this.committerTaskID);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.writerTaskID = (TaskLocation)in.readObject();
        this.committerTaskID = (TaskLocation)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 7;
    }
}

