/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.fake.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.seatunnel.connectors.seatunnel.fake.config.FakeConfig;

public class FakeDataRandomUtils {
    private final FakeConfig fakeConfig;

    public FakeDataRandomUtils(FakeConfig fakeConfig) {
        this.fakeConfig = fakeConfig;
    }

    private static <T> T randomFromList(List<T> list) {
        int index = RandomUtils.nextInt((int)0, (int)list.size());
        return list.get(index);
    }

    public Boolean randomBoolean() {
        return RandomUtils.nextInt((int)0, (int)2) == 1;
    }

    public BigDecimal randomBigDecimal(int precision, int scale) {
        return new BigDecimal(RandomStringUtils.randomNumeric((int)(precision - scale)) + "." + RandomStringUtils.randomNumeric((int)scale));
    }

    public byte[] randomBytes() {
        return RandomStringUtils.randomAlphabetic((int)this.fakeConfig.getBytesLength()).getBytes();
    }

    public String randomString() {
        List<String> stringTemplate = this.fakeConfig.getStringTemplate();
        if (!CollectionUtils.isEmpty(stringTemplate)) {
            return FakeDataRandomUtils.randomFromList(stringTemplate);
        }
        return RandomStringUtils.randomAlphabetic((int)this.fakeConfig.getStringLength());
    }

    public Byte randomTinyint() {
        List<Integer> tinyintTemplate = this.fakeConfig.getTinyintTemplate();
        if (!CollectionUtils.isEmpty(tinyintTemplate)) {
            return FakeDataRandomUtils.randomFromList(tinyintTemplate).byteValue();
        }
        return (byte)RandomUtils.nextInt((int)this.fakeConfig.getTinyintMin(), (int)this.fakeConfig.getTinyintMax());
    }

    public Short randomSmallint() {
        List<Integer> smallintTemplate = this.fakeConfig.getSmallintTemplate();
        if (!CollectionUtils.isEmpty(smallintTemplate)) {
            return FakeDataRandomUtils.randomFromList(smallintTemplate).shortValue();
        }
        return (short)RandomUtils.nextInt((int)this.fakeConfig.getSmallintMin(), (int)this.fakeConfig.getSmallintMax());
    }

    public Integer randomInt() {
        List<Integer> intTemplate = this.fakeConfig.getIntTemplate();
        if (!CollectionUtils.isEmpty(intTemplate)) {
            return FakeDataRandomUtils.randomFromList(intTemplate);
        }
        return RandomUtils.nextInt((int)this.fakeConfig.getIntMin(), (int)this.fakeConfig.getIntMax());
    }

    public Long randomBigint() {
        List<Long> bigTemplate = this.fakeConfig.getBigTemplate();
        if (!CollectionUtils.isEmpty(bigTemplate)) {
            return FakeDataRandomUtils.randomFromList(bigTemplate);
        }
        return RandomUtils.nextLong((long)this.fakeConfig.getBigintMin(), (long)this.fakeConfig.getBigintMax());
    }

    public Float randomFloat() {
        List<Double> floatTemplate = this.fakeConfig.getFloatTemplate();
        if (!CollectionUtils.isEmpty(floatTemplate)) {
            return Float.valueOf(FakeDataRandomUtils.randomFromList(floatTemplate).floatValue());
        }
        return Float.valueOf(RandomUtils.nextFloat((float)((float)this.fakeConfig.getFloatMin()), (float)((float)this.fakeConfig.getFloatMax())));
    }

    public Double randomDouble() {
        List<Double> doubleTemplate = this.fakeConfig.getDoubleTemplate();
        if (!CollectionUtils.isEmpty(doubleTemplate)) {
            return FakeDataRandomUtils.randomFromList(doubleTemplate);
        }
        return RandomUtils.nextDouble((double)this.fakeConfig.getDoubleMin(), (double)this.fakeConfig.getDoubleMax());
    }

    public LocalDate randomLocalDate() {
        return this.randomLocalDateTime().toLocalDate();
    }

    public LocalTime randomLocalTime() {
        return this.randomLocalDateTime().toLocalTime();
    }

    public LocalDateTime randomLocalDateTime() {
        int year = !CollectionUtils.isEmpty(this.fakeConfig.getDateYearTemplate()) ? FakeDataRandomUtils.randomFromList(this.fakeConfig.getDateYearTemplate()).intValue() : LocalDateTime.now().getYear();
        int month = !CollectionUtils.isEmpty(this.fakeConfig.getDateMonthTemplate()) ? FakeDataRandomUtils.randomFromList(this.fakeConfig.getDateMonthTemplate()) : RandomUtils.nextInt((int)1, (int)13);
        int day = !CollectionUtils.isEmpty(this.fakeConfig.getDateDayTemplate()) ? FakeDataRandomUtils.randomFromList(this.fakeConfig.getDateDayTemplate()) : RandomUtils.nextInt((int)1, (int)29);
        int hour = !CollectionUtils.isEmpty(this.fakeConfig.getTimeHourTemplate()) ? FakeDataRandomUtils.randomFromList(this.fakeConfig.getTimeHourTemplate()) : RandomUtils.nextInt((int)0, (int)24);
        int minute = !CollectionUtils.isEmpty(this.fakeConfig.getTimeMinuteTemplate()) ? FakeDataRandomUtils.randomFromList(this.fakeConfig.getTimeMinuteTemplate()) : RandomUtils.nextInt((int)0, (int)60);
        int second = !CollectionUtils.isEmpty(this.fakeConfig.getTimeSecondTemplate()) ? FakeDataRandomUtils.randomFromList(this.fakeConfig.getTimeSecondTemplate()) : RandomUtils.nextInt((int)0, (int)60);
        return LocalDateTime.of(year, month, day, hour, minute, second);
    }
}

