/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json;

import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.format.json.RowToJsonConverters;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;

public class JsonSerializationSchema
implements SerializationSchema {
    public static final String FORMAT = "Common";
    private final SeaTunnelRowType rowType;
    private transient ObjectNode node;
    private final ObjectMapper mapper = new ObjectMapper();
    private final Charset charset;
    private final RowToJsonConverters.RowToJsonConverter runtimeConverter;

    public JsonSerializationSchema(SeaTunnelRowType rowType) {
        this(rowType, StandardCharsets.UTF_8);
    }

    public JsonSerializationSchema(SeaTunnelRowType rowType, Charset charset) {
        this.rowType = rowType;
        this.runtimeConverter = new RowToJsonConverters().createConverter((SeaTunnelDataType)Preconditions.checkNotNull((Object)rowType));
        this.charset = charset;
    }

    public byte[] serialize(SeaTunnelRow row) {
        if (this.node == null) {
            this.node = this.mapper.createObjectNode();
        }
        try {
            this.runtimeConverter.convert(this.mapper, (JsonNode)this.node, row);
            return this.mapper.writeValueAsString((Object)this.node).getBytes(this.charset);
        }
        catch (Throwable t) {
            throw CommonError.jsonOperationError((String)FORMAT, (String)row.toString(), (Throwable)t);
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

